// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <fstream>
#include <algorithm>
#include "imap4item.h"
#include "imap4boxlist.h"
#include "imap4mailbox.h"

imap4boxlist::~imap4boxlist(void) {
}

imap4boxlist::imap4boxlist(const char *host, const char *u,
			   const char *pr, const char *p)
  : user(u), password(p), prefix(pr) {
  addr.sin_family=AF_INET;
  const char *div=strchr(host, ':');
  struct hostent *ent;
  if(div) {
    string s(host, 0, div-host);
    ent=gethostbyname(s.c_str());
    addr.sin_port=htons(atoi(div+1));
  } else {
    ent=gethostbyname(host);
    addr.sin_port=htons(143);
  }
  if(!ent) return;
  addr.sin_addr=*(struct in_addr *)ent->h_addr;

  int sock=imap4login(addr, u, p);
  if(sock<0) return;
  fstream imap4(sock);
  (imap4<<"0 LIST "<<imap4item(imap4item::STRING, pr)<<" %\r\n").flush();
  int c;
  while((c=imap4.get())=='*') {
    imap4item x;
    imap4>>x>>x>>x>>x;
    const char *y=x.get_text();
    if(y[strlen(y)-1]!='/') names.push_back(y);
    while((c=imap4.get())>=0&&c!='\n');
  }
  imap4.close();
  sort(names.begin(), names.end());
}

bool
imap4boxlist::move(const char *from, const char *to) const {
  int sock=imap4login(addr, user.c_str(), password.c_str());
  if(sock<0) return false;
  fstream imap4(sock);
  (imap4<<"0 RENAME "<<imap4item(imap4item::STRING, from)<<
   ' '<<imap4item(imap4item::STRING, to)<<"\r\n").flush();
  char buf[1024];
  imap4.getline(buf, sizeof(buf));
  if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
    imap4.close();
    return false;
  }
  imap4.close();
  return true;
}

bool
imap4boxlist::remove(const char *name) const {
  int sock=imap4login(addr, user.c_str(), password.c_str());
  if(sock<0) return false;
  fstream imap4(sock);
  (imap4<<"0 DELETE "<<imap4item(imap4item::STRING, name)<<"\r\n").flush();
  char buf[1024];
  imap4.getline(buf, sizeof(buf));
  if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
    imap4.close();
    return false;
  }
  imap4.close();
  return true;
}

bool
imap4boxlist::create(const char *name) const {
  int sock=imap4login(addr, user.c_str(), password.c_str());
  if(sock<0) return false;
  fstream imap4(sock);
  (imap4<<"0 CREATE "<<imap4item(imap4item::STRING, name)<<"\r\n").flush();
  char buf[1024];
  imap4.getline(buf, sizeof(buf));
  if(imap4.fail()||strncmp(buf, "0 OK", 4)) {
    imap4.close();
    return false;
  }
  imap4.close();
  return true;
}

mailbox *
imap4boxlist::openbox(const char *name) const {
  return new imap4mailbox(addr, user.c_str(), password.c_str(), name);
}
