// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _BOXLIST_H
#define _BOXLIST_H

#include <vector>
#include <string>
#include "mailbox.h"

class boxlist {
public:
  virtual ~boxlist(void);

  int size(void) const { return names.size(); }
  const char *operator[](int which) const { return names[which].c_str(); }

  virtual bool move(const char *, const char *) const=0;
  virtual bool remove(const char *) const=0;
  virtual bool create(const char *) const=0;
  virtual mailbox *openbox(const char *) const=0;

protected:
  vector<string> names;
};

#endif
