// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software

#include "tgws.h"
#include "unix.h"
#include "composition.h"
#include "localboxlist.h"
#include "localmailbox.h"
#include <ctype.h>
#include <fstream>

void
tty_grin_menu(void) {
  tgws::active_screen->push();

  {
    tgws::title *t=new tgws::title("TTY-Grin");
    t->size(1, COLS);
    t->position(0, 0);
    t->show();

    tgws::keyblock *k=new tgws::keyblock;
    k->add("I", _("Inbox"));
    k->add("M", _("Mail"));
    k->add("N", _("News"));
    k->add("P", _("IMAP4"));
    k->add("C", _("Compose"));
    k->add("R", _("Resume"));
    k->add("A", _("Address books"));
    k->add("Q", _("Quit"));
    k->size(2, COLS);
    k->position(LINES-2, 0);
    k->show();
  }

  tgws::pinemenu *m=new tgws::pinemenu;
  m->add_item('I', _("I     INBOX"),
	      _("- Read new mail"));
  m->add_item('M', _("M     MAIL"),
	      _("- Browse local mailboxes"));
  m->add_item('N', _("N     NEWS"),
	      _("- Browse newsgroups"));
  m->add_item('P', _("P     IMAP4"),
	      _("- Use IMAP4rev1 profiles"));
  m->add_item('C', _("C     COMPOSE"),
	      _("- Create a new message"));
  m->add_item('R', _("R     RESUME"),
	      _("- Continue a postponed message"));
  m->add_item('A', _("A     ADDRESS BOOKS"),
	      _("- Add, delete and modify addresses"));
  m->add_item('Q', _("Q     QUIT"),
	      _("- Exit TTY-Grin"));
  m->set_left(20);
  m->size(LINES-7, COLS-20);
  m->position(4, 10);
  m->show();

  int key(0);
  do {
    key=m->run();
    if(islower(key)) key-=32;
    switch(key) {
    case 'A': tty_grin_addresses(); break;
    case 'C':
      {
	composition c;
	try {
	  ifstream signature(config_get_string("SIGNATURE"));
	  if(signature.good()) {
	    c.append("\n\n--\n");
	    c.append(signature);
	    signature.close();
	  }
	}
	catch(config_error e) { }
	tty_grin_composition(c, _("New message"));
      }
      break;
    case 'R':
      {
	tgws::active_screen->push();
	tgws::pilot *p=new tgws::pilot;
	p->size(LINES, COLS);
	p->position(0, 0);
	p->show();
	int key;
	do {
	  key=p->run();
	} while(key!=3&&key!='\n');
	if(key=='\n') {
	  ifstream in(p->get_filename());
	  if(in.good()) {
	    composition resume;
	    char buffer[1024];
	    in.getline(buffer, sizeof(buffer));
	    while(!in.fail()&&buffer[0]) {
	      char *x=strchr(buffer, ':');
	      if(x) {
		*(x++)=0;
		resume.set_header(buffer, ++x);
	      }
	      in.getline(buffer, sizeof(buffer));
	    }
	    resume.append(in);
	    in.close();
	    tty_grin_composition(resume, _("Postponed message"));
	  }
	}
	tgws::active_screen->pop();
      }
      break;
    case 'M':
      try {
	localboxlist b(config_get_string("LOCAL-MAIL"));
	tty_grin_mail(b, _("Local mail"));
      }
      catch(config_error e) { }
      break;
    case 'I':
      try {
	localmailbox in(config_get_string("INBOX"));
	tty_grin_mailbox(in, _("Inbox"));
      }
      catch(config_error e) { }
      break;
    case 'P': tty_grin_imap4(); break;
    case 'N': tty_grin_news(); break;
    }
  } while(key!='Q');
  tgws::active_screen->pop();
}
