// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <dirent.h>
#include <unistd.h>
#include <fcntl.h>
#include <vector>
#include <algorithm>
#include "tgws.h"

tgws::pilot::pilot(void) : files(false), textentry(true),
			   savedir(-1), dir(1), file(1),
			   prompt("Filename (tab to browse):") {
  prompt.size(1, 30);
  browse();
}

void
tgws::pilot::size(int h, int w) {
  input::size(h, w);
  dirname.size(1, w);
  dir.size(h-2, w/2);
  dir.set_width(0, w/2);
  file.size(h-2, w/2);
  file.set_width(0, w/2);
  file.position(line+1, column+w/2);
  filename.size(1, w-30);
  filename.position(line+h-1, column+30);
  prompt.position(line+h-1, column);
}

void
tgws::pilot::position(int l, int c) {
  input::position(l, c);
  dirname.position(l, c);
  dir.position(l+1, c);
  file.position(l+1, c+width/2);
  filename.position(l+height-1, c+30);
  prompt.position(l+height-1, c);
}

void
tgws::pilot::draw(bool running) {
  dirname.draw();
  dir.draw();
  file.draw();
  filename.draw();
  prompt.draw();
}

int
tgws::pilot::run(void) {
  swapdir();
  for(;;) {
    draw();
    if(textentry) {
      int key;
      if((key=filename.run())=='\t') textentry=false;
      else {
	swapdir();
	return key;
      }
    } else switch(int key=(files?file.run():dir.run())) {
    case KEY_LEFT:
      if(files) files=false;
      else {
	swapdir();
	return key;
      }
      break;
    case KEY_RIGHT:
      if(files||file.empty()) {
	swapdir();
	return key;
      } else files=true;
      break;
    case '\t': textentry=true; break;
    case '\n':
      if(files) {
	filename.set_text("/");
	filename.prepend_text(dirname.get_text());
	filename.append_text(file.get_cursor()->get_text(0));
	textentry=true;
      } else if(!chdir(dir.get_cursor()->get_text(0))) browse();
      break;
    default:
      swapdir();
      return key;
    }
  }
}

void
tgws::pilot::browse(void) {
  {
    char buf[MAXPATHLEN];
    getcwd(buf, sizeof(buf));
    dirname.set_text(buf);
  }

  vector<string> directories, files;

  DIR *d=opendir(".");
  if(d) {
    struct dirent *e;
    while((e=readdir(d))) if(e->d_name[0]!='.') {
      struct stat info;
      stat(e->d_name, &info);
      if((info.st_mode&S_IFMT)==S_IFDIR) directories.push_back(e->d_name);
      else if((info.st_mode&S_IFMT)==S_IFREG) files.push_back(e->d_name);
    }
    closedir(d);
  }

  dir.clear();
  dir.insert(0)->set_text(0, "..");
  sort(directories.begin(), directories.end());
  for(vector<string>::const_iterator i=directories.begin();
      i!=directories.end();i++) dir.insert(0)->set_text(0, (*i).c_str());

  file.clear();
  sort(files.begin(), files.end());
  for(vector<string>::const_iterator i=files.begin();
      i!=files.end();i++) file.insert(0)->set_text(0, (*i).c_str());
}

void
tgws::pilot::swapdir(void) {
  int thisdir=open(".", O_RDONLY);
  if(savedir>0) {
    fchdir(savedir);
    close(savedir);
  }
  savedir=thisdir;
}

void
tgws::pilot::show(void) {
  dir.show();
  file.show();
  dirname.show();
  filename.show();
  prompt.show();
}

void
tgws::pilot::hide(void) {
  dir.hide();
  file.hide();
  dirname.hide();
  filename.hide();
  prompt.hide();
}
