// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <ctype.h>
#include "tgws.h"

void
tgws::error_message(const char *what) {
  tgws::label e(what);

  e.size(1, COLS);
  e.position(LINES-1, 0);
  e.show();
  doupdate();
  getch();
}

bool
tgws::get_line(const char *what, string& buffer) {
  tgws::label l(what);
  int len=strlen(what);

  l.size(1, len);
  l.position(LINES-1, 0);
  l.show();

  tgws::entry e;
  e.size(1, COLS-len);
  e.position(LINES-1, len);
  e.show();

  int x;
  do {
    x=e.run();
  } while(x!='\n'&&x!=3);

  if(x=='\n') buffer=e.get_text();
  return x=='\n';
}

bool
tgws::yes_or_no(const char *question) {
  string answer;

  for(;;) {
    while(!get_line(question, answer));
    if(!strcasecmp(answer.c_str(), "yes")) return true;
    if(!strcasecmp(answer.c_str(), "no")) return false;
    tgws::error_message("You must answer \"yes\" or \"no\".");
  }
  return false;
}

int
tgws::choice(const char *prompt, const char *choices, bool sensitive) {
  tgws::label e(prompt);

  e.size(1, COLS);
  e.position(LINES-1, 0);
  e.show();
  doupdate();

  int key;
  const char *r;
  do {
    key=getch();
    if(!sensitive) key=toupper(key);
  } while(!(r=strchr(choices, key)));
  return r-choices;
}
