// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class menu : public input {
  public:
    virtual int run(void);
    virtual void draw(bool=false);

    int add_item(const char *what);
    int add_separator(void) { return add_item(""); }
    int get_cursor_number(void) const { return cursor_number; }
    const char *get_cursor_name(void) const { return (*cursor).c_str(); }
    int count(void) const { return items.size(); }
    
  protected:
    typedef list<string> menu_t;

    menu_t items;
    menu_t::iterator scr, cursor;
    unsigned int scr_number, cursor_number;
  };
};
