// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <termios.h>
#include "tgws.h"

struct termios tgws::old;

void
tgws::init(void) {
  initscr();
  cbreak();
  noecho();
  start_color();
  keypad(stdscr, TRUE);
  default_style.init();
  tcgetattr(0, &old);
  {
    struct termios t(old);
    t.c_lflag&=~ISIG;
    tcsetattr(0, TCSANOW, &t);
  }
}

void
tgws::end(void) {
  tcsetattr(0, TCSANOW, &old);
  endwin();
}

void
tgws::suspend(void) {
  tcsetattr(0, TCSANOW, &old);
  endwin();
}

void
tgws::unsuspend(void) {
  initscr();
  cbreak();
  noecho();
  keypad(stdscr, TRUE);
  tcgetattr(0, &old);
  doupdate();
  {
    struct termios t(old);
    t.c_lflag&=~ISIG;
    tcsetattr(0, TCSANOW, &t);
  }
  active_screen->redraw();
}
