// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class edit : public input {
  public:
    edit(void) { rewrap(); }

    virtual void size(int, int);
    virtual void draw(bool=false);
    virtual int run(void);

    const char *get_text(void) const { return buffer.c_str(); }
    void set_text(const char *what) { buffer=what; rewrap(); }

    void append(istream&);

 protected:
    typedef list<unsigned int> wrap_t;

    crope buffer, cut;
    wrap_t wrap;
    wrap_t::iterator scr_line, cursor_line;
    unsigned int scr, cursor, cursor_column, cursor_line_number,
      scr_line_number, saved_cursor_column, lastcut;

    virtual void draw_line(unsigned int, unsigned int);

    void rewrap(void);
    void cursor_up(void);
    void cursor_down(void);
    void cursor_left(void);
    void cursor_right(void);
    void insert(char);
    void delete_back(void);
    void delete_forward(void);
    void sol(void);
    void eol(void);
    void home(void);
    void end(void);
    void cut_back(void);
    void cut_forward(void);
    void yank(void);
    void bust(void);
    void bust_line(unsigned int, wrap_t::iterator);
    unsigned int where_to_break(unsigned int);
  };
};
