// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "lisp.h"

lisp::hash_table::hash_table(object t) : variable("HASH-TABLE"),
					 test_function(t) {
  if(!is_function(t)) throw error(t, _("Type mismatch"));
}

string
lisp::hash_table::print(void) const {
  string out("#S(HASH-TABLE ");
  out+=test_function.print();
  for(unsigned int i=0;i<data.size();i++) {
    out+=" (";
    out+=data[i].first.print();
    out+=" . ";
    out+=data[i].second.print();
    out+=')';
  }
  out+=')';
  return out;
}

bool
lisp::hash_table::equal(object x) const {
  return x.get_const_data()==this;
}

lisp::object
lisp::hash_table::readhash(library& lib, object key) {
  object argv[]={nil, key};

  for(int i=0;i<size();i++) {
    argv[0]=data[i].first;
    if(!assume_function(test_function).funcall(lib, 2, argv).eq(nil))
      return data[i].second;
  }
  return nil;
}

lisp::weak_object *
lisp::hash_table::gethash(library& lib, object key) {
  object argv[]={nil, key};

  for(int i=0;i<size();i++) {
    argv[0]=data[i].first;
    if(!assume_function(test_function).funcall(lib, 2, argv).eq(nil))
      return &data[i].second;
  }
  data.push_back(pair<object, object>(key, nil));
  return &data.back().second;
}

int
lisp::hash_table::recursive_mark(void) {
  if(get_mark()) return 0;
  int total=1;
  set_mark(true);

  if(!test_function.get_const_data()->get_mark())
    total+=test_function.get_data()->recursive_mark();

  for(vector<pair<weak_object, weak_object> >::iterator i=data.begin();
      i!=data.end();i++) {
    if(!(*i).first.get_const_data()->get_mark())
      total+=(*i).first.get_data()->recursive_mark();
    if(!(*i).second.get_const_data()->get_mark())
      total+=(*i).second.get_data()->recursive_mark();
  }

  return total;
}
