// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class error {
  public:
    error(object c, const char *com) : cause(c), comment(com) { }
    error(const char *com) : comment(com) { }
    void set_cause(object x) { cause=x; }
    object get_cause(void) const { return cause; }
    const char *get_comment(void) const { return comment.c_str(); }
    void set_comment(const char *what) { comment=what; }

  private:
    object cause;
    string comment;
  };
};
