// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "lisp.h"

string
lisp::cons::print(void) const {
  string out("(");

  out+=car.print();
  object d=cdr;
  while(is_cons(d)) {
    out+=' ';
    out+=assume_cons(d).car.print();
    d=assume_cons(d).cdr;
  }
  if(!d.eq(nil)) {
    out+=" . ";
    out+=d.print();
  }
  out+=')';
  return out;
}

bool
lisp::cons::equal(object x) const {
  return is_cons(x)&&assume_cons(x).car.equal(car)&&
    assume_cons(x).cdr.equal(cdr);
}

int
lisp::cons::recursive_mark(void) {
  if(get_mark()) return 0;

  int total=1;
  set_mark(true);

  if(!car.get_const_data()->get_mark())
    total+=car.get_data()->recursive_mark();
  if(!cdr.get_const_data()->get_mark())
    total+=cdr.get_data()->recursive_mark();

  return total;
}
