// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class character : public variable {
  public:
    character(unsigned char c) : variable("CHAR"), data(c) { }
    character(const char *);
    virtual ~character(void);

    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual int recursive_mark(void);

    unsigned char get_char(void) const { return data; }
    void set_char(unsigned char c) { data=c; }

  private:
    unsigned char data;

    static char *names[];
  };

  inline character& assume_character(object o) {
    return *(character *)(o.get_data());
  }

  inline bool is_character(const object o) {
    return dynamic_cast<const character *>(o.get_const_data())!=0;
  }

  inline character& as_character(object o) {
    character *c=dynamic_cast<character *>(o.get_data());
    if(c) return *c;
    throw error(o, _("Type mismatch"));
  }
};
