// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class atom : public variable {
  public:
    atom(void) : variable("SYMBOL") { }
    atom(const char *s) : variable("SYMBOL"), data(s) { }

    const char *get_text(void) const { return data.c_str(); }
    void set_text(const char *what) { data=what; }

    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual int recursive_mark(void);

  protected:
    string data;
  };

  inline atom& assume_atom(object o) { return *(atom *)(o.get_data()); }

  inline bool is_atom(const object o) {
    return dynamic_cast<const atom *>(o.get_const_data())!=0;
  }

  inline atom& as_atom(object o) {
    atom *a=dynamic_cast<atom *>(o.get_data());
    if(a) return *a;
    throw error(o, _("Type mismatch"));
  }
};
