// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <fstream>
#include "grinlisp.h"

void
display_error(lisp::error& e) {
  cerr<<e.get_comment();
  if(!e.get_cause().eq(lisp::nil)) cerr<<": "<<e.get_cause();
  cerr<<endl;
}

void
run(istream& in) {
  lisp::object f;
  grinlisp s;
  lisp::domain d(s);

  s.set_variable("*", lisp::nil);
  s.set_variable("**", lisp::nil);
  s.set_variable("***", lisp::nil);

  try {
    in>>f;
  }
  catch(lisp::error e) {
    display_error(e);
  }
  while(!(in.fail()||in.eof())) {
    try {
      lisp::object x=s.evaluate(d, f);
      s.set_variable("***", s.get_variable("**"));
      s.set_variable("**", s.get_variable("*"));
      s.set_variable("*", x);
    }
    catch(lisp::error e) {
      display_error(e);
    }
    catch(lisp::return_from r) {
      cerr<<_("Invalid return: ")<<r.get_block_name()<<endl;
    }
    lisp::gc();
    try {
      in>>f;
    }
    catch(lisp::error e) {
      display_error(e);
    }
  }
}

int
main(int argc, char *argv[]) {
  if(argc==1) run(cin);
  else {
    for(int i=1;i<argc;i++) {
      ifstream i(argv[i]);
      if(i.good()) run(i);
      i.close();
    }
  }
  lisp::gc();
}
