; Algebraic expression compiler

(defun neg (x) (- 0 x))

(defstruct expr-op level operands leftwise)

(setq expr-ops (make-hash-table))
(setq expr-tokens (make-hash-table :test #'equal))
(dolist (x '((+ 1 2 t "+") (- 1 2 t "-") (* 3 2 t "*") (/ 3 2 t "/")
	     (exp 5 1 nil "ex") (expt 5 2 t "**") (neg 4 1 nil "-x")))
	(setf (gethash (car x) expr-ops)
	      (make-expr-op :level (nth 1 x)
			    :operands (nth 2 x)
			    :leftwise (nth 3 x)))
	(setf (gethash (nth 4 x) expr-tokens) (car x)))

(defun expr-char-type (c)
  (cond
   ((alpha-char-p c) 1)
   ((or (digit-char-p c) (eq c #\.)) 2)
   (t c)))

(defun expr-tokenise (expr)
  (let ((last-break 0) break last-type tokens)
    (loop
     (unless (< last-break (length expr)) (return))
     (setq break last-break)
     (setq last-type (expr-char-type (char expr last-break)))
     (loop
      (unless (and (< break (length expr))
		   (eq (expr-char-type (char expr break)) last-type))
	(return))
      (incf break))
     (let ((token (subseq expr last-break break)))
       (cond
	((funcall (lambda (x) (or (eq x #\.) (digit-char-p x)))
		  (char token 0)) (push (read-from-string token) tokens))
	((equal token "(") (push '\( tokens))
	((equal token ")") (push '\) tokens))
	(t (push token tokens))))
     (setq last-break break))
    (let ((element tokens) token last-element)
      (let ((element tokens))
	(loop
	 (unless element (return))
	 (when (and (stringp (car element))
		    (or (not (cdr element)) (stringp (nth 1 element))))
	   (let ((newtoken (gethash (concatenate 'string (car element) "x")
				    expr-tokens)))
	     (when newtoken (setf (car element) newtoken))))
	 (setq element (cdr element))))
      (setq tokens (reverse tokens))
      (let ((element tokens))
	(loop
	 (unless element (return))
	 (when (and (stringp (car element))
		    (or (not (cdr element)) (stringp (nth 1 element))))
	   (let ((newtoken (gethash (concatenate 'string "x" (car element))
				    expr-tokens)))
	     (when newtoken (setf (car element) newtoken))))
	 (setq element (cdr element))))
      (mapcar (lambda (x) (if (stringp x) (gethash x expr-tokens) x))
	      tokens))))

(defmacro expr-process-token (token-expression)
  (list 'let (list (list 'token token-expression) 'sub)
	'(do ((num (expr-op-operands (gethash token expr-ops)) (1- num)))
	     ((<= num 0))
	     (push (pop data-stack) sub))
	'(push (cons token sub) data-stack)))

(defun expr-allow-push (topstack token)
  (if (eq topstack '\() t
    (let ((topstack-op (gethash topstack expr-ops))
	  (token-op (gethash token expr-ops)))
      (when (and topstack-op token-op)
	(cond
	 ((and (= (expr-op-operands token-op) 1)
	       (not (expr-op-leftwise token-op))) t)
	 ((< (expr-op-level topstack-op) (expr-op-level token-op)) t)
	 ((and (= (expr-op-level topstack-op) (expr-op-level token-op))
	       (expr-op-leftwise token-op)) t)
	 (t nil))))))

(defun expr-compile (expr)
  (let (op-stack data-stack)
    (dolist (token expr)
	    (cond ((numberp token) (push token data-stack))
		  ((eq token '\() (push token op-stack))
		  ((eq token '\))
		   (loop
		    (when (or (not op-stack) (eq (car op-stack) '\()) (return))
		    (expr-process-token (pop op-stack)))
		   (pop op-stack))
		  (t (loop
		      (when (or (not op-stack)
				(expr-allow-push (car op-stack) token))
				(return))
		      (expr-process-token (pop op-stack)))
		     (push token op-stack))))
    (dolist (token op-stack) (expr-process-token token))
    (car data-stack)))

(print (eval
	(print (expr-compile
		(print (expr-tokenise
			(print "10+e2*-4")))))))
