// -*-Mode: C++;-*

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software

#ifndef _IMAP4MAILBOX_H
#define _IMAP4MAILBOX_H

#include <netinet/in.h>
#include <string>
#include "mailbox.h"
#include "imap4item.h"

class imap4mailbox;

class imap4mailbox_message : public message_descriptor {
  friend imap4mailbox;

public:
  imap4mailbox_message(imap4mailbox *p, int n) : parent(p), num(n) { }
  virtual ~imap4mailbox_message(void);
  virtual bool extract(ostream&) const;

private:
  imap4mailbox *parent;
  int num;
  unsigned char oldflags;
};

class imap4mailbox : public mailbox {
  friend imap4mailbox_message;

public:
  imap4mailbox(const struct sockaddr_in&, const char *,
	       const char *, const char *);
  virtual ~imap4mailbox(void);
  virtual message_descriptor& operator[](int which);
  virtual int size(void) const;
  virtual bool append(const message_descriptor&);
  virtual bool append(const message&, unsigned char=0);
  virtual void expunge(void);

private:
  struct sockaddr_in addr;
  string user, password, boxname;
  vector<imap4mailbox_message> messages;

  imap4item flags_to_list(unsigned char);
};

#endif
