// -*-Mode: C++;-*-

// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _ADDRESSBOOK_H
#define _ADDRESSBOOK_H

#include <vector>
#include <string>

class addressbook;

class addressbook_entry {
  friend addressbook;

public:
  addressbook_entry(addressbook *b) : parent(b) { }

  const char *get_key(void) const { return key.c_str(); }
  const char *get_comment(void) const { return comment.c_str(); }
  const char *get_address(void) const { return address.c_str(); }

  void set_key(const char *text);
  void set_comment(const char *text);
  void set_address(const char *text);

private:
  addressbook *parent;
  string key, comment, address;
};

class addressbook {
  friend addressbook_entry;

public:
  addressbook(const char *);
  ~addressbook(void);
  addressbook_entry& operator[](int which) { return entries[which]; }
  int size(void) const { return entries.size(); }
  void clear(void) { entries.clear(); commit=true; }
  addressbook_entry& append(void) {
    entries.push_back(addressbook_entry(this));
    return entries.back();
  }

private:
  bool commit;
  string source_filename;
  vector<addressbook_entry> entries;
};

#endif
