/*
 * Copyright 1998  The XFree86 Project
 *
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 * JOERG POMMNITZ BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 * 
 */

/*
 * XLFD field      | Source
 * ----------------+-----------------------------------------------
 * FOUNDRY         | "OS2 " table, achVendID field
 * FAMILY_NAME     | "name" table, Font Family name
 *                 | "name" table, Postscript name
 * WEIGHT_NAME     | "OS2 " table, fsSelection field bit 5
 *                 | "OS2 " table, PANOSE WEIGHT field
 *                 | "OS2 " table, usWeightClass field
 * SLANT           | "OS2 " table, fsSelection field bit 0
 * SETWIDTH_NAME   | "OS2 " table, usWidthClass field
 *                 | "OS2 " table, PANOSE proportion/aspect field
 * ADD_STYLE_NAME  | empty
 * PIXEL_SIZE      | 0
 * POINT_SIZE      | 0
 * RESOLUTION_X    | 0
 * RESOLUTION_Y    | 0
 * SPACING         | constant for CJK encodings
 *                 | "post" table, isFixedPitch flag
 * AVERAGE_WIDTH   | 0
 * CHARSET_REGISTRY| internal table
 * CHARSET_ENCODING| internal table, test for characters
 */

/*
 * Contributions:
 *
 *   Pablo Saratxaga      : - support for more encodings, japanese 
 *			      (jisx201,jisx208), chinese (gb2312, big5), 
 *	                      korean (kcs5601) and iso-8859-10.
 *                          - enhanced font name lookup 
 *
 * Wed Jul 21 1999 Yuan-Chung Cheng <platin@linux.org.tw>
 * - use properties.os2->ulCodePageRange1 to lookup
 *   font encoding to support modern Unicode encoded 
 *   CJK fonts (platform=3, encoding=1). 
 *   Has been tested with Arphic's and DynaLab's CJK ttf fonts.
 * - foundry ARPH added
 * - support .ttc
 * - font name lookup
 * - big5.et -> big5 
 *   I suggest using big5-0 instead of X-TT's big5.eten-0 or xfsft's big5.et,
 *   big5-0 is what people used in taiwan.
 *
 */

#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_SFNT_NAMES_H
#include FT_TRUETYPE_IDS_H
#include FT_TRUETYPE_TABLES_H

#include "panose.h"
#include "ttos2val.h"

#define TTMKFS_USAGE  1
#define TTMKFS_FTINIT 2
#define TTMKFS_DIR    3
#define TTMKFS_MEM    4
#define TTMKFS_NO_UC  5

#define DEFAULTDIR "."
#define DEFAULTFOUNDRY "misc"

static char *path = NULL;            /* directory with the TTF files, by default the DEFAULTDIR */
static char *default_foundry = NULL; /* the foundry name we can fall back to if we can't figure one out */
static FILE *outstream = NULL;       /* the stream we write our results to */
static int  max_missing = 5;
static int  use_panose = 0;
static int  create_debug_entries = 0;

struct xlfdmapping {
    char mapping[512];
    struct xlfdmapping *next;
};

enum completeness {
    IGNORE,
    STRICT,
    LOOSE
};

static int   parse_argv        (int argc, char *argv[]);
static void  usage             (const char *name);
static const char *get_foundry (const FT_Char orig_code[4]);
static const char *get_name    (FT_Face face);
static const char *get_psname  (FT_Face face);
static const char *get_psname  (FT_Face face);
static void  add_mapping (struct xlfdmapping **listhead,
			  char *file_name,
			  const char *foundry_name,
			  const char *font_name,
			  const char *weight_name,
			  const char *width_name,
			  TT_OS2 *os2,
			  TT_Postscript *post,
			  char *encodingscheme
			  );

static void  free_mappings (struct xlfdmapping **listhead);
static int   has_8bit_encoding (FT_Face face, const int *table);
static const char *get_weight (const char *name, TT_OS2 *os2);
static const char *get_width_name (const char *name, TT_OS2 *os2);


static enum completeness completeness = STRICT;

static int iso8859_1[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
    0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 
    0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff
};

static int iso8859_2[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x0104, 0x02d8, 0x0141, 0x00a4, 0x013d, 0x015a, 0x00a7, 
    0x00a8, 0x0160, 0x015e, 0x0164, 0x0179, 0x00ad, 0x017d, 0x017b, 
    0x00b0, 0x0105, 0x02db, 0x0142, 0x00b4, 0x013e, 0x015b, 0x02c7, 
    0x00b8, 0x0161, 0x015f, 0x0165, 0x017a, 0x02dd, 0x017e, 0x017c, 
    0x0154, 0x00c1, 0x00c2, 0x0102, 0x00c4, 0x0139, 0x0106, 0x00c7, 
    0x010c, 0x00c9, 0x0118, 0x00cb, 0x011a, 0x00cd, 0x00ce, 0x010e, 
    0x0110, 0x0143, 0x0147, 0x00d3, 0x00d4, 0x0150, 0x00d6, 0x00d7, 
    0x0158, 0x016e, 0x00da, 0x0170, 0x00dc, 0x00dd, 0x0162, 0x00df, 
    0x0155, 0x00e1, 0x00e2, 0x0103, 0x00e4, 0x013a, 0x0107, 0x00e7, 
    0x010d, 0x00e9, 0x0119, 0x00eb, 0x011b, 0x00ed, 0x00ee, 0x010f, 
    0x0111, 0x0144, 0x0148, 0x00f3, 0x00f4, 0x0151, 0x00f6, 0x00f7, 
    0x0159, 0x016f, 0x00fa, 0x0171, 0x00fc, 0x00fd, 0x0163, 0x02d9 
};

static int iso8859_3[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x0126, 0x02d8, 0x00a3, 0x00a4,     -1, 0x0124, 0x00a7, 
    0x00a8, 0x0130, 0x015e, 0x011e, 0x0134, 0x00ad,     -1, 0x017b, 
    0x00b0, 0x0127, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x0125, 0x00b7, 
    0x00b8, 0x0131, 0x015f, 0x011f, 0x0135, 0x00bd,     -1, 0x017c, 
    0x00c0, 0x00c1, 0x00c2,     -1, 0x00c4, 0x010a, 0x0108, 0x00c7, 
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
    /**/-1, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x0120, 0x00d6, 0x00d7, 
    0x011c, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x016c, 0x015c, 0x00df, 
    0x00e0, 0x00e1, 0x00e2,     -1, 0x00e4, 0x010b, 0x0109, 0x00e7, 
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 
    /**/-1, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x0121, 0x00f6, 0x00f7, 
    0x011d, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x016d, 0x015d, 0x02d9 
};

static int iso8859_4[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x0104, 0x0138, 0x0156, 0x00a4, 0x0128, 0x013b, 0x00a7, 
    0x00a8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00ad, 0x017d, 0x00af, 
    0x00b0, 0x0105, 0x02db, 0x0157, 0x00b4, 0x0129, 0x013c, 0x02c7, 
    0x00b8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014a, 0x017e, 0x014b, 
    0x0100, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x012e, 
    0x010c, 0x00c9, 0x0118, 0x00cb, 0x0116, 0x00cd, 0x00ce, 0x012a, 
    0x0110, 0x0145, 0x014c, 0x0136, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
    0x00d8, 0x0172, 0x00da, 0x00db, 0x00dc, 0x0168, 0x016a, 0x00df, 
    0x0101, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x012f, 
    0x010d, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x012b, 
    0x0111, 0x0146, 0x014d, 0x0137, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
    0x00f8, 0x0173, 0x00fa, 0x00fb, 0x00fc, 0x0169, 0x016b, 0x02d9 
};

static int iso8859_5[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407, 
    0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 0x00ad, 0x040e, 0x040f, 
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 
    0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 
    0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, 
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 
    0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, 
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 
    0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f, 
    0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 
    0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x00a7, 0x045e, 0x045f 
};

static int iso8859_6[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667, 
    0x0668, 0x0669, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0,     -1,     -1,     -1, 0x00a4,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1, 0x060c, 0x00ad,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1, 0x061b,     -1,     -1,     -1, 0x061f, 
    /**/-1, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, 
    0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f, 
    0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637, 
    0x0638, 0x0639, 0x063a,     -1,     -1,     -1,     -1,     -1, 
    0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647, 
    0x0648, 0x0649, 0x064a, 0x064b, 0x064c, 0x064d, 0x064e, 0x064f, 
    0x0650, 0x0651, 0x0652,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1
};

static int iso8859_7[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x02bd, 0x02bc, 0x00a3,     -1,     -1, 0x00a6, 0x00a7, 
    0x00a8, 0x00a9,     -1, 0x00ab, 0x00ac, 0x00ad,     -1, 0x2015, 
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x0384, 0x0385, 0x0386, 0x00b7, 
    0x0388, 0x0389, 0x038a, 0x00bb, 0x038c, 0x00bd, 0x038e, 0x038f, 
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 
    0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 
    0x03a0, 0x03a1,     -1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 
    0x03a8, 0x03a9, 0x03aa, 0x03ab, 0x03ac, 0x03ad, 0x03ae, 0x03af, 
    0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 
    0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 
    0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 
    0x03c8, 0x03c9, 0x03ca, 0x03cb, 0x03cc, 0x03cd, 0x03ce,     -1
};

static int iso8859_8[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0,     -1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
    0x00a8, 0x00a9, 0x00d7, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x203e, 
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
    0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1, 0x2017, 
    0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 
    0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 
    0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 
    0x05e8, 0x05e9, 0x05ea,     -1,     -1,     -1,     -1,     -1 
};

static int iso8859_9[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf, 
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
    0x011e, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x0130, 0x015e, 0x00df, 
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 
    0x011f, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x0131, 0x015f, 0x00ff 
};

static int iso8859_10[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1,
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    0x00a0, 0x0104, 0x0112, 0x0122, 0x012a, 0x0128, 0x0136, 0x00a7,
    0x013b, 0x0110, 0x0160, 0x0166, 0x017d, 0x00ad, 0x016a, 0x014a,
    0x00b0, 0x0105, 0x0113, 0x0123, 0x012b, 0x0129, 0x0137, 0x00b7,
    0x013c, 0x0111, 0x0161, 0x0167, 0x017e, 0x2014, 0x016b, 0x014b,
    0x0100, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x012e,
    0x010c, 0x00c9, 0x0118, 0x00cb, 0x0116, 0x00cd, 0x00ce, 0x00cf,
    0x00d0, 0x0145, 0x014c, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x0168,
    0x00d8, 0x0172, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df,
    0x0101, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x012f,
    0x010d, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x00ef,
    0x011f, 0x0146, 0x014d, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x0169,
    0x00f8, 0x0173, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x0138
};

static int koi8r[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    0x2500, 0x2502, 0x250c, 0x2510, 0x2514, 0x2518, 0x251c, 0x2524, 
    0x252c, 0x2534, 0x253c, 0x2580, 0x2584, 0x2588, 0x258c, 0x2590, 
    0x2591, 0x2592, 0x2593, 0x2320, 0x2043, 0x2022, 0x221a, 0x2248,
    0x2264, 0x2265, 0x00a0, 0x2321, 0x00b0, 0x00b2, 0x00b7, 0x00f7, 
    0x2550, 0x2551, 0x2552, 0x0451, 0x2553, 0x2554, 0x2555, 0x2556, 
    0x2557, 0x2558, 0x2559, 0x255a, 0x255b, 0x255c, 0x255d, 0x255e, 
    0x255f, 0x2560, 0x2561, 0x0401, 0x2562, 0x2563, 0x2564, 0x2565, 
    0x2566, 0x2567, 0x2568, 0x2569, 0x256a, 0x256b, 0x256c, 0x00a9, 
    0x044e, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 
    0x0445, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
    0x043f, 0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 
    0x044c, 0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 
    0x042e, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 
    0x0425, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 
    0x041f, 0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 
    0x042c, 0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, 0x042a 
};

static int koi8ru[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    0x2500, 0x2502, 0x250c, 0x2510, 0x2514, 0x2518, 0x251c, 0x2524, 
    0x252c, 0x2534, 0x253c, 0x2580, 0x2584, 0x2588, 0x258c, 0x2590, 
    0x2591, 0x2592, 0x2593, 0x201c, 0x2043, 0x2022, 0x201d, 0x2014,
    0x2116, 0x2122, 0x00a0, 0x00bb, 0x00ae, 0x00ab, 0x00b7, 0x00a4, 
    0x2550, 0x2551, 0x2552, 0x0451, 0x0454, 0x2554, 0x0456, 0x0457, 
    0x2557, 0x2558, 0x2559, 0x255a, 0x255b, 0x0491, 0x045e, 0x255e, 
    0x255f, 0x2560, 0x2561, 0x0401, 0x0404, 0x2563, 0x0406, 0x0407, 
    0x2566, 0x2567, 0x2568, 0x2569, 0x256a, 0x0490, 0x040e, 0x00a9, 
    0x044e, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 
    0x0445, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
    0x043f, 0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 
    0x044c, 0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 
    0x042e, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 
    0x0425, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 
    0x041f, 0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 
    0x042c, 0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, 0x042a 
};

static int koi8r1[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    /**/-1,     -1,     -1, 0x2320, 0x2043, 0x2022, 0x221a, 0x2248, 
    0x2264, 0x2265, 0x00a0, 0x2321, 0x00b0, 0x00b2, 0x00b7, 0x00f7, 
    /**/-1,     -1,     -1, 0x0451,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1, 0x0401,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1, 0x00a9, 
    0x044e, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 
    0x0445, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
    0x043f, 0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 
    0x044c, 0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 
    0x042e, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 
    0x0425, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 
    0x041f, 0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 
    0x042c, 0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, 0x042a, 
};

static int koi8ru1[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
    /**/-1,     -1,     -1, 0x201c, 0x2043, 0x2022, 0x201d, 0x2014, 
    0x2116, 0x2122, 0x00a0, 0x00bb, 0x00ae, 0x00ab, 0x00b7, 0x00a4, 
    /**/-1,     -1,     -1, 0x0451, 0x0454,     -1, 0x0456, 0x0457, 
    /**/-1,     -1,     -1,     -1,     -1, 0x0491, 0x045e,     -1, 
    /**/-1,     -1,     -1, 0x0401, 0x0404,     -1, 0x0406, 0x0407, 
    /**/-1,     -1,     -1,     -1,     -1, 0x0490, 0x040e, 0x00a9, 
    0x044e, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433, 
    0x0445, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
    0x043f, 0x044f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432, 
    0x044c, 0x044b, 0x0437, 0x0448, 0x044d, 0x0449, 0x0447, 0x044a, 
    0x042e, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413, 
    0x0425, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 
    0x041f, 0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412, 
    0x042c, 0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427, 0x042a, 
};

static int A_Z_letters[224] = {
    0x0020,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,
};

static int iso8859_15[224] = {
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    /**/-1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x20ac, 0x00a5, 0x0160, 0x00a7, 
    0x0161, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af, 
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x017d, 0x00b5, 0x00b6, 0x00b7, 
    0x017e, 0x00b9, 0x00ba, 0x00bb, 0x0152, 0x0153, 0x0178, 0x00bf, 
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7, 
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf, 
    0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7, 
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df, 
    0x00e0, 0x00e1, 0x00e2, 0x00e3, 0x00e4, 0x00e5, 0x00e6, 0x00e7, 
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x00ec, 0x00ed, 0x00ee, 0x00ef, 
    0x00f0, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x00ff
};

/* ####################### */
#define ALTCHR	-1

static int jisx0201[224] = {
    /* 0x0020 - 0x00DF */
    0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005A, 0x005B, 0x00A5, 0x005D, 0x005E, 0x005F,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E/*0x203E*/, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65, 0xFF66, 0xFF67,
    0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D, 0xFF6E, 0xFF6F,
    0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75, 0xFF76, 0xFF77,
    0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E, 0xFF7F,
    0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85, 0xFF86, 0xFF87,
    0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D, 0xFF8E, 0xFF8F,
    0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF97,
    0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D, 0xFF9E, 0xFF9F,
    /* 0x00E0 - 0x00FF */
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR,
    ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR, ALTCHR
};

const char*  Apple_Encodings[33] =
{
  "Roman", "Japanese", "Chinese", "Korean", "Arabic", "Hebrew",
  "Greek", "Russian", "RSymbol", "Devanagari", "Gurmukhi",
  "Gujarati", "Oriya", "Bengali", "Tamil", "Telugu", "Kannada",
  "Malayalam", "Sinhalese", "Burmese", "Khmer", "Tai", "Laotian",
  "Georgian", "Armenian", "Maldivian/Simplif. Chinese", "Tibetan",
  "Mongolian", "Geez", "Slavic", "Vietnamese", "Sindhi", "Uninterpreted"
};


int
main (int argc, char *argv[])
{
    int n = 0;
    int i;
    FT_Error fterror;
    FT_Library library;
    struct xlfdmapping  *head = NULL;
    struct xlfdmapping  *p;
    FT_Face face;
    TT_OS2 *os2;
    TT_Postscript *post;
    const char *font_name;
    const char *font_psname;
    const char *foundry_name;
    const char *weight_name;
    const char *width_name;
    char *platStr=NULL;
    char *encoStr=NULL;
    char  tempStr[128];
    FT_ULong face_num;
    FT_ULong face_index = 0;
    char ch;

    /* first parse the command line */
    if (parse_argv (argc, argv) < 0) {
	usage (argv [0]);
	return TTMKFS_USAGE;
    }
    /* initialize the FreeType library */
    fterror = FT_Init_FreeType (&library);

    if (fterror) {
	fprintf (stderr, "FT_Init_FreeType failed with %d\n", fterror);
	return TTMKFS_FTINIT;
    }
    
    
    /* open the TTF file */
    fterror = FT_New_Face (library, path, 0, &face);
	
    if (fterror != FT_Err_Ok) {
      fprintf (stderr, "FT_Open_Face failed with %d for file %s\n", fterror, path);
      return TTMKFS_USAGE;
    }

    face_num = face->num_faces;
    /* ask user to specify a face if there are more then one face in the font */    if(face_num > 1){
        /* print the name of every font faces */
        fprintf (stderr, "%lu font faces found in %s\n", face_num, path);
        
        for(face_index = 0; face_index < face_num; face_index++){
            FT_New_Face(library, path, face_index, &face);
            fprintf (stderr, "  Face #%lu: %s\n", face_index, get_name (face));
        }
        /* ask user to select one */
        /* if the user enters garbage, then use the first face as default */
        face_index = 0;
        fprintf(stderr, "Select a font face (default: 0): ");
        while((ch = getchar()) && ch >= '0' && ch <= '9')
            face_index = face_index * 10 + (ch - '0');
        if(face_index >= face_num)
            face_index = 0;
        /* re-open the TTC file */
        FT_New_Face(library, path, face_index, &face);
    }

    os2 = FT_Get_Sfnt_Table(face, ft_sfnt_os2);
    if ( !os2 ) {
        fprintf (stderr, "FT_Get_Sfnt_Table failed to load the OS/2 table for file %s\n", path);
        return TTMKFS_USAGE;
    }
    post = FT_Get_Sfnt_Table(face, ft_sfnt_post);
    if ( !post ) {
        fprintf (stderr, "FT_Get_Sfnt_Table failed to load the PostScript table for file %s\n", path);
        return TTMKFS_USAGE;
    }

    font_name    = get_name (face);
    font_psname  = get_psname (face);
    foundry_name = get_foundry (os2->achVendID);
    weight_name  = get_weight (path, os2);
    width_name   = get_width_name (path, os2);

    /* basic fone information */
    fprintf(outstream,"TTFINFO_FONT_FILE=\"%s\"\n",path);
    fprintf(outstream,"TTFINFO_FACE_NUM=\"%lu\"\n",face_num);
    fprintf(outstream,"TTFINFO_FACE_INDEX=\"%lu\"\n",face_index);
    fprintf(outstream,"TTFINFO_FONT_NAME=\"%s\"\n",font_name);
    fprintf(outstream,"TTFINFO_FONT_PSNAME=\"%s\"\n",font_psname);
    fprintf(outstream,"TTFINFO_FOUNDRY_NAME=\"%s\"\n",foundry_name);
    fprintf(outstream,"TTFINFO_WEIGHT_NAME=\"%s\"\n",weight_name);
    fprintf(outstream,"TTFINFO_WIDTH=\"%s\"\n",width_name);
    
    fprintf(outstream,"TTFINFO_NUMCMAP=\"%d\"\n",face->num_charmaps);

    for (i = 0; i < face->num_charmaps; i++) {
      FT_UShort platform;
      FT_UShort encoding;
      
      platform = face->charmaps[i]->platform_id;
      encoding = face->charmaps[i]->encoding_id;
      
      /* get the cmap name */
      switch ( platform ) {
      case TT_PLATFORM_APPLE_UNICODE:
	platStr = "Apple Unicode";
	switch ( encoding )
	  {
	  case TT_APPLE_ID_DEFAULT:
	    encoStr = "";
	    break;
	    
	  case TT_APPLE_ID_UNICODE_1_1:
	    encoStr = "(v.1.1)";
	    break;
	    
	  case TT_APPLE_ID_ISO_10646:
	    encoStr = "(ISO 10646-1:1993)";
	    break;
	    
	  case TT_APPLE_ID_UNICODE_2_0:
	    encoStr = "(v.2.0)";
	    break;
	    
	  default:
	    sprintf( tempStr,"Unknown %d", encoding );
	    encoStr = tempStr;
	  }
	break;
	
      case TT_PLATFORM_MACINTOSH:
	platStr = "Apple";
	if ( encoding > 32 )
	  {
	    sprintf( tempStr,"Unknown %d", encoding );
	      encoStr = tempStr;
	  }
	else
	  encoStr = (char*)Apple_Encodings[encoding];
	break;
	
      case TT_PLATFORM_ISO:
	platStr = "Iso";
	switch ( encoding )
	  {
	  case TT_ISO_ID_7BIT_ASCII:
	    platStr = "Ascii";
	    encoStr = "7-bit";
	    break;
	    
	  case TT_ISO_ID_10646:
	    encoStr = "10646";
	    break;
	    
	  case TT_ISO_ID_8859_1:
	    encoStr = "8859-1";
	    break;
	    
         default:
           sprintf( tempStr, "%d", encoding );
           encoStr = tempStr;
	  }
	break;
	
      case TT_PLATFORM_MICROSOFT:
	platStr = "Windows";
	switch ( encoding )
	  {
	  case TT_MS_ID_SYMBOL_CS:
	    encoStr = "Symbol";
	    break;
	    
	  case TT_MS_ID_UNICODE_CS:
	      encoStr = "Unicode";
	      break;
	      
	  case TT_MS_ID_SJIS:
	    encoStr = "Shift-JIS";
	    break;
	    
	  case TT_MS_ID_GB2312:
	    encoStr = "GB2312";
	    break;
	      
	  case TT_MS_ID_BIG_5:
	    encoStr = "Big 5";
	    break;
	      
	  case TT_MS_ID_WANSUNG:
	    encoStr = "WanSung";
	    break;
	      
	  case TT_MS_ID_JOHAB:
	    encoStr = "Johab";
	    break;
	    
	  default:
	    sprintf( tempStr,"Unknown %d", encoding );
	      encoStr = tempStr;
	  }
	break;

      default:
	sprintf( tempStr, "%d - %d", platform, encoding );
	platStr = "Unknown";
	encoStr = tempStr;
      }

      /* print the cmap info... */
      fprintf(outstream,"TTFINFO_CMAP%d=\"%d,%d\"\n", i, platform, encoding);
      /* print the cmap name */
      fprintf(outstream,"TTFINFO_CMAPNAME%d=\"%s,%s\"\n", i, platStr, encoStr );

    /* find the font string from the MS Map */

      if (platform == TT_PLATFORM_MICROSOFT) {
	switch (encoding) {
	case TT_MS_ID_UNICODE_CS:
	  {
	    /* check the 8-bit encoding */
	    struct {
	      int *table;
	      char *encoding;
	      enum completeness completeness;
	    } *p, char_mappings [] = {
	      {iso8859_1,  "iso8859-1",  STRICT},
	      {iso8859_2,  "iso8859-2",  IGNORE},
	      {iso8859_3,  "iso8859-3",  IGNORE},
	      {iso8859_4,  "iso8859-4",  IGNORE},
	      {iso8859_5,  "iso8859-5",  IGNORE},
	      {iso8859_6,  "iso8859-6",  IGNORE},
	      {iso8859_7,  "iso8859-7",  IGNORE},
	      {iso8859_8,  "iso8859-8",  IGNORE},
	      {iso8859_9,  "iso8859-9",  IGNORE},
	      {iso8859_10, "iso8859-10", IGNORE},
	      {iso8859_15, "iso8859-15", IGNORE},
	      {iso8859_15, "fcd8859-15", IGNORE}, /* X11R6.4p2 */
	      {koi8r,      "koi8-r",     STRICT},
	      {koi8ru,     "koi8-ru",    STRICT},
	      {koi8r1,     "koi8-r",     LOOSE},
	      {koi8ru1,    "koi8-ru",    LOOSE},
	      {jisx0201,   "jisx0201.1976-0", STRICT},
	      {A_Z_letters,"iso8859-1",  LOOSE},
	      {NULL,       NULL,         IGNORE}
	    };
	    
	    fterror = FT_Set_Charmap(face, face->charmaps[i]);
	    
	    for (p = char_mappings; p->table; p++) {
	      if ((p->completeness == IGNORE) || (p->completeness == completeness)) {
		if (has_8bit_encoding (face, p->table)) {
		  add_mapping (&head, path, foundry_name,
			       font_name, weight_name, width_name,
			       os2, post, p->encoding); n++;
		}
	      }
	    }
	    /* test code to see the UnicodeRange field,
	       later we should use this to lookup the encoding 
	       supported
	       {
	       int i;
	       FT_ULong mask=1L;
	       printf("%s\n",path);
	       for(i=0;i<32;i++){
	       if((os2->ulUnicodeRange1) & mask)
	       printf("bit %2d =1 !!\n",i);
	       mask = mask << 1;
	       }
	       mask=1L;
	       for(i=32;i<64;i++){
	       if((os2->ulUnicodeRange2) & mask)
	       printf("bit %2d =1 !!\n",i);
	       mask = mask << 1;
	       }
	       }
	    */
	    /* see the CJK encoding in the OS/2 table */
	    if ( os2->ulCodePageRange1 & TT_CODEPAGE_RANGE_932){
	      add_mapping (&head, path, foundry_name,
			   font_name, weight_name, width_name,
			   os2, post, "jisx0208.1983-0");
	      n++;
	    }
	    if ( os2->ulCodePageRange1 & TT_CODEPAGE_RANGE_936){
	      add_mapping (&head, path, foundry_name,
			   font_name, weight_name, width_name,
			   os2, post, "gb2312.1980-0");
	      n++;
	    }
	    if ( os2->ulCodePageRange1 & TT_CODEPAGE_RANGE_950){
	      add_mapping (&head, path, foundry_name,
			   font_name, weight_name, width_name,
			   os2, post, "big5-0");
	      n++;
	    }
	    if ( os2->ulCodePageRange1 & TT_CODEPAGE_RANGE_949){
	      add_mapping (&head, path, foundry_name,
			   font_name, weight_name, width_name,
			   os2, post, "ksc5601.1987-0");
	      n++;
	    }
	    if ( os2->ulCodePageRange1 & TT_CODEPAGE_RANGE_1361){
	      add_mapping (&head, path, foundry_name,
			   font_name, weight_name, width_name,
			   os2, post, "ksc5601.1987-0");
	      n++;
	    }
	  }
	  break;
	case TT_MS_ID_SJIS:
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "jisx0208.1983-0"); n++;
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "jisx0201.1976-0"); n++;
	  break;
	case TT_MS_ID_GB2312:
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "gb2312.1980-0"); n++;
	  
	  break;
	case TT_MS_ID_BIG_5:
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "big5-0"); n++;

	  break;
	case TT_MS_ID_WANSUNG:
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "ksc5601.1987-0"); n++;
	  
	  break;
	case TT_MS_ID_JOHAB:
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "ksc5601.1987-0"); n++;
	  
	  break;
	case TT_MS_ID_SYMBOL_CS:
	  add_mapping (&head, path, foundry_name,
		       font_name, weight_name, width_name,
		       os2, post, "microsoft-symbol"); n++;
	  break;
	}
      }
    }
    
    if (create_debug_entries) {
      add_mapping (&head, path, foundry_name,
		   font_name, weight_name, width_name,
		   os2, post, "truetype-raw"); n++;
    }
    
    /* we are done with this file */
    FT_Done_Face (face);
    
    /* now write the number of mappings we actually got */
    fprintf(outstream,"TTFINFO_MAPNUM=\"%d\"\n", n);
    /* and append our collected mappings */
    i=1;
    for (p = head; p; p = p->next) {
      fprintf(outstream,"TTFINFO_FONTMAP%d=\"%s\"\n",i++,p->mapping);
    }

    /* shut down */
    FT_Done_FreeType (library);
    fclose (outstream);
    
    return 0;
}

int
parse_argv (int argc, char *argv[])
{
    int c;

    while ((c = getopt (argc, argv, "f:o:m:cpg")) != -1) {
	switch (c) {
        case 'o':
	  outstream = fopen (optarg, "w");
	  if (outstream == NULL) {
	    fprintf (stderr, "Could not open file %s: %s\n", optarg, strerror (errno));
	    return -1;
	  }
	  break;
	case 'f':
	  default_foundry = strdup (optarg);
	  break;
	case 'm':
	  max_missing = atoi (optarg);
	  break;
	case 'c':
	  completeness = LOOSE;
	  break;
	case 'p':
	  use_panose = 1;
	  break;
	case 'g':
	  create_debug_entries = 1;
	  break;
	default:
	case '?':
	case ':':
	  return -1;
	  break;
	}
    }
    
    if (optind != argc-1) {
      return -1;
    }

    path = strdup (argv[argc-1]);
    
    if (default_foundry == NULL)
      default_foundry = strdup (DEFAULTFOUNDRY);
    
    if (outstream == 0) {
      outstream = stdout;
    }
    
    return 0;
}

void
usage (const char *name)
{
    fprintf (stderr, "This Program is modified by Cheng Yuan-Chung from \n");
    fprintf (stderr, "Joerg Pommnitz's ttmkfdir, 1999.\n\n");
    fprintf (stderr, "Usage: %s [-f foundry] [-m #] filename \n", name);
    fprintf (stderr, "   -o write output to file named filename (def. stdout)\n");
    fprintf (stderr, "   -f use foundry for unknown font vendors (def. "DEFAULTFOUNDRY")\n");
    fprintf (stderr, "   -m max # of missing characters per encoding (def. 5)\n");
    fprintf (stderr, "   -c use less strict completeness tests for encoding tables\n");
    fprintf (stderr, "   -p use panose information\n");
}

const char *
get_foundry (const FT_Char orig_code[4])
{

    char code[5];
    static struct {
	const char  code[4];	/* TTF foundry code */
	const char *xlfd;	/* xlfd foundry name */
    } *p, known_foundries[] = {
	{ "ADBE", "adobe"},
	{ "AGFA", "agfa"},
	{ "ALTS", "altsys"},
	{ "APPL", "apple"},
	{ "ARPH", "Arphic"},
	{ "B&H",  "b&h"},
	{ "B&H ", "b&h"},
	{ "BERT", "berthold"},
	{ "BITM", "bitmapsoftware"},
	{ "BITS", "bitstream"},
	{ "C&C",  "Carter & Cone"},
	{ "C&C ", "Carter & Cone"},
	{ "CANO", "cannon"},
	{ "CTDL", "China Type Design Ltd."},
	{ "DSCI", "Design Science, Inc."},
	{ "DTC",  "Digital Typeface Corp."},
	{ "DTC ", "Digital Typeface Corp."},
	{ "DYNA", "DynaLab"},
	{ "EDGE", "Rivers Edge Corp."},
	{ "ELSE", "elseware"},
	{ "EPSN", "epson"},
	{ "ERAM", "eraman"},
	{ "FBI",  "fbi"},
	{ "FBI ", "fbi"},
	{ "FJ",   "Fujitsu"},
	{ "FJ  ", "Fujitsu"},
	{ "GALA", "galapagos"},
	{ "GLYF", "Glyph Systems"},
	{ "GPI",  "Gamma Productions, Inc."},
	{ "GPI ", "Gamma Productions, Inc."},
	{ "HANY", "Hanyi"},     /* Hanyi, http://www.hanyi.com.cn/  */
	{ "HGEC", "Huaguang"},  /* Beida Huaguang, http://www.hg.com.cn/ */
	{ "HWAN", "Hwan"},      /* Hwan Design Inc. */
	{ "HP",   "hp"},
	{ "HP  ", "hp"},
	{ "HY",   "HanYang System"},
	{ "HY  ", "HanYang System"},
	{ "IBM",  "IBM"},
	{ "IBM ", "IBM"},
	{ "IDF",  "International Digital Fonts"},
	{ "IDF ", "International Digital Fonts"},
	{ "ILP",  "Indigenous Languages Project"},
	{ "ILP ", "Indigenous Languages Project"},
	{ "ITC",  "itc"},
	{ "ITC ", "itc"},
	{ "IMPR", "impress"},
	{ "JBHG", "JBHG"},
	{ "KATF", "katf"},
	{ "LANS", "Lanston Type Co., Ltd."},
	{ "LEAF", "interleaf"},
	{ "LETR", "letraset"},
	{ "LINO", "linotype"},
	{ "LP",   "letterPerfect"},
	{ "LP  ", "letterPerfect"},
	{ "LTRX", "lighttracks"},
	{ "MACR", "macromedia"},
	{ "MLGC", "micrologic"},
	{ "MONO", "monotype"},
	{ "MS",   "microsoft"},
	{ "MS  ", "microsoft"},
	{ "MT",   "monotype"},
	{ "MT  ", "monotype"},
	{ "NEC",  "nec"},
	{ "NEC ", "nec"},
	{ "PARA", "paragraph"},
	{ "PRFS", "Production First Software"},
	{ "QMSI", "QMS/Imagen"},
	{ "RICO", "Ricoh"},
	{ "SFUN", "Soft Union"},
	{ "SOHO", "Soft Horizons"},
	{ "SWFT", "Swfte International"},
	{ "TILD", "SIA Tilde"},
	{ "UNKN", DEFAULTFOUNDRY},
	{ "URW",  "urw"},
	{ "URW ", "urw"},
	{ "VLKF", "Visualogik Technology & Design"},
	{ "ZSFT", "ZSoft"},
	{ {0,},   NULL}
    };

    code[0] = toupper(orig_code[0]);
    code[1] = toupper(orig_code[1]);
    code[2] = toupper(orig_code[2]);
    code[3] = toupper(orig_code[3]);
    code[4] = 0;
    for (p = known_foundries; p->xlfd; p++) {
	if (memcmp (p->code, code, strlen (code)) == 0) {
	    return p->xlfd;
	}
    }

    return default_foundry;
}

/*
 * This function is cut&paste from the FreeType-1.0 sample program
 * ftdump with minor editing.
 */

const char *
get_name (FT_Face face)
{
    int i, j, k, n;

    FT_SfntName        aname;

    /* get the number of name strings in this font */
    if ((n = FT_Get_Sfnt_Name_Count (face)) < 0) {
	return NULL;
    }
    /* printf("\nn=%d\n",n); */
    /* We do the loop two times, the first we look at TT_NAME_ID_FONT_FAMILY
       entries; and at the second time at TT_NAME_ID_PS_NAME. Of course the
       function returns as soon as an english name for the font is found,
       so most of the time one loop is enough; however some fonts have only
       non-english names in their font family entry, so the second loop
       to try the Postscript name as last resort
    */
    for (k = 0; k < 2; k++) {

	/* now look at every entry */
	for (i = 0; i < n; i++) {
	    FT_Get_Sfnt_Name (face, i, &aname);
	    /*	    printf("k=%d, face=%d, i=%d, platform=%d, encoding=%d, lang=%d, Id=%d\n",k ,face, i, platform, encoding, language, aname.name_id); */
	    if (((k == 0) && (aname.name_id == TT_NAME_ID_FONT_FAMILY)) ||
		((k == 1) && (aname.name_id == TT_NAME_ID_PS_NAME))) {

		/* Try a Macintosh english name */
		if ((aname.platform_id == TT_PLATFORM_MACINTOSH) && 
		    (aname.language_id == TT_MAC_LANGID_ENGLISH))
		    {
			FT_UInt string_len;
			static char  name_buffer[257];
			int   name_len;
			int   english=1;

			string_len = aname.string_len < 257 ? aname.string_len : 257;
			name_len = 0;

			for (j = 0; j < string_len; j++) {
			    /* some font names claim to be in english but aren't */
			    if ((aname.string[j] & 0xff) > 0x7f) english=0;
			    /* '-' is reserved in XLFD */
			    name_buffer[name_len++] =
				(aname.string[j] == '-') ? '_' : aname.string[j];
			}

			name_buffer[name_len] = '\0';
			if (english) return name_buffer;
		    }
		/* Try to find an Apple Unicode or Microsoft English name */
		if ((aname.platform_id == TT_PLATFORM_APPLE_UNICODE) ||
		    ((aname.platform_id == TT_PLATFORM_MICROSOFT) &&
		     ((aname.language_id & 0x00FF) ==
		      (TT_MS_LANGID_ENGLISH_UNITED_STATES & 0x00FF))) ||
		    (((aname.platform_id == TT_PLATFORM_MICROSOFT) &&
		      (aname.encoding_id == TT_MS_ID_UNICODE_CS)) &&
		     (aname.name_id == TT_NAME_ID_PS_NAME)))
		    {
			/* The following code was inspired from Mark Leisher's */
			/* ttf2bdf package                                     */
			FT_UInt string_len;
			static char  name_buffer[513];
			int   name_len;

			string_len = aname.string_len < 512 ? aname.string_len : 512;
			name_len = 0;
			/* convert from unicode to ASCII */
			for (j = 0; j < string_len; j ++) {
			  /* drop the NULL part, dont't use j+=2 to avoid
			     endian problem. */
			  if (aname.string[j] != '\0'){
			    /* '-' is reserved in XLFD */
			    name_buffer[name_len++] =
			      (aname.string[j] == '-') ? '_' : aname.string[j];
			  }
			}
			name_buffer[name_len] = '\0';
			return name_buffer;
		    }
	    }
	}
    }
 
    /* Not found */
    return "unknown";
}

/* This get_psname() function is copied from get_name().  I probably should
   try to merge the two functions somehow, but unfortunately, I do not have
   the time right now.  :-)  Anthony Fok <anthony@thizlinux.com>
*/

const char *
get_psname (FT_Face face)
{
    int i, j, k, n;

    FT_SfntName  aname;

    /* get the number of name strings in this font */
    if ((n = FT_Get_Sfnt_Name_Count (face)) < 0) {
	return NULL;
    }
    /* printf("\nn=%d\n",n); */

    /* for (k = 0; k < 2; k++) { */

    k = 1;
	/* now look at every entry */
	for (i = 0; i < n; i++) {
	    FT_Get_Sfnt_Name (face, i, &aname);
	    /*	    printf("k=%d, face=%d, i=%d, platform=%d, encoding=%d, lang=%d, Id=%d\n",k ,face, i, platform, encoding, language, aname.name_id); */

	    if (aname.name_id == TT_NAME_ID_PS_NAME) {

		/* Try a Macintosh english name */
		if ((aname.platform_id == TT_PLATFORM_MACINTOSH) && 
		    (aname.language_id == TT_MAC_LANGID_ENGLISH))
		    {
			FT_UInt string_len;
			static char  name_buffer[257];
			int   name_len;
			int   english=1;

			string_len = aname.string_len < 257 ? aname.string_len : 257;
			name_len = 0;

			for (j = 0; j < string_len; j++) {
			    /* some font names claim to be in english but aren't */
			    if ((aname.string[j] & 0xff) > 0x7f) english=0;
			    name_buffer[name_len++] = aname.string[j];
			}

			name_buffer[name_len] = '\0';
			if (english) return name_buffer;
		    }
		/* Try to find an Apple Unicode or Microsoft English name */
		if ((aname.platform_id == TT_PLATFORM_APPLE_UNICODE) ||
		    ((aname.platform_id == TT_PLATFORM_MICROSOFT) &&
		     ((aname.language_id & 0x00FF) ==
		      (TT_MS_LANGID_ENGLISH_UNITED_STATES & 0x00FF))) ||
		    (((aname.platform_id == TT_PLATFORM_MICROSOFT) &&
		      (aname.encoding_id == TT_MS_ID_UNICODE_CS)) &&
		     (aname.name_id == TT_NAME_ID_PS_NAME)))
		    {
			/* The following code was inspired from Mark Leisher's */
			/* ttf2bdf package                                     */
			FT_UInt string_len;
			static char  name_buffer[513];
			int   name_len;
			int   english=1;

			string_len = aname.string_len < 512 ? aname.string_len : 512;
			name_len = 0;
			/* convert from unicode to ASCII */
			for (j = 0; j < string_len; j ++) {
			  /* drop the NULL part, dont't use j+=2 to avoid
			     endian problem. */
			  if (aname.string[j] != '\0'){
			    if ((aname.string[j] & 0xff) > 0x7f) english=0;
			    name_buffer[name_len++] = aname.string[j];
			  }
			}
			name_buffer[name_len] = '\0';
			if (english) return name_buffer;
		    }
	    }
    }
 
    /* Not found */
    return "unknown";
}

static void  add_mapping (struct xlfdmapping **listhead,
			  char *file_name,
			  const char *foundry_name,
			  const char *font_name,
			  const char *weight_name,
			  const char *width_name,
			  TT_OS2 *os2,
			  TT_Postscript *post,
			  char *encodingscheme
			  )
{
    struct xlfdmapping *p;
    char char_for_spacing;
 
    /* allocate space for the file to xlfd mapping */
    p = malloc (sizeof (struct xlfdmapping));

    if (p == NULL) {
	exit (TTMKFS_MEM);
    }

    /* insert into our list */
    p->next = *listhead;
    *listhead = p;

    /*
     * we can't just write the mapping, but have to collect them.
     * To quote the mkfontdir man page: "The  first  line of fonts.dir
     * gives the number of fonts in the file. ... "fonts.scale" has
     * the same format as the "fonts.dir" file.". So we first have to
     * count and collect all our mappings.
     */

    /*if ((strncmp("jisx",encodingscheme,4)==0) ||
	(strncmp("gb2312",encodingscheme,5)==0) ||
	(strncmp("big5",encodingscheme,4)==0) ||
	(strncmp("ksc",encodingscheme,3)==0))
	{
	    char_for_spacing = 'c';
	} else {
	    char_for_spacing = (post->isFixedPitch) ?
		'm' : 'p' ;
	}*/
    char_for_spacing = (post->isFixedPitch) ? 'm' : 'p';

    sprintf (p->mapping, "-%s-%s-%s-%c-%s--0-0-0-0-%c-0-%s",
	     foundry_name,
	     font_name,
	     weight_name,
	     os2->fsSelection & TT_SELECTION_ITALIC ? 'i' : 'r',
	     width_name,
	     char_for_spacing,
	     encodingscheme);
}

static void  free_mappings (struct xlfdmapping **listhead)
{
    struct xlfdmapping *p;
    p = *listhead;
    while (p) {
      p = p->next;
      free(*listhead);
      *listhead = p;
    }
}

int
has_8bit_encoding (FT_Face face, const int *table)
{
    int i;
    int missing = 0;

    for (i = 0; i < 224; i++) {
	if (table[i] < 0) 
	    continue;

	if (FT_Get_Char_Index (face, table[i]) == 0) {
	    missing++;
	}
    }

    return (missing > max_missing) ? 0 : 1;
}

static const char *
panose_get_weight (FT_Byte *panose)
{
    static char *panose_weight_latin[] = {
	"any",
	"no fit",
	"very light",
	"light",
	"thin",
	"book",
	"medium",
	"demi",
	"bold",
	"heavy",
	"black",
	"extra black",
    };

    switch (panose[TT_PANOSE_FAMILY_TYPE]) {
    case TT_PANOSE_FAMILY_LATIN_TEXT:
    case TT_PANOSE_FAMILY_LATIN_HAND:
    case TT_PANOSE_FAMILY_LATIN_DECORATIVE:
	if (!((panose[TT_PANOSE_WEIGHT] < TT_PANOSE_LT_WEIGHT_VERY_LIGHT) ||
	      (panose[TT_PANOSE_WEIGHT] > TT_PANOSE_LT_WEIGHT_EXTRA_BLACK))) {
	    return panose_weight_latin[panose[TT_PANOSE_WEIGHT]];
	}
	break;
    }

    return NULL;
}

static const char *
os2_get_weight (FT_UShort usWeightClass)
{
    switch (usWeightClass) {
    case TT_FW_THIN: return "thin";
    case TT_FW_EXTRALIGHT: return "extra light";
    case TT_FW_LIGHT: return "light";
    case TT_FW_NORMAL: return "medium";
    case TT_FW_MEDIUM: return "medium";
    case TT_FW_SEMIBOLD: return "semi bold";
    case TT_FW_BOLD: return "bold";
    case TT_FW_EXTRABOLD: return "extra bold";
    case TT_FW_BLACK:  return "black";
    }

    return NULL;
}

static const char *
get_weight (const char *name, TT_OS2 *os2)
{
    const char *result;
    
    if (use_panose && ((result = panose_get_weight (os2->panose)) != NULL)) {
	return result;
    } else {
	if ((result = os2_get_weight (os2->usWeightClass)) != NULL) {
	    return result;
	}
	
	fprintf (stderr, "font %s: unknown usWeightClass %hu\n", name, os2->usWeightClass);
    }

    /* last fall back */
    return os2->fsSelection & (1 << 5) ? "bold" : "medium";
}

static const char *
panose_get_width_name (FT_Byte *panose)
{
    static char *panose_spacing_latin_text [] = {
	"any",
	"no fit",
	"old style",
	"modern",
	"even width",
	"extended",
	"condensed",
	"very extended",
	"very condensed",
	"monospaced",
    };
    
    static char *panose_spacing_latin_decorative [] = {
	"any",
	"no fit",
	"super condensed",
	"very condensed",
	"condensed",
	"normal",
	"extended",
	"very extended",
	"super extended",
	"monospaced",
    };

    switch (panose[TT_PANOSE_FAMILY_TYPE]) {
    case TT_PANOSE_FAMILY_LATIN_TEXT:
	if (!((panose[TT_PANOSE_PROPORTION] < TT_PANOSE_LT_PROPORTION_OLD_STYLE) ||
	      (panose[TT_PANOSE_PROPORTION] > TT_PANOSE_LT_PROPORTION_MONOSPACED))) {
	    return panose_spacing_latin_text[panose[TT_PANOSE_PROPORTION]];
	}
	break;
	
    case TT_PANOSE_FAMILY_LATIN_DECORATIVE:
	if (!((panose[TT_PANOSE_ASPECT] < TT_PANOSE_LD_SUPER_CONDENSED) ||
	      (panose[TT_PANOSE_ASPECT] > TT_PANOSE_LD_MONOSPACED))) {
	    return panose_spacing_latin_decorative[panose[TT_PANOSE_ASPECT]];
	}
	break;
    }

    return NULL;
}

static const char *
os2_get_width_name (FT_UShort usWidthClass)
{
    switch (usWidthClass) {
    case TT_FWIDTH_ULTRA_CONDENSED: return "ultra condensed";
    case TT_FWIDTH_EXTRA_CONDENSED: return "extra condensed";
    case TT_FWIDTH_CONDENSED: return "condensed";
    case TT_FWIDTH_SEMI_CONDENSED: return "semi condensed";
    case TT_FWIDTH_NORMAL: return "normal";
    case TT_FWIDTH_SEMI_EXPANDED: return "semi expanded";
    case TT_FWIDTH_EXPANDED: return "expanded";
    case TT_FWIDTH_EXTRA_EXPANDED: return "extra expanded";
    case TT_FWIDTH_ULTRA_EXPANDED: return "ultra expanded";
    }

    return NULL;
}

static const char *
get_width_name (const char *name, TT_OS2 *os2)
{
    const char *result;
    
    if (use_panose && ((result = panose_get_width_name (os2->panose)) != NULL)) {
	return result;
    } else {
	if ((result = os2_get_width_name (os2->usWidthClass)) != NULL) {
	    return result;
	}
	
	fprintf (stderr, "font %s: unknown usWidthClass %hu\n", name, os2->usWidthClass);
    }

    /* last fall back */
    return "normal";
}
