/* treewm - an X11 window manager.
 * Copyright (c) 2000 Thomas Jger <thehunter2000@web.de>
 * This code is released under the terms of the GNU GPL. See
 * the included file LICENSE for details.
 */

#include <X11/xpm.h>
#include "icon.h"
#include "desktop.h"
#include "sceme.h"
#include "action.h"
#include "clienttree.h"

Icon::Icon(Desktop *p, Client *c, Action *a) : client(c), parent(p), action(a) {
  flags = TF_ISICON;
  pixmap = 0;
  iconwin = 0;
  window = 0;
  name = 0;
  spm = 0;
  XSetWindowAttributes attr;
  attr.override_redirect = true;
  attr.background_pixel = parent->o.Sc->colors[client ? C_IBG : C_ABG].pixel;
  attr.border_pixel = parent->o.Sc->colors[C_IBD].pixel ;
  attr.event_mask = (ButtonPressMask | ButtonReleaseMask | ExposureMask | Button2MotionMask);
  if (client) {
    if (client->flags & CF_ICONPOSKNOWN) {
      x = client->IconX;
      y = client->IconY;
    } else {
      GetPosition();
    }
  } else if (action) {
      if ((action->flags & AC_ICONX) && (action->flags & AC_ICONY)) {
        x = action->IconX;
        y = action->IconY;
      } else {
        GetPosition();
      }
    }
  ChangeName();
  window = XCreateWindow(dpy, parent->window, x - w/2, y, w, h,1,
                    CopyFromParent,
                    CopyFromParent,CopyFromParent,CWBorderPixel | CWEventMask | CWBackPixel | CWOverrideRedirect,&attr);
  attr.background_pixel = parent->o.Sc->colors[C_IBG].pixel;
  if (client && client->iconpm) GetXPMFile(client->iconpm,&attr);
  if (!iconwin && client) {
    Client *focus = client->Focus();
    if (focus) {
      XWMHints *hints = XGetWMHints(dpy, focus->window);
      if (hints) {
        if(hints->flags & IconWindowHint) {
          GetIconWindow(hints);
        } else
          if (hints->flags & IconPixmapHint) {
            GetIconBitmap(hints,&attr);
          }
        XFree(hints);
      }
    }
  } else if (action) {
      if (action->iconpm) GetXPMFile(action->iconpm,&attr);
    }
  if (!iconwin && client && client->o.Sc->iconpm) GetXPMFile(client->o.Sc->iconpm,&attr);

  if (parent->flags & DF_ICONSRAISED) {
    XRaiseWindow(dpy,window);
    if (iconwin)
      XRaiseWindow(dpy,iconwin);
  } else {
    XLowerWindow(dpy,window);
    if (iconwin)
      XLowerWindow(dpy,iconwin);
  }
  XMapWindow(dpy,window);
  if (iconwin)
    XMapWindow(dpy,iconwin);
  if (window)  ct->windows.insert(WmapPair(window,this));
  if (iconwin) ct->windows.insert(WmapPair(iconwin,this));


}

inline int Min(int x,int y) {
  return (x < y) ? x : y;
}

// we are lazy
#define MINIX        MinIX
#define MINIY        MinIY
#define GRIDX        parent->o.Sc->GridX
#define GRIDY        parent->o.Sc->GridY
#define ISPACELEFT   parent->o.Sc->ISLeft
#define ISPACERIGHT  parent->o.Sc->ISRight
#define ISPACETOP    parent->o.Sc->ISTop
#define ISPACEBOTTOM parent->o.Sc->ISBottom

void Icon::GetPosition() {
  MinIX = parent->o.Sc->MinIX;
  MinIY = parent->o.Sc->MinIY;
  parent->Translate(&MinIX,&MinIY);
  int nx = (parent->width - MINIX) / GRIDX;
  int ny = (parent->height - MINIY) / GRIDY;
  bool Grid[nx][ny];
  for (int i = 0;i!=nx;++i)
    for (int j = 0;j!=ny;++j)
      Grid[i][j] = true;

  for (Icon *ii=parent->firsticon;ii;ii=ii->next) {
      int x1 = (ii->x - Min(ii->w/2,ISPACELEFT)
                - MINIX - ISPACERIGHT  + GRIDX-1) / GRIDX; // the / - operator sucks with negative numbers
      int y1 = (ii->y - Min((ii->iconwin ? ii->iconh : 0),ISPACETOP)
                - MINIY - ISPACEBOTTOM + GRIDX-1) / GRIDY;
      int x2 = (ii->x + Min(ii->w/2,ISPACERIGHT)
                - MINIX + ISPACELEFT) / GRIDX;
      int y2 = (ii->y + Min(ii->h,ISPACEBOTTOM)
                - MINIY + ISPACETOP) / GRIDY;
      if (x1 < 0) x1 = 0;
      if (y1 < 0) y1 = 0;
      ++x2;++y2;
      if (x2 > nx) x2 = nx;
      if (y2 > ny) y2 = ny;
      for (int i = x1;i<x2;++i)
        for (int j = y1;j<y2;++j)
          Grid[i][j] = false;
    }

  x=0; y=0;
  for (int i = 0;i<nx+ny-1;++i)
    for (int j = 0;j!=i+1;++j)
      if (j<nx && i-j<ny && Grid[j][i-j]) {
        x = j*GRIDX + MINIX;
        y = (i-j)*GRIDY + MINIY;
        goto next; // ugly
      }
  next:
  if (!x) x = MINIX;
  if (!y) y = MINIY;

  for (Client *cc=parent->firstchild;cc;cc=cc->next)
    if (cc->mapped) {
      int x1 = (cc->x -               cc->o.Sc->BW - MINIX - ISPACERIGHT + GRIDX - 1) / GRIDX;
      int y1 = (cc->y - cc->THeight - cc->o.Sc->BW - MINIY - ISPACEBOTTOM + GRIDY - 1) / GRIDY;
      int x2 = (cc->x + cc->width   + cc->o.Sc->BW - MINIX + ISPACELEFT) / GRIDX;
      int y2 = (cc->y + cc->height  + cc->o.Sc->BW - MINIY + ISPACETOP) / GRIDY;
      if (x1 < 0) x1 = 0;
      if (y1 < 0) y1 = 0;
      ++x2;++y2;
      if (x2 > nx) x2 = nx;
      if (y2 > ny) y2 = ny;
      for (int i = x1;i<x2;++i)
        for (int j = y1;j<y2;++j) {
          Grid[i][j] = false;
        }
    }

  for (int i = 0;i<nx+ny-1;++i)
    for (int j = 0;j!=i+1;++j)
      if (j<nx && i-j<ny && Grid[j][i-j]) {
        x = j*GRIDX + MINIX;
        y = (i-j)*GRIDY + MINIY;
        return;
      }
}

void Icon::Move() {
  int dx = (x + snap - MINIX) % GRIDX - snap;
  int dy = (y + snap - MINIY) % GRIDY - snap;
  if (abs(dx)<=snap && abs(dy)<=snap) {
    x-=dx;
    y-=dy;
  }
  XMoveWindow(dpy, window,x - w/2,y);
  if (iconwin)
    XMoveWindow(dpy, iconwin, x-iconw/2, y-iconh-2);
}


void Icon::ChangeName() {
  char *str = 0;
  if (client) {
    str = client->name ? client->name : client->wmname;
    if (name)
      delete [] name;
    char *iconname;
    XGetIconName(dpy,client->window,&iconname);
    if (!iconname || !iconname[0]) {
      name = 0;
    } else {
      int length = strlen(iconname);
      if (length > MAXICON)
        length = MAXICON;
      name = new char [length+1];
      strncpy(name,iconname,length);
      name[length]=0;
    }
    if (iconname)
      XFree(iconname);
    if (name && !strcmp(name, str)) {
      delete [] name; // Save memory
      name = 0;
    }
  } else if (action) {
      name = action->name;
    }
  str = name ? name : str;
  w = XTextWidth(parent->o.Sc->fonts[FO_ICON], str, strlen(str)) + 2*SPACE;
  h = parent->o.Sc->fonts[FO_ICON]->ascent + parent->o.Sc->fonts[FO_ICON]->descent + 2*SPACE;
  if (window)
    XMoveResizeWindow(dpy, window, x - w/2, y, w, h);

}


void Icon::GetIconBitmap(XWMHints *hints,XSetWindowAttributes *attr) {
  int dummyx,dummyy;
  unsigned int dummybw;
  Window dummyroot;
  XGetGeometry(dpy, hints->icon_pixmap, &dummyroot, &dummyx, &dummyy,
	       (unsigned int *)&iconw,
	       (unsigned int *)&iconh, &dummybw, &depth);
  pixmap = hints->icon_pixmap;
#ifdef SHAPE
/*  if (hints->flags & IconMaskHint)
    {
      tmp_win->icon_maskPixmap = hints->icon_mask;
    }*/
#endif
  iconwin =	XCreateWindow(dpy, parent->window, x-iconw/2, y-iconh-2, iconw,
  		      iconh, 0, CopyFromParent,
  		      CopyFromParent,CopyFromParent,CWBorderPixel | CWEventMask | CWBackPixel | CWOverrideRedirect,attr);
  		
}

void Icon::GetIconWindow(XWMHints *hints) {
  int dummyx,dummyy;
  unsigned int dummybw;
  Window dummyroot;
  iconwin = hints->icon_window;
  XGetGeometry(dpy, iconwin, &dummyroot, &dummyx, &dummyy,
	       (unsigned int *)&iconw,
	       (unsigned int *)&iconh, &dummybw, &depth);
	iconh +=4; // windows seem to supply their own border
  pixmap = 0;// hints->icon_pixmap;
  flags |= IF_APPICON;
  XReparentWindow(dpy,iconwin,parent->window,x-iconw/2,y-iconh-2);
  XAddToSaveSet(dpy,iconwin);
  XMapWindow(dpy,iconwin);
  XSelectInput(dpy,iconwin,(ButtonPressMask | ButtonReleaseMask | Button2MotionMask));
}


bool Icon::GetXPMFile(RPixmap *pm,XSetWindowAttributes *attr) {
  pixmap = pm->GetPixmap();
  if (!pixmap) return false;
  spm = pm;
  iconw = pm->w;
  iconh = pm->h;
  depth = DefaultDepth(dpy,screen);
#ifdef SHAPE
/*      if (tmp_win->icon_maskPixmap)
	tmp_win->flags |= SHAPED_ICON;
*/	
#endif

  iconwin =	XCreateWindow(dpy, parent->window, x-iconw/2, y-iconh-2, iconw,
  		      iconh, 0, CopyFromParent,
  		      CopyFromParent,CopyFromParent,CWBorderPixel | CWEventMask | CWBackPixel | CWOverrideRedirect,attr);
	return true;
}


void Icon::ReDraw() {
  if (!parent->visible) return;
  char *str;
  if (client) {
     str = name ? name : (client->name ? client->name : client->wmname);
  } else
    str = name;
  XDrawString(dpy, window, parent->o.Sc->icon_gc,
    SPACE, SPACE + parent->o.Sc->fonts[FO_ICON]->ascent,
    str, strlen(str));

  if(pixmap != None) {
    if (1 || depth == (unsigned int)DefaultDepth(dpy,screen)) {
      XCopyArea(dpy,pixmap,iconwin,parent->o.Sc->icon_gc,0,0,iconw-4,iconh-4,2,2);
    } else {
      XCopyPlane(dpy,pixmap,iconwin,parent->o.Sc->icon_gc,0,0,iconw-4,iconh-4,2,2,1);
    }
  }


}

bool Icon::IsIn(Window win, int xx, int yy) {
  if (win == iconwin) {
    return (0<=xx && xx<=iconw && 0<=yy && yy<=iconh);
  }
  if (win == window) {
    return (0<=xx && xx<=w && 0<=yy && yy<=h);
  }
  return false;
}


Icon::~Icon(){
  if (client) {
//  x = i*GRIDX + MINIX;
//  y = i*GRIDY + MINIY;
    if (((x-MINIX) % GRIDX) || ((y-MINIY) % GRIDY)) {
      client->flags |= CF_ICONPOSKNOWN;
      client->IconX = x;
      client->IconY = y;
    } else {
      client->flags &= ~CF_ICONPOSKNOWN;
    }
    if (name)
      delete [] name;
  }

  if (window) {
    ct->windows.erase(window);
    XUnmapWindow(dpy,window);
    XDestroyWindow(dpy, window);
  }
  if (iconwin) {
    ct->windows.erase(iconwin);
    XUnmapWindow(dpy,iconwin);
    if (!(flags & IF_APPICON))
      XDestroyWindow(dpy, iconwin); else
      XReparentWindow(dpy,iconwin,root,0,0);
  }
  if (spm)
    spm->FreePixmap();
}
