/******************************************************************************
 *                                                                            *
 * File:   tab     .h         Version  1.20            Date: 1997-07-27       *
 *                                                                            *
 * Copyright (c) 1993-1997 by kosta@kostis.net (Kosta Kostis)                 *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-07-27: KK V1.20                                                   *
 *        - see transtab.c                                                    *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************

	Program Constants

 *****************************************************************************/

/* this is the ISO/IEC 10646-1:1993 name for the NO-BREAK SPACE character    */
#define ISO_NO_BREAK_SPACE      "NO-BREAK SPACE"

/* max. length for ISO/IEC 10646-1:1993 character names (plus a few)         */
#define MAX_ISO_NAME_LENGTH     100

/* max. length for an Unicode Format A line                                  */
#define	MAX_UNI_NAME_LENGTH	120

/* max. length for a Character Encoding Name                                 */
#define MAX_ENC_NAME_LENGTH     80

/* max. length for a Comment Line                                            */
#define MAX_COMMENT_LENGTH      80

/* number of entries in an 8-bit character encoding                          */
#define MAX_TABLE_ENTRIES       256

/* number of entries in the Unicode 2.0 name table (file cedf/iso10646)      */
#define	ISO_TABLE_ENTRIES	6542

/* DEF_ISONAME is the (relative) filename containing all Unicode 2.0 names   */
#define DEF_ISONAME             "iso10646"

/* this is a default value for NO-BREAK SPACE (IBM Codepage value)           */
#define DEF_NO_BREAK_SPACE      255

/* BAD is an illegal ISO/IEC 10646-1:1993 value                              */
#define BAD                     0xFFFE

/* number of codes per line in the unsigned int array (table output)         */
#define MAX_CODES_PER_LINE      8

/* number of comment lines in a Character Encoding Description File          */
#define MAX_COMMENTS            3

/* environment variable for supplying directory path to TRANS package        */
#define	ENV_TRANS		"TRANS"

/* environment variable for supplying directory path to Unicode data files   */
#define	ENV_UNICODE		"UNICODE"

/* these are pointers to some program information strings (main program)     */
extern	char			*PRGNAM ;
extern	char			*VERSION ;

/******************************************************************************

	Output Filename Extensions

 *****************************************************************************/

/* default directory for trans package (eg. FreeBSD)                         */
#define DIR_TRANS               "/usr/local/lib/trans/"

#define	EXT_BINARY		"%sxlt%c%s"
#define	EXT_CEDF		"%scedf%c%s"
#define	EXT_UNICODE		"%s%s.txt"

#define	EXT_TABLE		"%s.tab"
#define	EXT_UNICODE_A		"%s.txt"
#define	EXT_C			"%s.c"
#define	EXT_H			"%s.h"

