/******************************************************************************
 *                                                                            *
 * File:   gettrans.c         Version  1.00            Date: 1997-07-27       *
 *                                                                            *
 * Copyright (c) 1997 by kosta@kostis.net (Kosta Kostis)                      *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-07-27: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "os-stuff.h"

#include "tab.h"

#include "gettrans.h"

/******************************************************************************

	Function:
		figure out TRANS directory

	Parameters:
		none

	Returns:
		pointer to TRANS directory

 *****************************************************************************/

char	*GetTrans (void)
{
	static	char	TRANS	[PATHNAME_MAX + 1] ;
	char	*Help ;

	#ifdef	DIR_TRANS
		strcpy (TRANS, DIR_TRANS) ;
	#else
		sprintf (TRANS, "..%c", CHR_DIR) ;
	#endif

	Help = getenv (ENV_TRANS) ;
	if (Help != (char *) NULL)
		strcpy (TRANS, Help) ;

	return (TRANS) ;
}

