/******************************************************************************
 *                                                                            *
 * File:   checkuni.c         Version  1.20            Date: 1997-07-27       *
 *                                                                            *
 * Copyright (c) 1993-1997 by kosta@kostis.net (Kosta Kostis)                 *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - this program compares cedf file with Unicode Format A tables      *
 *          this is a dirty hack - for internal use only                      *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-07-27: KK V1.20                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

/******************************************************************************

	General Program Definitions

 *****************************************************************************/

#include "checkuni.h"
#include "taberr.h"
#include "tab.h"

/******************************************************************************

	Character Encoding Description Table Functions

 *****************************************************************************/

#include "loadtab.h"

#ifdef	NO_STRDUP
	#include "strdup.c"
#endif

#ifdef	NO_STRUPR
	#include "strupr.c"
#endif

/******************************************************************************

	Function:
		display copyright, author and program information

	Parameters:
		none

	Returns:
		nothing

 *****************************************************************************/

void	Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_VERSION, PRGNAM, VERSION) ;
}

/*****************************************************************************/

int     main
(
	int	argc,
	char	*argv		[]
)
{
	int	rc ;
	int	i ;
	static	ushort	DstCodes	[MAX_TABLE_ENTRIES] ;
	static	ushort	UniCodes	[MAX_TABLE_ENTRIES] ;

	Hello () ;

	/**********************************************************************

		parse parameters/arguments

	 *********************************************************************/

	if (argc != 2)
	{
		/**************************************************************

			display syntax error message and quit

		 *************************************************************/

		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		try to read character encoding description files

	 *********************************************************************/

	rc = LoadTable (argv [1], DstCodes) ;
	if (rc != ERR_NONE)
	{
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, argv [1]) ;
		fprintf (stderr, "%s: LoadTable ()\n", PRGNAM) ;
		return (rc) ;
	}

	rc = LoadUnicode (argv [1], UniCodes) ;
	if (rc != ERR_NONE)
	{
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, argv [1]) ;
		fprintf (stderr, "%s: LoadUnicode ()\n", PRGNAM) ;
		return (rc) ;
	}

	/**********************************************************************

		check source file

	 *********************************************************************/

	fprintf (stdout, MSG_CHECK, PRGNAM, argv [1]) ;

	for (i = 0 ; i < MAX_TABLE_ENTRIES ; ++i)
	{
		if (DstCodes [i] != UniCodes [i])
		{
			fprintf (stdout, MSG_DIFF, PRGNAM,
				 i, DstCodes [i], UniCodes [i]) ;
		}
	}

	return (ERR_NONE) ;
}
