#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2006 Edgewall Software
# All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at http://trac.edgewall.com/license.html.
#
# This software consists of voluntary contributions made by many
# individuals. For the exact contribution history, see the revision
# history and logs, available at http://projects.edgewall.com/trac/.

from setuptools import setup, find_packages

PACKAGE = 'TracWebAdmin'
VERSION = '0.1.2'

setup(
    name=PACKAGE, version=VERSION,
    description='Web interface for administration of Trac',
    author="Edgewall Software", author_email="info@edgewall.com",
    license='BSD', url='http://projects.edgewall.com/trac/wiki/WebAdmin',
    packages=find_packages(exclude=['ez_setup', '*.tests*']),
    package_data={
        'webadmin': [
            'htdocs/css/*.css',
            'htdocs/img/*.png',
            'htdocs/js/*.js',
            'templates/*.cs'
        ]
    },
    entry_points = {
        'trac.plugins': [
            'webadmin.web_ui = webadmin.web_ui',
            'webadmin.basics = webadmin.basics',
            'webadmin.logging = webadmin.logging',
            'webadmin.perm = webadmin.perm',
            'webadmin.plugin = webadmin.plugin',
            'webadmin.ticket = webadmin.ticket'
        ]
    }
)
