/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import tr.extract.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSL {
    public static void transform(File xml, InputStream xsl, List<Param> params, File out) throws Exception {
        StreamSource xmlStream = new StreamSource(xml);
        StreamSource xslStream = new StreamSource(xsl);
        StreamResult outStream = new StreamResult(new BufferedOutputStream(new FileOutputStream(out)));
        XSL.transform(xmlStream, xslStream, params, outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transform(StreamSource xml, StreamSource xslt, List<Param> params, StreamResult out) throws Exception {
        System.out.print("Processing XSLT ... ");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslt);
            for (Param param : params) {
                transformer.setParameter(param.id, param.getValue());
            }
            transformer.transform(xml, out);
            System.out.print("done");
        }
        finally {
            OutputStream outStream = out.getOutputStream();
            if (outStream != null) {
                outStream.close();
            }
            System.out.println();
        }
    }
}

