/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;

public class ExtractData {
    private static final DateFormat df = new SimpleDateFormat("yyyyMMddHHmmssEEE dd MMM yyyy HH:mm:ss");
    private static final DateFormat dfsort = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String KEY_PREFIX_THOUGHT = "T";
    private static final String KEY_PREFIX_PROJECT = "P";
    private static final String KEY_PREFIX_ACTION = "A";
    private static final String KEY_PREFIX_TOPIC = "TPC";
    private static final String KEY_PREFIX_CONTEXT = "CTX";
    private static Vector<Project> projects;
    private static Vector<Action> actions;
    private static File xmlfile;
    private static Data data;
    private static final KeyGenerator thoughtKeyGenerator;
    private static final KeyGenerator topicKeyGenerator;
    private static final KeyGenerator contextKeyGenerator;
    private static OutputStreamWriter out;

    public static void process(Data datamodel, File extractfile) {
        thoughtKeyGenerator.reset();
        topicKeyGenerator.reset();
        contextKeyGenerator.reset();
        data = datamodel;
        xmlfile = extractfile;
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds != null) {
            try {
                ds.store();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        try {
            System.out.print("Extracting data ... ");
            ExtractData.extract();
            ExtractData.output();
            System.out.println("done");
        }
        catch (Exception ex) {
            System.out.println();
            ex.printStackTrace();
        }
    }

    private static void extract() {
        ExtractData.extractProjects();
    }

    private static void extractProjects() {
        projects = new Vector();
        actions = new Vector();
        Iterator i = data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            ExtractData.extractProject((Project)i.next());
        }
    }

    private static void extractProject(Project project) {
        projects.add(project);
        Iterator i = project.iterator(Item.class);
        while (i.hasNext()) {
            Item child = (Item)i.next();
            if (child instanceof Action) {
                ExtractData.extractAction((Action)child);
                continue;
            }
            if (!(child instanceof Project)) continue;
            ExtractData.extractProject((Project)child);
        }
    }

    private static void extractAction(Action action) {
        actions.add(action);
    }

    private static void output() throws Exception {
        ExtractData.initialise();
        ExtractData.writeTopics();
        ExtractData.writeContexts();
        ExtractData.writeThoughts();
        ExtractData.writeInformationItems();
        ExtractData.writeFutureItems();
        ExtractData.writeSingleActions();
        ExtractData.writeActions();
        ExtractData.writeProjects();
        ExtractData.finalise();
    }

    private static void initialise() throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<data>\r\n");
        Calendar calendar = Calendar.getInstance();
        out.write("<date>" + df.format(calendar.getTime()) + "</date>\r\n");
        calendar = Calendar.getInstance();
        calendar.add(6, 1);
        out.write("<tomorrow>" + df.format(calendar.getTime()) + "</tomorrow>\r\n");
        calendar = Calendar.getInstance();
        calendar.add(6, 7);
        out.write("<week>" + df.format(calendar.getTime()) + "</week>\r\n");
        calendar = Calendar.getInstance();
        calendar.add(6, 14);
        out.write("<two-weeks>" + df.format(calendar.getTime()) + "</two-weeks>\r\n");
        calendar = Calendar.getInstance();
        calendar.add(6, 21);
        out.write("<three-weeks>" + df.format(calendar.getTime()) + "</three-weeks>\r\n");
        calendar = Calendar.getInstance();
        calendar.add(6, 28);
        out.write("<four-weeks>" + df.format(calendar.getTime()) + "</four-weeks>\r\n");
    }

    private static void finalise() throws Exception {
        out.write("</data>\r\n");
        out.flush();
        out.close();
    }

    private static void writeTopics() throws Exception {
        out.write("<topics>\r\n");
        for (Topic topic : data.getTopicManager().list()) {
            topic.key = topicKeyGenerator.next();
            out.write("<topic key=\"" + topic.key + "\">\r\n");
            out.write("<name>" + ExtractData.escape(topic.getName()) + "</name>\r\n");
            out.write("<desc>" + ExtractData.escape(topic.getDescription()) + "</desc>\r\n");
            out.write("<fg>" + topic.getForeground().getRGB() + "</fg>\r\n");
            out.write("<bg>" + topic.getBackground().getRGB() + "</bg>\r\n");
            out.write("</topic>\r\n");
        }
        out.write("</topics>\r\n");
        if (data.getTopicManager().size() > 0) {
            Topic def = (Topic)data.getTopicManager().get(0);
            Topic.getDefault().key = def.key;
        }
    }

    private static void writeContexts() throws Exception {
        out.write("<contexts>\r\n");
        for (Context context : data.getContextManager().list()) {
            context.key = contextKeyGenerator.next();
            out.write("<context key=\"" + context.key + "\">\r\n");
            out.write("<name>" + ExtractData.escape(context.getName()) + "</name>\r\n");
            out.write("<desc>" + ExtractData.escape(context.getDescription()) + "</desc>\r\n");
            out.write("</context>\r\n");
        }
        out.write("</contexts>\r\n");
        if (data.getContextManager().size() > 0) {
            Context def = (Context)data.getContextManager().get(0);
            Context.getDefault().key = def.key;
        }
    }

    private static void writeThoughts() throws Exception {
        out.write("<thoughts>\r\n");
        for (Thought thought : data.getThoughtManager().list()) {
            thought.key = thoughtKeyGenerator.next();
            out.write("<thought key=\"" + thought.key + "\">\r\n");
            out.write("<created>" + df.format(thought.getCreated()) + "</created>\r\n");
            out.write("<desc>" + ExtractData.escape(thought.getDescription()) + "</desc>\r\n");
            out.write("<topic-key>" + thought.getTopic().key + "</topic-key>\r\n");
            out.write("</thought>\r\n");
        }
        out.write("</thoughts>\r\n");
    }

    private static void writeInformationItems() throws Exception {
        out.write("<infos>\r\n");
        for (Information info : data.getInformationManager().list()) {
            out.write("<info>\r\n");
            out.write("<created>" + df.format(info.getCreated()) + "</created>\r\n");
            out.write("<desc>" + ExtractData.escape(info.getDescription()) + "</desc>\r\n");
            out.write("<topic-key>" + info.getTopic().key + "</topic-key>\r\n");
            out.write("<location>" + info.getLocation() + "</location>\r\n");
            out.write("</info>\r\n");
        }
        out.write("</infos>\r\n");
    }

    private static void writeFutureItems() throws Exception {
        out.write("<futures>\r\n");
        for (Future future : data.getFutureManager().list()) {
            out.write("<future>\r\n");
            out.write("<created>" + df.format(future.getCreated()) + "</created>\r\n");
            out.write("<desc>" + ExtractData.escape(future.getDescription()) + "</desc>\r\n");
            out.write("<topic-key>" + future.getTopic().key + "</topic-key>\r\n");
            if (future.getThought() != null) {
                out.write("<thought-key>" + future.getThought().key + "</thought-key>\r\n");
            }
            out.write("</future>\r\n");
        }
        out.write("</futures>\r\n");
    }

    private static void writeSingleActions() throws Exception {
        out.write("<single_actions>\r\n");
        Iterator i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            ExtractData.writeAction((Action)i.next());
        }
        out.write("</single_actions>\r\n");
    }

    private static void writeProjects() throws Exception {
        out.write("<projects>\r\n");
        for (Project p : projects) {
            ExtractData.writeProject(p);
        }
        out.write("</projects>\r\n");
    }

    private static void writeProject(Project project) throws Exception {
        Project parent;
        out.write("<project key=\"" + ExtractData.getKey(project) + "\">\r\n");
        out.write("<created>" + df.format(project.getCreated()) + "</created>\r\n");
        Thought thought = project.getThought();
        if (thought != null) {
            out.write("<thought-key>" + project.getThought().key + "</thought-key>\r\n");
        }
        if ((parent = (Project)project.getParent()) != null && parent.getID() != data.getRootProjects().getID()) {
            out.write("<parent-key>" + ExtractData.getKey(parent) + "</parent-key>\r\n");
        }
        out.write("<topic-key>" + project.getTopic().key + "</topic-key>\r\n");
        out.write("<desc>" + ExtractData.escape(project.getDescription()) + "</desc>\r\n");
        out.write("<purpose>" + ExtractData.escape(project.getPurpose()) + "</purpose>\r\n");
        out.write("<success>" + ExtractData.escape(project.getVision()) + "</success>\r\n");
        out.write("<brainstorming>" + ExtractData.escape(project.getBrainstorming()) + "</brainstorming>\r\n");
        out.write("<organising>" + ExtractData.escape(project.getOrganising()) + "</organising>\r\n");
        out.write("<done>" + project.isDone() + "</done>\r\n");
        if (project.getDoneDate() != null) {
            out.write("<done_date>" + df.format(project.getDoneDate()) + "</done_date>\r\n");
        }
        out.write("<children>\r\n");
        Iterator i = project.iterator(Item.class);
        while (i.hasNext()) {
            Item item = (Item)i.next();
            if (item instanceof Action) {
                out.write("<action key=\"" + ExtractData.getKey((Action)item) + "\"/>\r\n");
                continue;
            }
            if (!(item instanceof Project)) continue;
            out.write("<project key=\"" + ExtractData.getKey((Project)item) + "\"/>\r\n");
        }
        out.write("</children>\r\n");
        out.write("</project>\r\n");
    }

    private static void writeActions() throws Exception {
        out.write("<actions>\r\n");
        for (Action a : actions) {
            ExtractData.writeAction(a);
        }
        out.write("</actions>\r\n");
    }

    private static void writeAction(Action action) throws Exception {
        ActionState s;
        Project parent;
        out.write("<action key=\"" + ExtractData.getKey(action) + "\">\r\n");
        out.write("<created>" + df.format(action.getCreated()) + "</created>\r\n");
        Thought thought = action.getThought();
        if (thought != null) {
            out.write("<thought-key>" + action.getThought().key + "</thought-key>\r\n");
        }
        if ((parent = (Project)action.getParent()) != null && parent.getID() != data.getRootProjects().getID() && parent.getID() != data.getRootActions().getID()) {
            out.write("<parent-key>" + ExtractData.getKey(parent) + "</parent-key>\r\n");
        }
        out.write("<desc>" + ExtractData.escape(action.getDescription()) + "</desc>\r\n");
        out.write("<topic-key>" + action.getTopic().key + "</topic-key>\r\n");
        out.write("<context-key>" + action.getContext().key + "</context-key>\r\n");
        ExtractData.writeActionState(action.getState());
        out.write("<notes>" + ExtractData.escape(action.getNotes()) + "</notes>\r\n");
        out.write("<done>" + action.isDone() + "</done>\r\n");
        if (action.getDoneDate() != null) {
            out.write("<done_date>" + df.format(action.getDoneDate()) + "</done_date>\r\n");
        }
        if ((s = action.getState()) instanceof ActionStateDelegated) {
            out.write("<icon>D</icon>\r\n");
            Date date = ((ActionStateDelegated)s).getDate();
            out.write("<action-date>" + (date == null ? "" : dfsort.format(date)) + "</action-date>\r\n");
            out.write("<delegate>" + ExtractData.escape(((ActionStateDelegated)s).getTo()) + "</delegate>\r\n");
        } else if (s instanceof ActionStateScheduled) {
            out.write("<icon>S</icon>\r\n");
            Date date = ((ActionStateScheduled)s).getDate();
            out.write("<action-date>" + (date == null ? "" : dfsort.format(date)) + "</action-date>\r\n");
        } else if (s instanceof ActionStateInactive) {
            out.write("<icon>I</icon>\r\n");
        } else if (s instanceof ActionStateASAP) {
            out.write("<icon>A</icon>\r\n");
        }
        out.write("<context-name>" + ExtractData.escape(action.getContext().getName()) + "</context-name>\r\n");
        out.write("<topic-name>" + ExtractData.escape(action.getTopic().getName()) + "</topic-name>\r\n");
        if (parent != null && parent.getID() != data.getRootProjects().getID() && parent.getID() != data.getRootActions().getID()) {
            out.write("<from-icon>P</from-icon>\r\n");
            out.write("<from-desc>" + ExtractData.escape(parent.getDescription()) + "</from-desc>\r\n");
            out.write("<from-topic-name>" + ExtractData.escape(parent.getTopic().getName()) + "</from-topic-name>\r\n");
        } else if (thought != null) {
            out.write("<from-icon>T</from-icon>\r\n");
            out.write("<from-desc>" + ExtractData.escape(action.getThought().getDescription()) + "</from-desc>\r\n");
            out.write("<from-topic-name>" + ExtractData.escape(action.getThought().getTopic().getName()) + "</from-topic-name>\r\n");
        }
        out.write("</action>\r\n");
    }

    private static void writeActionState(ActionState state) throws Exception {
        if (state instanceof ActionStateASAP) {
            ActionStateASAP s = (ActionStateASAP)state;
            out.write("<state type='ASAP'>");
            out.write("<created>" + df.format(s.getCreated()) + "</created>");
            out.write("</state>\r\n");
        } else if (state instanceof ActionStateDelegated) {
            ActionStateDelegated s = (ActionStateDelegated)state;
            out.write("<state type='DELEGATED'>");
            out.write("<created>" + df.format(s.getCreated()) + "</created>");
            out.write("<to>" + ExtractData.escape(s.getTo()) + "</to>");
            if (s.getDate() != null) {
                out.write("<date>" + df.format(s.getDate()) + "</date>");
            }
            out.write("</state>\r\n");
        } else if (state instanceof ActionStateInactive) {
            ActionStateInactive s = (ActionStateInactive)state;
            out.write("<state type='INACTIVE'>");
            out.write("<created>" + df.format(s.getCreated()) + "</created>");
            out.write("</state>\r\n");
        } else if (state instanceof ActionStateScheduled) {
            ActionStateScheduled s = (ActionStateScheduled)state;
            out.write("<state type='SCHEDULED'>");
            out.write("<created>" + df.format(s.getCreated()) + "</created>");
            out.write("<date>");
            if (s.getDate() != null) {
                out.write(df.format(s.getDate()));
            }
            out.write("</date>");
            out.write("</state>\r\n");
        }
    }

    private static String getKey(Project project) {
        return project == null ? "" : KEY_PREFIX_PROJECT + project.getID();
    }

    private static String getKey(Action action) {
        return action == null ? "" : KEY_PREFIX_ACTION + action.getID();
    }

    private static String escape(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    static {
        thoughtKeyGenerator = new KeyGenerator(KEY_PREFIX_THOUGHT);
        topicKeyGenerator = new KeyGenerator(KEY_PREFIX_TOPIC);
        contextKeyGenerator = new KeyGenerator(KEY_PREFIX_CONTEXT);
    }

    private static final class KeyGenerator {
        private int number = 0;
        private final String prefix;

        public KeyGenerator(String prefix) {
            this.prefix = prefix;
        }

        public String next() {
            return this.prefix + this.number++;
        }

        public void reset() {
            this.number = 0;
        }
    }
}

