/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.progress.module.InternalHandle;
import org.netbeans.progress.module.ProgressEvent;
import org.netbeans.progress.module.ProgressListAction;
import org.netbeans.progress.module.ProgressUIWorker;
import org.netbeans.progress.module.TaskModel;
import org.netbeans.progress.module.ui.ListComponent;
import org.netbeans.progress.module.ui.NbProgressBar;
import org.netbeans.progress.module.ui.PopupPane;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class StatusLineComponent
extends JPanel
implements ProgressUIWorker {
    private NbProgressBar bar;
    private JLabel label;
    private JSeparator separator;
    private InternalHandle handle;
    private boolean showingPopup = false;
    private TaskModel model;
    private MouseListener mouseListener;
    private HideAWTListener hideListener;
    private Popup popup;
    private JWindow popupWindow;
    private PopupPane pane;
    private Map handleComponentMap = new HashMap();
    private final int prefferedHeight;

    public StatusLineComponent() {
        this.label = new JLabel();
        this.label.setCursor(Cursor.getPredefinedCursor(12));
        this.bar = new NbProgressBar();
        this.bar.setUseInStatusBar(true);
        this.bar.setStringPainted(true);
        this.bar.setString("XXX");
        this.label.setText("XXX");
        this.prefferedHeight = Math.max(this.label.getPreferredSize().height, this.bar.getPreferredSize().height) + 2;
        this.bar.setCursor(Cursor.getPredefinedCursor(12));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setVgap(1);
        flowLayout.setHgap(0);
        this.setLayout(flowLayout);
        this.mouseListener = new MListener();
        this.label.addMouseListener(this.mouseListener);
        this.bar.addMouseListener(this.mouseListener);
        this.addMouseListener(this.mouseListener);
        this.hideListener = new HideAWTListener();
        this.pane = new PopupPane();
        this.pane.getActionMap().put("HidePopup", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusLineComponent.this.hidePopup();
            }
        });
        this.pane.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.pane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "HidePopup");
        this.separator = new JSeparator(1);
        this.separator.setPreferredSize(new Dimension(5, this.prefferedHeight));
        this.separator.setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.prefferedHeight;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.height = this.prefferedHeight;
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.prefferedHeight;
        return dimension;
    }

    public void setModel(TaskModel taskModel) {
        this.model = taskModel;
        this.model.addListDataListener(new Listener());
        this.model.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StatusLineComponent.this.pane.updateBoldFont(StatusLineComponent.this.model.getSelectedHandle());
            }
        });
    }

    private void setTooltipForAll() {
        int n = this.model.getSize();
        String string = "NbProgressBar.tooltip1";
        if (n == 1) {
            string = "NbProgressBar.tooltip2";
        }
        String string2 = NbBundle.getMessage((Class)StatusLineComponent.class, (String)string, (Object)new Integer(n));
        this.setToolTipText(string2);
        this.label.setToolTipText(string2);
        this.bar.setToolTipText(string2);
    }

    public void processProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 0) {
            this.createListItem(progressEvent.getSource());
        } else if (progressEvent.getType() == 1 || progressEvent.getType() == 5) {
            ListComponent listComponent = (ListComponent)this.handleComponentMap.get(progressEvent.getSource());
            if (listComponent == null) {
                this.createListItem(progressEvent.getSource());
                listComponent = (ListComponent)this.handleComponentMap.get(progressEvent.getSource());
            }
            listComponent.processProgressEvent(progressEvent);
        } else if (progressEvent.getType() == 4) {
            this.removeListItem(progressEvent.getSource());
            if (this.model.getSelectedHandle() != null && this.handle != this.model.getSelectedHandle()) {
                this.initiateComponent(this.model.getSelectedHandle().requestStateSnapshot());
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 0) {
            this.initiateComponent(progressEvent);
            return;
        }
        if (progressEvent.getType() == 4) {
            this.hidePopup();
            this.removeAll();
            this.revalidate();
            this.repaint();
            return;
        }
        if (progressEvent.getSource() != this.handle || progressEvent.isSwitched()) {
            this.initiateComponent(progressEvent);
        }
        if (progressEvent.getWorkunitsDone() > 0) {
            this.bar.setValue(progressEvent.getWorkunitsDone());
        }
        this.bar.setString(StatusLineComponent.getBarString(progressEvent.getPercentageDone(), progressEvent.getEstimatedCompletion()));
        if (progressEvent.getDisplayName() != null) {
            this.label.setText(progressEvent.getDisplayName());
        }
    }

    static String formatEstimate(long l) {
        long l2 = l / 60L;
        long l3 = l - l2 * 60L;
        return "" + l2 + (l3 < 10L ? ":0" : ":") + l3;
    }

    static String getBarString(int n, long l) {
        if (l != -1L) {
            return StatusLineComponent.formatEstimate(l);
        }
        if (n != -1) {
            return "" + n + "%";
        }
        return "";
    }

    private void initiateComponent(ProgressEvent progressEvent) {
        this.handle = progressEvent.getSource();
        boolean bl = false;
        this.label.setText(this.handle.getDisplayName());
        if (this.label.getParent() == null) {
            this.add(this.label);
            bl = true;
        }
        NbProgressBar.setupBar(progressEvent.getSource(), this.bar);
        if (this.bar.getParent() == null) {
            this.add(this.bar);
            bl = true;
        }
        if (this.separator.getParent() == null) {
            this.add(this.separator);
            bl = true;
        }
        if (bl) {
            this.revalidate();
            this.repaint();
        }
    }

    public void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().removeComponentListener(this.hideListener);
        this.showingPopup = false;
    }

    private void createListItem(InternalHandle internalHandle) {
        ListComponent listComponent;
        if (this.handleComponentMap.containsKey(internalHandle)) {
            listComponent = (ListComponent)this.handleComponentMap.get(internalHandle);
        } else {
            listComponent = new ListComponent(internalHandle);
            this.handleComponentMap.put(internalHandle, listComponent);
        }
        this.pane.addListComponent(listComponent);
        this.pane.updateBoldFont(this.model.getSelectedHandle());
        if (this.showingPopup) {
            this.resizePopup();
        }
    }

    private void removeListItem(InternalHandle internalHandle) {
        this.handleComponentMap.remove(internalHandle);
        this.pane.removeListComponent(internalHandle);
        this.pane.updateBoldFont(this.model.getSelectedHandle());
        if (this.showingPopup) {
            this.resizePopup();
        }
    }

    public void showPopup() {
        if (this.showingPopup) {
            return;
        }
        InternalHandle[] internalHandleArray = this.model.getHandles();
        if (internalHandleArray.length == 0) {
            return;
        }
        this.showingPopup = true;
        if (this.popupWindow == null) {
            this.popupWindow = new JWindow(WindowManager.getDefault().getMainWindow());
            this.popupWindow.getContentPane().add(this.pane);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.hideListener, 16L);
        WindowManager.getDefault().getMainWindow().addWindowStateListener(this.hideListener);
        WindowManager.getDefault().getMainWindow().addComponentListener(this.hideListener);
        this.resizePopup();
        this.popupWindow.setVisible(true);
        this.pane.requestFocus();
    }

    private void resizePopup() {
        this.popupWindow.pack();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this);
        Dimension dimension = this.popupWindow.getSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        Point point2 = new Point(point.x + this.getSize().width + 4 - dimension.width, point.y - dimension.height - 5);
        if (!rectangle.contains(point2)) {
            point2 = new Point(point2.x, point.y + 5 + this.getSize().height);
        }
        this.popupWindow.setLocation(point2);
    }

    private void showMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new ProgressListAction(NbBundle.getMessage((Class)StatusLineComponent.class, (String)"StatusLineComponent.ShowProcessList")));
        jPopupMenu.add(new ViewAction());
        jPopupMenu.add(new CancelAction());
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"StatusLineComponent.Cancel"));
            this.setEnabled(StatusLineComponent.this.handle == null ? false : StatusLineComponent.this.handle.isAllowCancel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InternalHandle internalHandle = StatusLineComponent.this.handle;
            if (internalHandle != null && internalHandle.getState() == 1) {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"Cancel_Question", (Object)StatusLineComponent.this.handle.getDisplayName());
                String string2 = NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"Cancel_Question_Title");
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, 0, 3, null, null);
                Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
                if (object == NotifyDescriptor.YES_OPTION && internalHandle.getState() == 1) {
                    internalHandle.requestCancel();
                }
            }
        }
    }

    private class HideAWTListener
    extends ComponentAdapter
    implements AWTEventListener,
    WindowStateListener {
        private HideAWTListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getClickCount() > 0) {
                Component component = (Component)aWTEvent.getSource();
                Container container = SwingUtilities.getAncestorNamed("progresspopup", component);
                Container container2 = SwingUtilities.getAncestorOfClass(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent, component);
                if (container == null && container2 == null) {
                    StatusLineComponent.this.hidePopup();
                }
            }
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            if (StatusLineComponent.this.showingPopup) {
                int n = windowEvent.getOldState();
                int n2 = windowEvent.getNewState();
                if ((n & 1) == 0 && (n2 & 1) == 1) {
                    StatusLineComponent.this.hidePopup();
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.resizePopup();
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.resizePopup();
            }
        }
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            StatusLineComponent.this.setTooltipForAll();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            StatusLineComponent.this.setTooltipForAll();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            StatusLineComponent.this.setTooltipForAll();
        }
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                StatusLineComponent.this.showMenu(mouseEvent);
            } else if (StatusLineComponent.this.showingPopup) {
                StatusLineComponent.this.hidePopup();
            } else {
                StatusLineComponent.this.showPopup();
            }
        }
    }

    private class ViewAction
    extends AbstractAction {
        public ViewAction() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$progress$module$ui$StatusLineComponent == null ? (class$org$netbeans$progress$module$ui$StatusLineComponent = StatusLineComponent.class$("org.netbeans.progress.module.ui.StatusLineComponent")) : class$org$netbeans$progress$module$ui$StatusLineComponent), (String)"StatusLineComponent.View"));
            this.setEnabled(StatusLineComponent.this.handle == null ? false : StatusLineComponent.this.handle.isAllowView());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StatusLineComponent.this.handle != null) {
                StatusLineComponent.this.handle.requestView();
            }
        }
    }
}

