/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.prefs.calendar.CalendarOptionsPanelController;
import tr.prefs.calendar.CalendarPrefs;

final class CalendarPrefsPanel
extends JPanel {
    private final CalendarOptionsPanelController controller;
    private JButton folderButton;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JCheckBox requiredCheckBox;

    CalendarPrefsPanel(CalendarOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.requiredCheckBox = new JCheckBox();
        this.folderButton = new JButton();
        this.folderTextField = new JTextField();
        this.folderTextField.getDocument().addDocumentListener(new FolderDocumentListener());
        this.folderLabel = new JLabel();
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.requiredCheckBox.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.requiredCheckBox, (String)this.getRequiredText());
        this.requiredCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.requiredCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.folderButton.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)this.getBrowseText());
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.folderButtonbrowse(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)this.getOutputText());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.requiredCheckBox, -1, 367, Short.MAX_VALUE).add(138, 138, 138)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.folderLabel, -2, 110, -2).addPreferredGap(0).add((Component)this.folderTextField, -1, 247, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.folderButton).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.requiredCheckBox).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.folderButton).add((Component)this.folderLabel).add((Component)this.folderTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private String getRequiredText() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_Required");
    }

    private String getOutputText() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_Folder");
    }

    private String getBrowseText() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_Browse");
    }

    private void folderButtonbrowse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderTextField.getText()));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.folderTextField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderTextField.setText("");
            }
        }
    }

    void load() {
        this.requiredCheckBox.setSelected(CalendarPrefs.isICalendarRequired());
        this.folderTextField.setText(CalendarPrefs.getICalendarPath());
    }

    void store() {
        CalendarPrefs.setICalendarRequired(this.requiredCheckBox.isSelected());
        if (this.valid()) {
            CalendarPrefs.setICalendarPath(this.tidyPath(this.folderTextField.getText()));
        }
    }

    boolean valid() {
        String path = this.tidyPath(this.folderTextField.getText());
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String tidyPath(String path) {
        path = path.trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            CalendarPrefsPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            CalendarPrefsPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            CalendarPrefsPanel.this.controller.changed();
        }
    }
}

