/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.general;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class GeneralPrefs {
    private static final Logger LOG = Logger.getLogger("tr.prefs.general");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/general");
    private static final String KEY_LICENSE_ACCEPTED = "license.accepted";
    private static final boolean DEF_LICENSE_ACCEPTED = false;
    private static final String KEY_VERSION_CHECK_LAST_TIME = "version.check.last.time";
    private static final long DEF_VERSION_CHECK_LAST_TIME = 0L;
    public static final int VERSION_CHECK_PERIOD_STARTUP = 0;
    public static final int VERSION_CHECK_PERIOD_DAY = 1;
    public static final int VERSION_CHECK_PERIOD_WEEK = 2;
    public static final int VERSION_CHECK_PERIOD_2_WEEKS = 3;
    public static final int VERSION_CHECK_PERIOD_MONTH = 4;
    public static final int VERSION_CHECK_PERIOD_NEVER = 5;
    private static final String KEY_VERSION_CHECK_PERIOD = "version.check.period";
    private static final int DEF_VERSION_CHECK_PERIOD = 3;

    public static final boolean isLicenceAccepted() {
        return prefs.getBoolean(KEY_LICENSE_ACCEPTED, false);
    }

    public static final void setLicenceAccepted(boolean value) {
        prefs.putBoolean(KEY_LICENSE_ACCEPTED, value);
        GeneralPrefs.flush();
    }

    public static final long getCheckVersionLastTime() {
        return prefs.getLong(KEY_VERSION_CHECK_LAST_TIME, 0L);
    }

    public static final void setCheckVersionLastTime(long value) {
        prefs.putLong(KEY_VERSION_CHECK_LAST_TIME, value);
        GeneralPrefs.flush();
    }

    public static final int getVersionCheckPeriod() {
        return prefs.getInt(KEY_VERSION_CHECK_PERIOD, 3);
    }

    public static final void setVersionCheckPeriod(int value) {
        prefs.putInt(KEY_VERSION_CHECK_PERIOD, value);
        GeneralPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("General preferences error. " + ex.getMessage());
        }
    }
}

