/*
 * Decompiled with CFR 0.152.
 */
package tr.view.criteria;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.criteria.CriteriaTopComponent;
import tr.view.criteria.Resources;

public class CriteriaAction
extends AbstractAction
implements InitialAction {
    public CriteriaAction() {
        super(NbBundle.getMessage(CriteriaAction.class, (String)"CTL_CriteriaAction"));
        this.putValue("SmallIcon", Resources.ICON_CRITERIA);
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                CriteriaAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void actionPerformed(ActionEvent evt) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        WindowUtils.closeWindows();
        CriteriaTopComponent tc = CriteriaTopComponent.findInstance();
        Mode mode = WindowManager.getDefault().findMode("criteria");
        if (mode != null) {
            mode.dockInto((TopComponent)tc);
        }
        tc.open();
        tc.requestActive();
    }

    public String getID() {
        return "criteria";
    }

    public String getName() {
        return (String)this.getValue("Name");
    }
}

