/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.IDESettings;
import org.netbeans.core.windows.actions.RecentViewListAction;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.awt.StatusDisplayer;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher {
    private static final int TIME_TO_SHOW = 200;
    private static KeyboardPopupSwitcher instance;
    private static Popup popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static boolean invokerTimerRunning;
    private static int hits;
    private static SwitcherTableItem[] items;
    private SwitcherTable pTable = new SwitcherTable(items);
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private int x;
    private int y;
    private boolean fwd = true;
    private static IDESettings settings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean processShortcut(KeyEvent keyEvent) {
        boolean bl;
        if (settings.getUIMode() == 2 && !WindowManager.getDefault().getMainWindow().isFocused()) {
            return false;
        }
        boolean bl2 = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 2;
        boolean bl3 = bl = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            if (!$assertionsDisabled && instance == null) {
                throw new AssertionError();
            }
            instance.processKeyEvent(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (bl2 || bl) {
            if (!KeyboardPopupSwitcher.isAlive()) {
                RecentViewListAction recentViewListAction = new RecentViewListAction();
                recentViewListAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "C-TAB"));
                return true;
            }
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (keyEvent.getKeyCode() == 17 && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            return true;
        }
        return false;
    }

    public static void selectItem(SwitcherTableItem[] switcherTableItemArray, int n, int n2) {
        if (invokerTimerRunning) {
            return;
        }
        items = switcherTableItemArray;
        releaseKey = n;
        triggerKey = n2;
        invokerTimer = new Timer(200, new PopupInvoker());
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int n) {
        Dimension dimension = this.pTable.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        this.x = rectangle.x + (rectangle.width / 2 - dimension.width / 2);
        this.y = rectangle.y + (rectangle.height / 2 - dimension.height / 2);
        int n2 = this.pTable.getColumnCount();
        int n3 = this.pTable.getRowCount();
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError((Object)"There aren't any columns in the KeyboardPopupSwitcher's table");
        }
        if (!$assertionsDisabled && n3 <= 0) {
            throw new AssertionError((Object)"There aren't any rows in the KeyboardPopupSwitcher's table");
        }
        this.changeTableSelection(n3 > n ? n : n, 0);
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            popup = PopupFactory.getSharedInstance().getPopup(WindowManager.getDefault().getMainWindow(), (Component)this.pTable, this.x, this.y);
            popup.show();
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent keyEvent) {
        if (keyEvent.getID() != 402 && invokerTimerRunning) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == releaseKey) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            RecentViewListAction recentViewListAction = new RecentViewListAction();
            recentViewListAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "immediately"));
            keyEvent.consume();
        } else if (n == triggerKey && keyEvent.getModifiers() == 2) {
            keyEvent.consume();
            if (++hits > 1) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(hits);
                instance.showPopup();
            }
        }
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 402: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = true;
                } else if (n == triggerKey) {
                    int n2 = this.pTable.getRowCount() - 1;
                    int n3 = this.pTable.getColumnCount() - 1;
                    int n4 = this.pTable.getSelectedRow();
                    int n5 = this.pTable.getSelectedColumn();
                    int n6 = n4;
                    int n7 = n5;
                    if (this.fwd) {
                        if (n4 >= n2) {
                            n6 = 0;
                            n7 = n5 >= n3 ? 0 : ++n7;
                        } else if (this.pTable.getValueAt(++n6, n7) == null) {
                            n6 = 0;
                            n7 = 0;
                        }
                    } else if (n4 == 0) {
                        if (n5 == 0) {
                            n7 = n3;
                            n6 = this.pTable.getLastValidRow();
                        } else {
                            --n7;
                            n6 = n2;
                        }
                    } else {
                        --n6;
                    }
                    if (n6 >= 0 && n7 >= 0) {
                        this.changeTableSelection(n6, n7);
                    }
                } else if (n == 27) {
                    this.cancelSwiching();
                } else if (n == releaseKey) {
                    this.performSwitching();
                }
                keyEvent.consume();
                break;
            }
            case 401: {
                if (keyEvent.getKeyCode() != reverseKey) break;
                this.fwd = false;
                keyEvent.consume();
            }
        }
    }

    private void changeTableSelection(int n, int n2) {
        this.pTable.changeSelection(n, n2, false, false);
        String string = this.pTable.getSelectedItem().getDescription();
        StatusDisplayer.getDefault().setStatusText(string != null ? string : "");
    }

    private void cancelSwiching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void performSwitching() {
        if (popup != null) {
            this.pTable.getSelectedItem().activate();
        }
        this.cancelSwiching();
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    static {
        $assertionsDisabled = !KeyboardPopupSwitcher.class.desiredAssertionStatus();
        reverseKey = 16;
        settings = (IDESettings)SharedClassObject.findObject((Class)IDESettings.class, (boolean)true);
    }

    private class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        public void run() {
            this.toHide.hide();
            shown = false;
            hits = 0;
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private PopupInvoker() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(hits);
                instance.showPopup();
            }
        }
    }
}

