/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.MultiSplitPane;

public class SplitView
extends ViewElement {
    private int orientation;
    private ArrayList splitWeights;
    private ArrayList children;
    private MultiSplitPane splitPane;
    private boolean isDirty = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SplitView(Controller controller, double d, int n, List list, List list2) {
        super(controller, d);
        this.orientation = n;
        this.splitWeights = new ArrayList(list);
        this.children = new ArrayList(list2);
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setSplitWeights(List list) {
        this.splitWeights.clear();
        this.splitWeights.addAll(list);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public List getChildren() {
        return new ArrayList(this.children);
    }

    public Component getComponent() {
        return this.getSplitPane();
    }

    public void remove(ViewElement viewElement) {
        int n = this.children.indexOf(viewElement);
        if (n >= 0) {
            this.children.remove(n);
            this.splitWeights.remove(n);
            if (null != this.splitPane) {
                this.splitPane.removeViewElementAt(n);
            }
            this.isDirty = true;
        }
    }

    public void setChildren(List list) {
        this.children.clear();
        this.children.addAll(list);
        if (!$assertionsDisabled && this.children.size() != this.splitWeights.size()) {
            throw new AssertionError();
        }
        this.isDirty = true;
        if (null != this.splitPane) {
            this.updateSplitPane();
        }
    }

    public boolean updateAWTHierarchy(Dimension dimension) {
        boolean bl = false;
        if (!dimension.equals(this.getSplitPane().getSize()) || this.isDirty) {
            this.isDirty = false;
            this.getSplitPane().setSize(dimension);
            this.getSplitPane().invalidate();
            bl = true;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ViewElement viewElement = (ViewElement)iterator.next();
            bl |= viewElement.updateAWTHierarchy(viewElement.getComponent().getSize());
        }
        return bl;
    }

    private MultiSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new MultiSplitPane();
            this.updateSplitPane();
            this.splitPane.setDividerSize(this.orientation == 0 ? 4 : 5);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.splitPane.addPropertyChangeListener("splitPositions", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ArrayList arrayList = new ArrayList(SplitView.this.children.size());
                    ArrayList arrayList2 = new ArrayList(SplitView.this.children.size());
                    SplitView.this.splitPane.calculateSplitWeights(arrayList2, arrayList);
                    ViewElement[] viewElementArray = new ViewElement[arrayList2.size()];
                    double[] dArray = new double[arrayList2.size()];
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        viewElementArray[i] = (ViewElement)arrayList2.get(i);
                        dArray[i] = (Double)arrayList.get(i);
                    }
                    SplitView.this.getController().userMovedSplit(SplitView.this, viewElementArray, dArray);
                }
            });
        }
        return this.splitPane;
    }

    public int getDividerSize() {
        return this.getSplitPane().getDividerSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[");
        for (int i = 0; i < this.children.size(); ++i) {
            ViewElement viewElement = (ViewElement)this.children.get(i);
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            if (viewElement instanceof SplitView) {
                stringBuffer.append(viewElement.getClass());
                stringBuffer.append('@');
                stringBuffer.append(Integer.toHexString(viewElement.hashCode()));
            } else {
                stringBuffer.append(viewElement.toString());
            }
            if (i >= this.children.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void updateSplitPane() {
        ViewElement[] viewElementArray = new ViewElement[this.children.size()];
        double[] dArray = new double[this.children.size()];
        for (int i = 0; i < this.children.size(); ++i) {
            ViewElement viewElement;
            viewElementArray[i] = viewElement = (ViewElement)this.children.get(i);
            dArray[i] = (Double)this.splitWeights.get(i);
        }
        this.splitPane.setChildren(this.orientation, viewElementArray, dArray);
    }

    private static void debugLog(String string) {
        Debug.log(SplitView.class, string);
    }

    static {
        $assertionsDisabled = !SplitView.class.desiredAssertionStatus();
    }
}

