/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ControllerHandler;
import org.netbeans.core.windows.view.EditorView;
import org.netbeans.core.windows.view.ElementAccessor;
import org.netbeans.core.windows.view.ModeAccessor;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.SplitAccessor;
import org.netbeans.core.windows.view.SplitView;
import org.netbeans.core.windows.view.View;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ViewEvent;
import org.netbeans.core.windows.view.ViewHelper;
import org.netbeans.core.windows.view.ViewHierarchy;
import org.netbeans.core.windows.view.WindowSystemAccessor;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.openide.ErrorManager;
import org.openide.awt.ToolbarPool;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

class DefaultView
implements View,
Controller,
WindowDnDManager.ViewAccessor {
    private final ViewHierarchy hierarchy = new ViewHierarchy(this, new WindowDnDManager(this));
    private final ControllerHandler controllerHandler;
    private final Set showingTopComponents = new WeakSet(10);
    private static final boolean DEBUG = Debug.isLoggable(DefaultView.class);

    public DefaultView(ControllerHandler controllerHandler) {
        this.controllerHandler = controllerHandler;
    }

    public boolean isDragInProgress() {
        return this.hierarchy.isDragInProgress();
    }

    public Frame getMainWindow() {
        return this.hierarchy.getMainWindow();
    }

    public String guessSlideSide(TopComponent topComponent) {
        String string = "left";
        if (this.hierarchy.getMaximizedModeView() != null) {
            string = (String)topComponent.getClientProperty((Object)"lastSlideSide");
            if (string == null) {
                string = "left";
            }
        } else {
            Rectangle rectangle = topComponent.getBounds();
            Rectangle rectangle2 = this.hierarchy.getPureEditorAreaBounds();
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, (Component)topComponent);
            if (rectangle2.x > point.x) {
                string = "left";
            }
            if (rectangle2.x + rectangle2.width < point.x) {
                string = "right";
            }
            if (rectangle2.y + rectangle2.height < point.y) {
                string = "bottom";
            }
            topComponent.putClientProperty((Object)"lastSlideSide", (Object)string);
        }
        return string;
    }

    public void changeGUI(ViewEvent[] viewEventArray, WindowSystemSnapshot windowSystemSnapshot) {
        int n;
        int n2;
        Object object;
        WindowSystemAccessor windowSystemAccessor = ViewHelper.createWindowSystemAccessor(windowSystemSnapshot);
        if (DEBUG) {
            DefaultView.debugLog("CHANGEGUI()");
            DefaultView.debugLog("Structure=" + windowSystemAccessor);
            DefaultView.debugLog("");
        }
        if (windowSystemAccessor != null) {
            this.hierarchy.updateViewHierarchy(windowSystemAccessor.getModeStructureAccessor());
        }
        HashSet hashSet = new HashSet(this.showingTopComponents);
        Set set = this.hierarchy.getShowingTopComponents();
        this.showingTopComponents.clear();
        this.showingTopComponents.addAll(set);
        HashSet hashSet2 = new HashSet(set);
        hashSet2.removeAll(hashSet);
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object = (TopComponent)iterator.next();
            WindowManagerImpl.getInstance().componentShowing((TopComponent)object);
        }
        if (DEBUG) {
            DefaultView.debugLog("ChangeGUI: Checking view events...");
        }
        for (n2 = 0; n2 < viewEventArray.length; ++n2) {
            object = viewEventArray[n2];
            n = ((ViewEvent)object).getType();
            if (DEBUG) {
                DefaultView.debugLog("ViewEvent=" + object);
            }
            if (n != 0) continue;
            if (DEBUG) {
                DefaultView.debugLog("Winsys visibility changed, visible=" + ((ViewEvent)object).getNewValue());
            }
            this.windowSystemVisibilityChanged((Boolean)((ViewEvent)object).getNewValue(), windowSystemAccessor);
            return;
        }
        for (n2 = 0; n2 < viewEventArray.length; ++n2) {
            TopComponent topComponent;
            Object object2;
            object = viewEventArray[n2];
            n = ((ViewEvent)object).getType();
            if (n == 1) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window bounds joined changed");
                }
                if (windowSystemAccessor.getEditorAreaState() != 0 || (object2 = (Rectangle)((ViewEvent)object).getNewValue()) == null) continue;
                this.hierarchy.getMainWindow().setBounds((Rectangle)object2);
                continue;
            }
            if (n == 2) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window bounds separated changed");
                }
                if (windowSystemAccessor.getEditorAreaState() != 1 || (object2 = (Rectangle)((ViewEvent)object).getNewValue()) == null) continue;
                this.hierarchy.getMainWindow().setBounds((Rectangle)object2);
                continue;
            }
            if (n == 3) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window frame state joined changed");
                }
                if (windowSystemAccessor.getEditorAreaState() != 0) continue;
                this.hierarchy.getMainWindow().setExtendedState(windowSystemAccessor.getMainWindowFrameStateJoined());
                continue;
            }
            if (n == 4) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window frame state separated changed");
                }
                if (windowSystemAccessor.getEditorAreaState() != 1) continue;
                this.hierarchy.getMainWindow().setExtendedState(windowSystemAccessor.getMainWindowFrameStateSeparated());
                continue;
            }
            if (n == 5) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area state changed");
                }
                this.hierarchy.updateMainWindowBounds(windowSystemAccessor);
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.setSeparateModesVisible(true);
                continue;
            }
            if (n == 6) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area frame state changed");
                }
                this.hierarchy.updateEditorAreaFrameState(windowSystemAccessor.getEditorAreaFrameState());
                continue;
            }
            if (n == 7) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area bounds changed");
                }
                this.hierarchy.updateEditorAreaBounds((Rectangle)((ViewEvent)object).getNewValue());
                continue;
            }
            if (n == 8) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area constraints changed");
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                continue;
            }
            if (n == 9) {
                if (DEBUG) {
                    DefaultView.debugLog("Active mode changed, mode=" + ((ViewEvent)object).getNewValue());
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 10) {
                if (DEBUG) {
                    DefaultView.debugLog("Toolbar config name changed");
                }
                ToolbarPool.getDefault().setConfiguration(windowSystemAccessor.getToolbarConfigurationName());
                continue;
            }
            if (n == 11) {
                if (DEBUG) {
                    DefaultView.debugLog("Maximized mode changed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(windowSystemAccessor.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 12) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode added");
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                continue;
            }
            if (n == 13) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode removed");
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 14) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode constraints changed");
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                continue;
            }
            if (n == 20) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode bounds changed");
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) == null) continue;
                ((ModeView)object2).getComponent().setBounds((Rectangle)((ViewEvent)object).getNewValue());
                continue;
            }
            if (n == 21) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode state changed");
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) == null) continue;
                ((ModeView)object2).setFrameState((Integer)((ViewEvent)object).getNewValue());
                ((ModeView)object2).updateFrameState();
                continue;
            }
            if (n == 22) {
                if (DEBUG) {
                    DefaultView.debugLog("Selected topcomponent changed, tc=" + ((ViewEvent)object).getNewValue());
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 23) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent added");
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.setSeparateModesVisible(true);
                object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()));
                if (object2 == null) continue;
                ((ModeView)object2).updateFrameState();
                continue;
            }
            if (n == 24) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent removed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(windowSystemAccessor.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop(windowSystemAccessor);
                object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()));
                if (object2 != null) {
                    ((ModeView)object2).removeTopComponent((TopComponent)((ViewEvent)object).getNewValue());
                }
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 31) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent display name changed, tc=" + ((ViewEvent)object).getNewValue());
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) == null) continue;
                ((ModeView)object2).updateName((TopComponent)((ViewEvent)object).getNewValue());
                continue;
            }
            if (n == 32) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent display name annotation changed, tc=" + ((ViewEvent)object).getNewValue());
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) == null) continue;
                ((ModeView)object2).updateName((TopComponent)((ViewEvent)object).getNewValue());
                continue;
            }
            if (n == 33) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent tooltip changed, tc=" + ((ViewEvent)object).getNewValue());
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) == null) continue;
                ((ModeView)object2).updateToolTip((TopComponent)((ViewEvent)object).getNewValue());
                continue;
            }
            if (n == 34) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent icon changed");
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) == null) continue;
                ((ModeView)object2).updateIcon((TopComponent)((ViewEvent)object).getNewValue());
                continue;
            }
            if (n == 41) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent attached");
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 42) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent array added:" + Arrays.asList((TopComponent[])((ViewEvent)object).getNewValue()));
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                continue;
            }
            if (n == 43) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent array removed:" + Arrays.asList((TopComponent[])((ViewEvent)object).getNewValue()));
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 44) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent activated, tc=" + ((ViewEvent)object).getNewValue());
                }
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 45) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode closed, mode=" + ((ViewEvent)object).getSource());
                }
                this.hierarchy.updateDesktop();
                continue;
            }
            if (n == 46) {
                if (DEBUG) {
                    DefaultView.debugLog("DnD performed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(windowSystemAccessor.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop();
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 61) {
                if (DEBUG) {
                    DefaultView.debugLog("UI update");
                }
                this.hierarchy.updateUI();
                continue;
            }
            if (n == 62) {
                if (DEBUG) {
                    DefaultView.debugLog("Update project name");
                }
                this.hierarchy.setProjectName(windowSystemAccessor.getProjectName());
                continue;
            }
            if (n == 47 || n == 48) {
                if (DEBUG) {
                    DefaultView.debugLog("Top Component Auto Hide changed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(windowSystemAccessor.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop(windowSystemAccessor);
                this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
                continue;
            }
            if (n == 63) {
                if (DEBUG) {
                    DefaultView.debugLog("Top component request attention");
                }
                if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) != null) {
                    topComponent = (TopComponent)((ViewEvent)object).getNewValue();
                    if (topComponent == null) {
                        throw new NullPointerException("Top component is null for attention request");
                    }
                    ((ModeView)object2).requestAttention(topComponent);
                    continue;
                }
                ErrorManager.getDefault().log(1, "Could not find mode " + ((ViewEvent)object).getSource());
                continue;
            }
            if (n != 64) continue;
            if (DEBUG) {
                DefaultView.debugLog("Top component cancel request attention");
            }
            if ((object2 = this.hierarchy.getModeViewForAccessor(windowSystemAccessor.findModeAccessor((String)((ViewEvent)object).getSource()))) != null) {
                topComponent = (TopComponent)((ViewEvent)object).getNewValue();
                if (topComponent == null) {
                    throw new NullPointerException("Top component is null for attention cancellation request");
                }
                ((ModeView)object2).cancelRequestAttention(topComponent);
                continue;
            }
            ErrorManager.getDefault().log(1, "Could not find mode " + ((ViewEvent)object).getSource());
        }
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.removeAll(set);
        object = hashSet3.iterator();
        while (object.hasNext()) {
            TopComponent topComponent = (TopComponent)object.next();
            WindowManagerImpl.getInstance().componentHidden(topComponent);
        }
    }

    private void windowSystemVisibilityChanged(boolean bl, WindowSystemAccessor windowSystemAccessor) {
        if (bl) {
            this.showWindowSystem(windowSystemAccessor);
        } else {
            this.hideWindowSystem();
        }
    }

    private void showWindowSystem(WindowSystemAccessor windowSystemAccessor) {
        long l = System.currentTimeMillis();
        if (DEBUG) {
            DefaultView.debugLog("ShowWindowSystem--");
        }
        this.hierarchy.getMainWindow().initializeComponents();
        ToolbarPool.getDefault().setConfiguration(windowSystemAccessor.getToolbarConfigurationName());
        if (DEBUG) {
            DefaultView.debugLog(windowSystemAccessor.getModeStructureAccessor().toString());
        }
        this.hierarchy.getMainWindow().prepareWindow();
        if (DEBUG) {
            DefaultView.debugLog("Init view 4=" + (System.currentTimeMillis() - l) + " ms");
        }
        if (DEBUG) {
            DefaultView.debugLog("Init view 2=" + (System.currentTimeMillis() - l) + " ms");
        }
        this.hierarchy.setSplitModesVisible(true);
        if (DEBUG) {
            DefaultView.debugLog("Init view 3=" + (System.currentTimeMillis() - l) + " ms");
        }
        this.hierarchy.getMainWindow().setVisible(true);
        if (windowSystemAccessor.getEditorAreaState() == 0) {
            this.hierarchy.getMainWindow().setExtendedState(windowSystemAccessor.getMainWindowFrameStateJoined());
        } else {
            this.hierarchy.getMainWindow().setExtendedState(windowSystemAccessor.getMainWindowFrameStateSeparated());
        }
        this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(windowSystemAccessor.getMaximizedModeAccessor()));
        this.hierarchy.updateDesktop(windowSystemAccessor);
        this.hierarchy.setSeparateModesVisible(true);
        this.hierarchy.updateEditorAreaFrameState(windowSystemAccessor.getEditorAreaFrameState());
        this.hierarchy.updateFrameStates();
        this.hierarchy.setProjectName(windowSystemAccessor.getProjectName());
        if (windowSystemAccessor.getEditorAreaState() == 0 && this.hierarchy.getMainWindow().getExtendedState() != 6) {
            if (DEBUG) {
                DefaultView.debugLog("do updateMainWindowBoundsSeparatedHelp");
            }
            this.updateMainWindowBoundsSeparatedHelp();
            this.updateEditorAreaBoundsHelp();
        }
        this.hierarchy.activateMode(windowSystemAccessor.getActiveModeAccessor());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DEBUG) {
                    DefaultView.debugLog("Installing main window listeners.");
                }
                DefaultView.this.hierarchy.installMainWindowListeners();
            }
        });
        if (DEBUG) {
            DefaultView.debugLog("Init view 5=" + (System.currentTimeMillis() - l) + " ms");
        }
    }

    private void hideWindowSystem() {
        this.hierarchy.uninstallMainWindowListeners();
        this.hierarchy.setSeparateModesVisible(false);
        this.hierarchy.getMainWindow().setVisible(false);
        this.hierarchy.releaseAll();
    }

    public void userActivatedModeView(ModeView modeView) {
        if (DEBUG) {
            DefaultView.debugLog("User activated mode view, mode=" + modeView);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userActivatedMode(modeImpl);
    }

    public void userActivatedModeWindow(ModeView modeView) {
        if (DEBUG) {
            DefaultView.debugLog("User activated mode window, mode=" + modeView);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userActivatedModeWindow(modeImpl);
    }

    public void userActivatedEditorWindow() {
        if (DEBUG) {
            DefaultView.debugLog("User activated editor window");
        }
        this.controllerHandler.userActivatedEditorWindow();
    }

    public void userSelectedTab(ModeView modeView, TopComponent topComponent) {
        if (DEBUG) {
            DefaultView.debugLog("User selected tab, tc=" + WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent));
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userActivatedTopComponent(modeImpl, topComponent);
    }

    public void userClosingMode(ModeView modeView) {
        if (DEBUG) {
            DefaultView.debugLog("User closing mode=" + modeView);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userClosedMode(modeImpl);
    }

    private void removeModeViewFromHierarchy(ModeView modeView) {
        this.hierarchy.removeModeView(modeView);
        this.hierarchy.updateDesktop();
    }

    public void userResizedMainWindow(Rectangle rectangle) {
        if (DEBUG) {
            DefaultView.debugLog("User resized main window");
        }
        if (this.hierarchy.getMainWindow().getExtendedState() != 6) {
            this.controllerHandler.userResizedMainWindow(rectangle);
        }
        if (this.hierarchy.getMainWindow().getExtendedState() != 6) {
            this.updateMainWindowBoundsSeparatedHelp();
            this.updateEditorAreaBoundsHelp();
            this.updateSeparateBoundsForView(this.hierarchy.getSplitRootElement());
        }
    }

    public void userMovedMainWindow(Rectangle rectangle) {
        if (DEBUG) {
            DefaultView.debugLog("User moved main window");
        }
        if (this.hierarchy.getMainWindow().getExtendedState() != 6) {
            this.controllerHandler.userResizedMainWindow(rectangle);
        }
    }

    public void userResizedEditorArea(Rectangle rectangle) {
        if (DEBUG) {
            DefaultView.debugLog("User resized editor area");
        }
        this.controllerHandler.userResizedEditorArea(rectangle);
    }

    public void userResizedModeBounds(ModeView modeView, Rectangle rectangle) {
        ModeAccessor modeAccessor;
        if (DEBUG) {
            DefaultView.debugLog("User resized mode");
        }
        if ((modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView)) != null) {
            ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
            this.controllerHandler.userResizedModeBounds(modeImpl, rectangle);
        }
    }

    public void userMovedSplit(SplitView splitView, ViewElement[] viewElementArray, double[] dArray) {
        if (DEBUG) {
            DefaultView.debugLog("User moved split");
        }
        SplitAccessor splitAccessor = (SplitAccessor)this.hierarchy.getAccessorForView(splitView);
        ElementAccessor[] elementAccessorArray = new ElementAccessor[viewElementArray.length];
        for (int i = 0; i < viewElementArray.length; ++i) {
            elementAccessorArray[i] = this.hierarchy.getAccessorForView(viewElementArray[i]);
        }
        ViewHelper.setSplitWeights(splitAccessor, elementAccessorArray, dArray, this.controllerHandler);
    }

    public void userClosedTopComponent(ModeView modeView, TopComponent topComponent) {
        if (DEBUG) {
            DefaultView.debugLog("User closed topComponent=" + topComponent);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userClosedTopComponent(modeImpl, topComponent);
    }

    public void userChangedFrameStateMainWindow(int n) {
        if (DEBUG) {
            DefaultView.debugLog("User changed frame state main window");
        }
        this.controllerHandler.userChangedFrameStateMainWindow(n);
    }

    public void userChangedFrameStateEditorArea(int n) {
        if (DEBUG) {
            DefaultView.debugLog("User changed frame state editor area");
        }
        this.controllerHandler.userChangedFrameStateEditorArea(n);
    }

    public void userChangedFrameStateMode(ModeView modeView, int n) {
        if (DEBUG) {
            DefaultView.debugLog("User changed frame state mode");
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userChangedFrameStateMode(modeImpl, n);
    }

    public void userDroppedTopComponents(ModeView modeView, TopComponent[] topComponentArray) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's");
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userDroppedTopComponents(modeImpl, topComponentArray);
    }

    public void userDroppedTopComponents(ModeView modeView, TopComponent[] topComponentArray, int n) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's to index=" + n);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        int n2 = Arrays.asList(modeAccessor.getOpenedTopComponents()).indexOf(topComponentArray[0]);
        if (n2 > -1 && n2 <= n) {
            --n;
        }
        this.controllerHandler.userDroppedTopComponents(modeImpl, topComponentArray, n);
    }

    public void userDroppedTopComponents(ModeView modeView, TopComponent[] topComponentArray, String string) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's to side=" + string);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userDroppedTopComponents(modeImpl, topComponentArray, string);
    }

    public void userDroppedTopComponentsIntoEmptyEditor(TopComponent[] topComponentArray) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's into empty editor");
        }
        this.controllerHandler.userDroppedTopComponentsIntoEmptyEditor(topComponentArray);
    }

    public void userDroppedTopComponentsAround(TopComponent[] topComponentArray, String string) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's around, side=" + string);
        }
        this.controllerHandler.userDroppedTopComponentsAround(topComponentArray, string);
    }

    public void userDroppedTopComponentsAroundEditor(TopComponent[] topComponentArray, String string) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's around editor, side=" + string);
        }
        this.controllerHandler.userDroppedTopComponentsAroundEditor(topComponentArray, string);
    }

    public void userDroppedTopComponentsIntoFreeArea(TopComponent[] topComponentArray, Rectangle rectangle) {
        if (topComponentArray.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's into free area, bounds=" + rectangle);
        }
        this.controllerHandler.userDroppedTopComponentsIntoFreeArea(topComponentArray, rectangle);
    }

    public void userDisabledAutoHide(ModeView modeView, TopComponent topComponent) {
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userDisabledAutoHide(topComponent, modeImpl);
    }

    public void userEnabledAutoHide(ModeView modeView, TopComponent topComponent) {
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        String string = this.guessSlideSide(topComponent);
        this.controllerHandler.userEnabledAutoHide(topComponent, modeImpl, string);
    }

    public void userTriggeredSlideIn(ModeView modeView, SlideOperation slideOperation) {
        this.hierarchy.performSlideIn(slideOperation);
    }

    public void userTriggeredSlideOut(ModeView modeView, SlideOperation slideOperation) {
        this.hierarchy.performSlideOut(slideOperation);
        if (slideOperation.requestsActivation()) {
            ModeView modeView2 = this.hierarchy.getLastNonSlidingActiveModeView();
            ModeImpl modeImpl = null;
            if (modeView2 != null) {
                modeImpl = DefaultView.getModeForModeAccessor((ModeAccessor)this.hierarchy.getAccessorForView(modeView2));
            }
            if (modeImpl != null) {
                this.controllerHandler.userActivatedMode(modeImpl);
            } else {
                this.controllerHandler.userActivatedEditorWindow();
            }
        }
    }

    public void userTriggeredSlideIntoDesktop(ModeView modeView, SlideOperation slideOperation) {
        this.hierarchy.performSlideIntoDesktop(slideOperation);
    }

    public void userTriggeredSlideIntoEdge(ModeView modeView, SlideOperation slideOperation) {
        this.hierarchy.performSlideIntoEdge(slideOperation);
    }

    public void userResizedSlidingWindow(ModeView modeView, SlideOperation slideOperation) {
        ((SlidingView)modeView).setSlideBounds(modeView.getSelectedTopComponent().getBounds());
        this.hierarchy.performSlideResize(slideOperation);
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl modeImpl = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userResizedSlidingMode(modeImpl, slideOperation.getFinishBounds());
    }

    private static ModeImpl getModeForModeAccessor(ModeAccessor modeAccessor) {
        return modeAccessor == null ? null : modeAccessor.getMode();
    }

    private static ModelElement getModelElementForAccessor(ElementAccessor elementAccessor) {
        return elementAccessor == null ? null : elementAccessor.getOriginator();
    }

    private void updateMainWindowBoundsSeparatedHelp() {
        this.controllerHandler.userResizedMainWindowBoundsSeparatedHelp(this.hierarchy.getMainWindow().getPureMainWindowBounds());
    }

    private void updateEditorAreaBoundsHelp() {
        Rectangle rectangle = this.hierarchy.getPureEditorAreaBounds();
        this.controllerHandler.userResizedEditorAreaBoundsHelp(rectangle);
    }

    void updateSeparateBoundsForView(ViewElement viewElement) {
        Object object;
        Object object2;
        if (viewElement.getComponent() instanceof JComponent) {
            object2 = (JComponent)viewElement.getComponent();
            object = new Dimension(((Component)object2).getSize());
            ((JComponent)object2).setPreferredSize((Dimension)object);
            ((JComponent)object2).putClientProperty("lastAvailableSpace", object);
        }
        if (viewElement instanceof ModeView) {
            object2 = (ModeView)viewElement;
            object = (ModeAccessor)this.hierarchy.getAccessorForView((ViewElement)object2);
            if (object != null) {
                Component component = ((ModeView)object2).getComponent();
                Rectangle rectangle = component.getBounds();
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, component);
                rectangle.setLocation(point);
                ModeImpl modeImpl = DefaultView.getModeForModeAccessor((ModeAccessor)object);
                this.controllerHandler.userResizedModeBoundsSeparatedHelp(modeImpl, rectangle);
            }
        } else if (viewElement instanceof SplitView) {
            object2 = (SplitView)viewElement;
            object = ((SplitView)object2).getChildren();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ViewElement viewElement2 = (ViewElement)iterator.next();
                this.updateSeparateBoundsForView(viewElement2);
            }
        } else if (viewElement instanceof EditorView) {
            this.updateEditorAreaBoundsHelp();
        }
    }

    public Set getModeComponents() {
        return this.hierarchy.getModeComponents();
    }

    public Set getSeparateModeFrames() {
        return this.hierarchy.getSeparateModeFrames();
    }

    public Controller getController() {
        return this;
    }

    public Component getSlidingModeComponent(String string) {
        return this.hierarchy.getSlidingModeComponent(string);
    }

    private static void debugLog(String string) {
        Debug.log(DefaultView.class, string);
    }
}

