/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.NbSheet;
import org.netbeans.core.windows.services.FileSelector;
import org.netbeans.core.windows.services.NbPresenter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NodeOperationImpl
extends NodeOperation {
    static /* synthetic */ Class class$org$netbeans$core$windows$services$NodeOperationImpl;

    public void explore(final Node node) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                NonPersistentExplorerTab nonPersistentExplorerTab = new NonPersistentExplorerTab();
                nonPersistentExplorerTab.setRootContext(node);
                nonPersistentExplorerTab.adjustComponentPersistence();
                Mode mode = WindowManager.getDefault().findMode("explorer");
                if (mode != null) {
                    mode.dockInto((TopComponent)nonPersistentExplorerTab);
                }
                nonPersistentExplorerTab.open();
                nonPersistentExplorerTab.requestActive();
            }
        });
    }

    public boolean customize(Node node) {
        final Component component = node.getCustomizer();
        if (component == null) {
            return false;
        }
        return (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                if (component instanceof NbPresenter) {
                    ((NbPresenter)component).pack();
                    ((NbPresenter)component).show();
                    return Boolean.TRUE;
                }
                if (component instanceof Window) {
                    ((Window)component).pack();
                    component.setVisible(true);
                    return Boolean.TRUE;
                }
                HelpFwdPanel helpFwdPanel = null;
                helpFwdPanel = component instanceof ExplorerManager.Provider ? new ExplorerProviderFwd(component, (ExplorerManager.Provider)component) : new HelpFwdPanel(component);
                helpFwdPanel.setLayout(new BorderLayout());
                helpFwdPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$services$NodeOperationImpl == null ? (class$org$netbeans$core$windows$services$NodeOperationImpl = NodeOperationImpl.class$("org.netbeans.core.windows.services.NodeOperationImpl")) : class$org$netbeans$core$windows$services$NodeOperationImpl), (String)"CTL_Customizer_dialog_title"));
                if (component.getClass().getName().startsWith("org.netbeans.modules.xml.catalog")) {
                    helpFwdPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                }
                helpFwdPanel.add(component, "Center");
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)helpFwdPanel, NbBundle.getMessage((Class)(class$org$netbeans$core$windows$services$NodeOperationImpl == null ? (class$org$netbeans$core$windows$services$NodeOperationImpl = NodeOperationImpl.class$("org.netbeans.core.windows.services.NodeOperationImpl")) : class$org$netbeans$core$windows$services$NodeOperationImpl), (String)"CTL_Customizer_dialog_title"));
                dialogDescriptor.setOptions(new Object[]{DialogDescriptor.CLOSED_OPTION});
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.pack();
                dialog.show();
                return Boolean.TRUE;
            }
        });
    }

    public void showProperties(Node node) {
        NbSheet nbSheet = new NbSheet();
        Node[] nodeArray = new Node[]{node};
        nbSheet.setNodes(nodeArray);
        NodeOperationImpl.openProperties((TopComponent)nbSheet, nodeArray);
    }

    public void showProperties(Node[] nodeArray) {
        NbSheet nbSheet = new NbSheet();
        nbSheet.setNodes(nodeArray);
        NodeOperationImpl.openProperties((TopComponent)nbSheet, nodeArray);
    }

    public Node[] select(String string, String string2, Node node, NodeAcceptor nodeAcceptor, Component component) throws UserCancelException {
        FileSelector fileSelector = new FileSelector(string2, node, nodeAcceptor, component);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)fileSelector, string, true, fileSelector.getOptions(), fileSelector.getSelectOption(), 0, HelpCtx.DEFAULT_HELP, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object != fileSelector.getSelectOption()) {
            throw new UserCancelException();
        }
        return fileSelector.getNodes();
    }

    private static void openProperties(final TopComponent topComponent, final Node[] nodeArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl = NbPresenter.currentModalDialog != null;
                Dialog dialog = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)topComponent, topComponent.getName(), bl, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null));
                SheetNodesListener sheetNodesListener = new SheetNodesListener(dialog, topComponent);
                sheetNodesListener.attach(nodeArray);
                dialog.show();
            }
        });
    }

    private static final class ExplorerProviderFwd
    extends HelpFwdPanel
    implements ExplorerManager.Provider {
        private ExplorerManager.Provider explProvider;

        private ExplorerProviderFwd(Component component, ExplorerManager.Provider provider) {
            super(component);
            this.explProvider = provider;
        }

        public ExplorerManager getExplorerManager() {
            return this.explProvider.getExplorerManager();
        }
    }

    private static class HelpFwdPanel
    extends JPanel
    implements HelpCtx.Provider {
        private Component innerComp;
        private boolean active = false;

        private HelpFwdPanel(Component component) {
            this.innerComp = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HelpCtx getHelpCtx() {
            try {
                if (this.active) {
                    HelpCtx helpCtx = null;
                    return helpCtx;
                }
                this.active = true;
                HelpCtx helpCtx = HelpCtx.findHelp((Component)this.innerComp);
                return helpCtx;
            }
            finally {
                this.active = false;
            }
        }
    }

    private static class NonPersistentExplorerTab
    extends NbMainExplorer.ExplorerTab {
        private NonPersistentExplorerTab() {
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "NonPersistentExplorerTab";
        }
    }

    private static class SheetNodesListener
    extends NodeAdapter
    implements PropertyChangeListener {
        private Dialog dialog;
        private Set listenerSet;
        private TopComponent tc;

        SheetNodesListener(Dialog dialog, TopComponent topComponent) {
            this.dialog = dialog;
            this.tc = topComponent;
            topComponent.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("name".equals(propertyChangeEvent.getPropertyName())) {
                this.dialog.setTitle((String)propertyChangeEvent.getNewValue());
            }
        }

        public void attach(Node[] nodeArray) {
            this.listenerSet = new HashSet(nodeArray.length * 2);
            for (int i = 0; i < nodeArray.length; ++i) {
                this.listenerSet.add(nodeArray[i]);
                nodeArray[i].addNodeListener((NodeListener)this);
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            node.removeNodeListener((NodeListener)this);
            this.listenerSet.remove(node);
            if (this.listenerSet.isEmpty()) {
                this.tc.removePropertyChangeListener((PropertyChangeListener)this);
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        SheetNodesListener.this.dialog.hide();
                        SheetNodesListener.this.dialog.dispose();
                        SheetNodesListener.this.dialog = null;
                    }
                });
            }
        }
    }
}

