/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.DataSystem;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class FileSelector
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    static final long serialVersionUID = 6524404012203099065L;
    private final ExplorerManager manager = new ExplorerManager();
    private BeanTreeView tree;
    private JButton okButton;
    private JButton cancelButton;
    private JButton[] buttons;
    private NodeAcceptor acceptor;

    public FileSelector(String string, Node node, NodeAcceptor nodeAcceptor, Component component) {
        this.acceptor = nodeAcceptor;
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)FileSelector.class);
        this.okButton = new JButton(resourceBundle.getString("CTL_FileSelectorOkButton"));
        this.cancelButton = new JButton(resourceBundle.getString("CTL_FileSelectorCancelButton"));
        this.okButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FileSelectorOkButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FileSelectorCancelButton"));
        this.buttons = new JButton[]{this.okButton, this.cancelButton};
        this.manager.setRootContext(node);
        this.tree = new BeanTreeView();
        this.tree.setPopupAllowed(false);
        this.tree.setDefaultActionAllowed(false);
        this.tree.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)FileSelector.class).getString("ACSN_FileSelectorTreeView"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FileSelector.class).getString("ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)FileSelector.class).getString("ACSD_FileSelectorDialog"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
        try {
            Node[] nodeArray;
            if (node instanceof DataSystem && (nodeArray = node.getChildren().getNodes()).length > 0) {
                final JComboBox<Node> jComboBox = new JComboBox<Node>(nodeArray);
                jComboBox.setRenderer(new FileSelectRenderer());
                jComboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Node node = (Node)jComboBox.getSelectedItem();
                        FileSelector.this.manager.setRootContext(node);
                    }
                });
                jComboBox.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FileSelectorComboBox"));
                this.manager.setSelectedNodes(new Node[]{nodeArray[0]});
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout(5, 0));
                JLabel jLabel = new JLabel(string.replace('&', ' '));
                jLabel.setDisplayedMnemonic(string.charAt(string.indexOf(38) + 1));
                jLabel.setLabelFor(jComboBox);
                jPanel.add((Component)jLabel, "West");
                jPanel.add(jComboBox, "Center");
                this.add((Component)jPanel, "North");
            } else {
                this.manager.setSelectedNodes(new Node[]{node});
                JLabel jLabel = new JLabel(string.replace('&', ' '));
                jLabel.setLabelFor((Component)this.tree);
                this.add((Component)jLabel, "North");
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalStateException(propertyVetoException.getMessage());
        }
        if (component != null) {
            this.add(component, "South");
        }
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        if (nodeAcceptor.acceptNodes(this.manager.getSelectedNodes())) {
            this.enableButton();
        } else {
            this.disableButton();
        }
    }

    Object[] getOptions() {
        return this.buttons;
    }

    Object getSelectOption() {
        return this.okButton;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            if (this.acceptor.acceptNodes(this.manager.getSelectedNodes())) {
                this.enableButton();
            } else {
                this.disableButton();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(dimension.height, Utilities.getUsableScreenBounds().height / 2);
        return dimension;
    }

    public Node[] getNodes() {
        return this.manager.getSelectedNodes();
    }

    void enableButton() {
        this.okButton.setEnabled(true);
    }

    void disableButton() {
        this.okButton.setEnabled(false);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static class FileSelectRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -7071698027341621636L;
        protected static Border hasFocusBorder;
        protected static Border noFocusBorder;

        public FileSelectRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
            hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof Node)) {
                return this;
            }
            Node node = (Node)object;
            ImageIcon imageIcon = new ImageIcon(node.getIcon(1));
            this.setIcon(imageIcon);
            this.setText(node.getDisplayName());
            if (bl) {
                super.setBackground(UIManager.getColor("List.selectionBackground"));
                super.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                super.setBackground(jList.getBackground());
                super.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

