/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.persistence.InternalConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class TCRefParser {
    public static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Top Component in Mode Properties 1.0//EN";
    public static final String INSTANCE_DTD_ID_2_0 = "-//NetBeans//DTD Top Component in Mode Properties 2.0//EN";
    public static final String INSTANCE_DTD_ID_2_1 = "-//NetBeans//DTD Top Component in Mode Properties 2.1//EN";
    private static final boolean DEBUG = Debug.isLoggable(TCRefParser.class);
    private String tc_id;
    private FileObject moduleParentFolder;
    private FileObject localParentFolder;
    private InternalConfig internalConfig;
    private boolean inModuleFolder;
    private boolean inLocalFolder;

    public TCRefParser(String string) {
        this.tc_id = string;
    }

    TCRefConfig load() throws IOException {
        if (DEBUG) {
            Debug.log(TCRefParser.class, "load ENTER tcRef:" + this.tc_id);
        }
        TCRefConfig tCRefConfig = new TCRefConfig();
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        internalConfig.clear();
        propertyHandler.readData(tCRefConfig, internalConfig);
        if (DEBUG) {
            Debug.log(TCRefParser.class, "load LEAVE tcRef:" + this.tc_id);
        }
        return tCRefConfig;
    }

    void save(TCRefConfig tCRefConfig) throws IOException {
        if (DEBUG) {
            Debug.log(TCRefParser.class, "save ENTER tcRef:" + this.tc_id);
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        propertyHandler.writeData(tCRefConfig, internalConfig);
        if (DEBUG) {
            Debug.log(TCRefParser.class, "save LEAVE tcRef:" + this.tc_id);
        }
    }

    String getName() {
        return this.tc_id;
    }

    InternalConfig getInternalConfig() {
        if (this.internalConfig == null) {
            this.internalConfig = new InternalConfig();
        }
        return this.internalConfig;
    }

    void setInternalConfig(InternalConfig internalConfig) {
        this.internalConfig = internalConfig;
    }

    boolean isInModuleFolder() {
        return this.inModuleFolder;
    }

    void setInModuleFolder(boolean bl) {
        this.inModuleFolder = bl;
    }

    boolean isInLocalFolder() {
        return this.inLocalFolder;
    }

    void setInLocalFolder(boolean bl) {
        this.inLocalFolder = bl;
    }

    void setModuleParentFolder(FileObject fileObject) {
        this.moduleParentFolder = fileObject;
    }

    void setLocalParentFolder(FileObject fileObject) {
        this.localParentFolder = fileObject;
    }

    void log(String string) {
        Debug.log(TCRefParser.class, string);
    }

    private final class PropertyHandler
    extends DefaultHandler {
        private TCRefConfig tcRefConfig = null;
        private InternalConfig internalConfig = null;
        private final Object RW_LOCK = new Object();

        private FileObject getConfigFOInput() {
            FileObject fileObject = TCRefParser.this.isInLocalFolder() ? TCRefParser.this.localParentFolder.getFileObject(TCRefParser.this.getName(), "wstcref") : (TCRefParser.this.isInModuleFolder() ? TCRefParser.this.moduleParentFolder.getFileObject(TCRefParser.this.getName(), "wstcref") : null);
            return fileObject;
        }

        private FileObject getConfigFOOutput() throws IOException {
            FileObject fileObject = TCRefParser.this.localParentFolder.getFileObject(TCRefParser.this.getName(), "wstcref");
            if (fileObject != null) {
                return fileObject;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TCRefParser.this.getName());
            stringBuffer.append('.');
            stringBuffer.append("wstcref");
            fileObject = FileUtil.createData((FileObject)TCRefParser.this.localParentFolder, (String)stringBuffer.toString());
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readData(TCRefConfig tCRefConfig, InternalConfig internalConfig) throws IOException {
            this.tcRefConfig = tCRefConfig;
            this.internalConfig = internalConfig;
            FileObject fileObject = this.getConfigFOInput();
            if (fileObject == null) {
                throw new FileNotFoundException("[WinSys] Missing TCRef configuration file:" + TCRefParser.this.getName());
            }
            InputStream inputStream = null;
            try {
                Object object = this.RW_LOCK;
                synchronized (object) {
                    inputStream = fileObject.getInputStream();
                    PersistenceManager.getDefault().getXMLParser(this).parse(new InputSource(inputStream));
                }
            }
            catch (SAXException sAXException) {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$persistence$TCRefParser == null ? (class$org$netbeans$core$windows$persistence$TCRefParser = TCRefParser.class$("org.netbeans.core.windows.persistence.TCRefParser")) : class$org$netbeans$core$windows$persistence$TCRefParser), (String)"EXC_TCRefParse", (Object)fileObject);
                IOException iOException = new IOException(string);
                ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)sAXException);
                throw iOException;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            tCRefConfig = this.tcRefConfig;
            internalConfig = this.internalConfig;
            this.tcRefConfig = null;
            this.internalConfig = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("tc-ref".equals(string3)) {
                this.handleTCRef(attributes);
            } else if (this.internalConfig.specVersion.compareTo((Object)new SpecificationVersion("2.0")) >= 0) {
                if ("module".equals(string3)) {
                    this.handleModule(attributes);
                } else if ("tc-id".equals(string3)) {
                    this.handleTcId(attributes);
                } else if ("state".equals(string3)) {
                    this.handleState(attributes);
                } else if ("previousMode".equals(string3)) {
                    this.handlePreviousMode(attributes);
                }
            } else {
                TCRefParser.this.log("-- TCRefParser.startElement PARSING OLD");
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void handleTCRef(Attributes attributes) {
            String string;
            String string2 = attributes.getValue("version");
            if (string2 != null) {
                this.internalConfig.specVersion = new SpecificationVersion(string2);
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handleTCRef] Warning: Missing attribute \"version\" of element \"tc-ref\".");
                this.internalConfig.specVersion = new SpecificationVersion("2.0");
            }
            if (this.internalConfig.specVersion.compareTo((Object)new SpecificationVersion("2.0")) < 0 && (string = attributes.getValue("id")) == null) {
                ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handleTCRef] Warning: Missing attribute \"id\" of element \"tc-ref\".");
            }
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.internalConfig.moduleCodeNameBase = null;
            this.internalConfig.moduleCodeNameRelease = null;
            this.internalConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.internalConfig.moduleCodeNameBase = string.substring(0, n);
                    this.internalConfig.moduleCodeNameRelease = string.substring(n + 1);
                    this.checkReleaseCode(this.internalConfig);
                } else {
                    this.internalConfig.moduleCodeNameBase = string;
                }
                this.internalConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private void checkReleaseCode(InternalConfig internalConfig) {
            if ("null".equals(internalConfig.moduleCodeNameRelease)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + internalConfig.moduleCodeNameBase + "! Repairing."));
                internalConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleTcId(Attributes attributes) throws SAXException {
            String string = attributes.getValue("id");
            if (string != null) {
                this.tcRefConfig.tc_id = string;
                if (!string.equals(TCRefParser.this.getName())) {
                    ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handleTcId] Error: Value of attribute \"id\" of element \"tc-id\" and configuration file name must be the same.");
                    throw new SAXException("Invalid attribute value");
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handleTcId] Error: Missing required attribute \"id\" of element \"tc-id\".");
                throw new SAXException("Missing required attribute");
            }
        }

        private void handleState(Attributes attributes) throws SAXException {
            String string = attributes.getValue("opened");
            if (string != null) {
                if ("true".equals(string)) {
                    this.tcRefConfig.opened = true;
                } else if ("false".equals(string)) {
                    this.tcRefConfig.opened = false;
                } else {
                    ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handleState] Warning: Invalid value of attribute \"opened\" of element \"state\".");
                    this.tcRefConfig.opened = false;
                }
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handleState] Warning: Missing required attribute \"opened\" of element \"state\".");
                this.tcRefConfig.opened = false;
            }
        }

        private void handlePreviousMode(Attributes attributes) throws SAXException {
            String string = attributes.getValue("name");
            if (string != null) {
                this.tcRefConfig.previousMode = string;
            } else {
                ErrorManager.getDefault().log(16, "[WinSys.TCRefParser.handlePreviousMode] Warning: Missing required attribute \"name\" of element \"previousMode\".");
                this.tcRefConfig.previousMode = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(TCRefConfig tCRefConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = this.fillBuffer(tCRefConfig, internalConfig);
            Object object = this.RW_LOCK;
            synchronized (object) {
                FileObject fileObject = this.getConfigFOOutput();
                FileLock fileLock = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private StringBuffer fillBuffer(TCRefConfig tCRefConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(800);
            Object var4_4 = null;
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            stringBuffer.append("<tc-ref version=\"2.1\">\n");
            this.appendModule(internalConfig, stringBuffer);
            this.appendTcId(tCRefConfig, stringBuffer);
            this.appendState(tCRefConfig, stringBuffer);
            if (tCRefConfig.previousMode != null) {
                this.appendPreviousMode(tCRefConfig, stringBuffer);
            }
            stringBuffer.append("</tc-ref>\n");
            return stringBuffer;
        }

        private void appendModule(InternalConfig internalConfig, StringBuffer stringBuffer) {
            if (internalConfig == null) {
                return;
            }
            if (internalConfig.moduleCodeNameBase != null) {
                stringBuffer.append("    <module");
                stringBuffer.append(" name=\"");
                stringBuffer.append(internalConfig.moduleCodeNameBase);
                if (internalConfig.moduleCodeNameRelease != null) {
                    stringBuffer.append("/" + internalConfig.moduleCodeNameRelease);
                }
                if (internalConfig.moduleSpecificationVersion != null) {
                    stringBuffer.append("\" spec=\"");
                    stringBuffer.append(internalConfig.moduleSpecificationVersion);
                }
                stringBuffer.append("\" />\n");
            }
        }

        private void appendTcId(TCRefConfig tCRefConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <tc-id");
            stringBuffer.append(" id=\"");
            stringBuffer.append(PersistenceManager.escapeTcId4XmlContent(tCRefConfig.tc_id));
            stringBuffer.append("\"");
            stringBuffer.append(" />\n");
        }

        private void appendState(TCRefConfig tCRefConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <state");
            stringBuffer.append(" opened=\"");
            if (tCRefConfig.opened) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append("false");
            }
            stringBuffer.append("\"");
            stringBuffer.append(" />\n");
        }

        private void appendPreviousMode(TCRefConfig tCRefConfig, StringBuffer stringBuffer) {
            stringBuffer.append("    <previousMode name=\"");
            stringBuffer.append(tCRefConfig.previousMode);
            stringBuffer.append("\" />\n");
        }
    }
}

