/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.model.EditorSplitSubModel;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.SplitSubModel;

final class ModesSubModel {
    private final Model parentModel;
    private final Set modes = new HashSet(10);
    private final EditorSplitSubModel editorSplitSubModel;
    private final HashMap slidingModes2Sides = new HashMap(5);
    private final HashMap slidingSides2Modes = new HashMap(5);
    private ModeImpl activeMode;
    private ModeImpl maximizedMode;

    public ModesSubModel(Model model) {
        this.parentModel = model;
        this.editorSplitSubModel = new EditorSplitSubModel(model, new SplitSubModel(model));
    }

    public void setEditorAreaConstraints(SplitConstraint[] splitConstraintArray) {
        this.editorSplitSubModel.setEditorNodeConstraints(splitConstraintArray);
    }

    public SplitConstraint[] getModelElementConstraints(ModelElement modelElement) {
        return this.editorSplitSubModel.getModelElementConstraints(modelElement);
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.editorSplitSubModel.getEditorNodeConstraints();
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        if (modeImpl.getKind() == 1) {
            return this.editorSplitSubModel.getEditorArea().getModeConstraints(modeImpl);
        }
        return this.editorSplitSubModel.getModeConstraints(modeImpl);
    }

    public String getSlidingModeConstraints(ModeImpl modeImpl) {
        return (String)this.slidingModes2Sides.get(modeImpl);
    }

    public ModeImpl getSlidingMode(String string) {
        return (ModeImpl)this.slidingSides2Modes.get(string);
    }

    public Set getSlidingModes() {
        return Collections.unmodifiableSet(this.slidingModes2Sides.keySet());
    }

    public boolean addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? this.editorSplitSubModel.getEditorArea().addMode(modeImpl, splitConstraintArray) : this.editorSplitSubModel.addMode(modeImpl, splitConstraintArray);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeToSide(ModeImpl modeImpl, ModeImpl modeImpl2, String string) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? this.editorSplitSubModel.getEditorArea().addModeToSide(modeImpl, modeImpl2, string) : this.editorSplitSubModel.addModeToSide(modeImpl, modeImpl2, string);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeAround(ModeImpl modeImpl, String string) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? false : this.editorSplitSubModel.addModeAround(modeImpl, string);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeAroundEditor(ModeImpl modeImpl, String string) {
        if (this.modes.contains(modeImpl)) {
            return false;
        }
        boolean bl = modeImpl.getKind() == 1 ? false : this.editorSplitSubModel.addModeAroundEditor(modeImpl, string);
        if (bl) {
            this.modes.add(modeImpl);
        }
        return bl;
    }

    public boolean addModeSliding(ModeImpl modeImpl, String string) {
        if (this.modes.contains(modeImpl) || modeImpl.getKind() != 2) {
            return false;
        }
        this.slidingModes2Sides.put(modeImpl, string);
        this.slidingSides2Modes.put(string, modeImpl);
        this.modes.add(modeImpl);
        return true;
    }

    public boolean removeMode(ModeImpl modeImpl) {
        int n = modeImpl.getKind();
        if (n == 2) {
            return true;
        }
        this.modes.remove(modeImpl);
        if (modeImpl.getKind() == 1) {
            return this.editorSplitSubModel.getEditorArea().removeMode(modeImpl);
        }
        return this.editorSplitSubModel.removeMode(modeImpl);
    }

    public boolean setActiveMode(ModeImpl modeImpl) {
        if (modeImpl == null || this.modes.contains(modeImpl)) {
            this.activeMode = modeImpl;
            return true;
        }
        return false;
    }

    public ModeImpl getActiveMode() {
        return this.activeMode;
    }

    public boolean setMaximizedMode(ModeImpl modeImpl) {
        if (modeImpl == null || this.modes.contains(modeImpl)) {
            this.maximizedMode = modeImpl;
            return true;
        }
        return false;
    }

    public ModeImpl getMaximizedMode() {
        return this.maximizedMode;
    }

    public Set getModes() {
        return new HashSet(this.modes);
    }

    public void setSplitWeights(ModelElement[] modelElementArray, double[] dArray) {
        this.editorSplitSubModel.setSplitWeights(modelElementArray, dArray);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "\n" + this.editorSplitSubModel;
    }

    public ModeStructureSnapshot.ElementSnapshot createSplitSnapshot() {
        return this.editorSplitSubModel.createSplitSnapshot();
    }

    public Set createSeparateModeSnapshots() {
        HashSet hashSet = new HashSet();
        if (this.parentModel.getEditorAreaState() == 0) {
            return hashSet;
        }
        hashSet.addAll(this.editorSplitSubModel.createSeparateSnapshots());
        return hashSet;
    }

    public Set createSlidingModeSnapshots() {
        HashSet<ModeStructureSnapshot.SlidingModeSnapshot> hashSet = new HashSet<ModeStructureSnapshot.SlidingModeSnapshot>();
        Iterator iterator = this.slidingModes2Sides.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashSet.add(new ModeStructureSnapshot.SlidingModeSnapshot((ModeImpl)entry.getKey(), (String)entry.getValue()));
        }
        return hashSet;
    }

    public ModeImpl getModeForOriginator(ModelElement modelElement) {
        ModeImpl modeImpl = this.editorSplitSubModel.getModeForOriginator(modelElement);
        if (this.modes.contains(modeImpl)) {
            return modeImpl;
        }
        return null;
    }
}

