/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.model.TopComponentGroupModel;
import org.openide.windows.TopComponent;

final class DefaultTopComponentGroupModel
implements TopComponentGroupModel {
    private final String name;
    private boolean opened;
    private final Set topComponents = new HashSet(3);
    private final Set openedTopComponents = new HashSet(3);
    private final Set openedBeforeTopComponents = new HashSet(3);
    private final Set openingTopComponents = new HashSet(3);
    private final Set closingTopComponents = new HashSet(3);
    private final Object LOCK_OPENED = new Object();
    private final Object LOCK_TOPCOMPONENTS = new Object();

    public DefaultTopComponentGroupModel(String string, boolean bl) {
        this.name = string;
        this.opened = bl;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Collection collection, Collection collection2) {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            String string;
            this.opened = true;
            this.openedTopComponents.clear();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = DefaultTopComponentGroupModel.getID((TopComponent)iterator.next());
                if (string == null) continue;
                this.openedTopComponents.add(string);
            }
            this.openedBeforeTopComponents.clear();
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                string = DefaultTopComponentGroupModel.getID((TopComponent)iterator.next());
                if (string == null) continue;
                this.openedBeforeTopComponents.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            this.opened = false;
            this.openedTopComponents.clear();
            this.openedBeforeTopComponents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            return this.opened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTopComponents() {
        HashSet hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_TOPCOMPONENTS;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.topComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent((String)iterator.next());
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedTopComponents() {
        HashSet hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_OPENED;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.openedTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent((String)iterator.next());
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedBeforeTopComponents() {
        HashSet hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_OPENED;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.openedBeforeTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent((String)iterator.next());
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpeningTopComponents() {
        HashSet hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_TOPCOMPONENTS;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.openingTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent((String)iterator.next());
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getClosingTopComponents() {
        HashSet hashSet;
        HashSet<TopComponent> hashSet2 = this.LOCK_TOPCOMPONENTS;
        synchronized (hashSet2) {
            hashSet = new HashSet(this.closingTopComponents);
        }
        hashSet2 = new HashSet<TopComponent>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            TopComponent topComponent = DefaultTopComponentGroupModel.getTopComponent((String)iterator.next());
            if (topComponent == null) continue;
            hashSet2.add(topComponent);
        }
        return hashSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponents.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnloadedTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (this.openingTopComponents.contains(string)) {
                this.openingTopComponents.remove(string);
            }
            if (this.closingTopComponents.contains(string)) {
                this.closingTopComponents.remove(string);
            }
            return this.topComponents.remove(string);
        }
    }

    public boolean addOpeningTopComponent(TopComponent topComponent) {
        return this.addUnloadedOpeningTopComponent(DefaultTopComponentGroupModel.getID(topComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedOpeningTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(string)) {
                this.topComponents.add(string);
            }
            return this.openingTopComponents.add(string);
        }
    }

    public boolean removeOpeningTopComponent(TopComponent topComponent) {
        return this.removeUnloadedOpeningTopComponent(DefaultTopComponentGroupModel.getID(topComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnloadedOpeningTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.openingTopComponents.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedClosingTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(string)) {
                this.topComponents.add(string);
            }
            return this.closingTopComponents.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnloadedClosingTopComponent(String string) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.closingTopComponents.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedOpenedTopComponent(String string) {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            if (!this.opened) {
                return false;
            }
            this.openedTopComponents.add(string);
        }
        return true;
    }

    private static TopComponent getTopComponent(String string) {
        return WindowManagerImpl.getInstance().getTopComponentForID(string);
    }

    private static String getID(TopComponent topComponent) {
        return WindowManagerImpl.getInstance().findTopComponentID(topComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.topComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpeningSetIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.openingTopComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getClosingSetIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.closingTopComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.openedTopComponents);
        }
    }
}

