/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class MaximizeWindowAction
extends AbstractAction {
    private final PropertyChangeListener propListener;
    private TopComponent topComponent;
    private boolean isPopup;
    private static boolean isFirstActivated = true;

    public MaximizeWindowAction() {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("maximizedMode".equals(string) || "editorAreaState".equals(propertyChangeEvent.getPropertyName()) || "activeMode".equals(propertyChangeEvent.getPropertyName())) {
                    MaximizeWindowAction.this.updateState();
                }
                if (isFirstActivated && "activated".equals(string)) {
                    isFirstActivated = false;
                    MaximizeWindowAction.this.updateState();
                }
            }
        };
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        windowManagerImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)windowManagerImpl)));
        this.updateState();
    }

    MaximizeWindowAction(TopComponent topComponent) {
        this.topComponent = topComponent;
        this.propListener = null;
        this.isPopup = true;
        this.updateState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (windowManagerImpl.getEditorAreaState() == 0) {
            if (this.topComponent != null) {
                ModeImpl modeImpl = MaximizeWindowAction.getModeToMaximize(this.topComponent);
                if (modeImpl == null || modeImpl.getKind() != 2) {
                    windowManagerImpl.setMaximizedMode(modeImpl);
                }
            } else {
                ModeImpl modeImpl = windowManagerImpl.getActiveMode();
                ModeImpl modeImpl2 = windowManagerImpl.getMaximizedMode();
                if (modeImpl != null && modeImpl.getKind() != 2) {
                    if (modeImpl2 != null) {
                        windowManagerImpl.setMaximizedMode(null);
                    } else {
                        windowManagerImpl.setMaximizedMode(modeImpl);
                    }
                }
            }
        } else {
            ModeImpl modeImpl = this.topComponent != null ? (ModeImpl)windowManagerImpl.findMode(this.topComponent) : windowManagerImpl.getActiveMode();
            if (modeImpl != null) {
                if (modeImpl.getKind() == 1) {
                    if (windowManagerImpl.getEditorAreaFrameState() == 0) {
                        windowManagerImpl.setEditorAreaFrameState(6);
                    } else {
                        windowManagerImpl.setEditorAreaFrameState(0);
                    }
                } else if (modeImpl.getKind() == 0) {
                    if (modeImpl.getFrameState() == 0) {
                        modeImpl.setFrameState(6);
                    } else {
                        modeImpl.setFrameState(0);
                    }
                }
            }
        }
        this.updateState();
    }

    private void updateState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MaximizeWindowAction.this.doUpdateState();
                }
            });
        }
    }

    private void doUpdateState() {
        boolean bl;
        TopComponent topComponent = null;
        topComponent = this.topComponent != null ? this.topComponent : TopComponent.getRegistry().getActivated();
        String string = topComponent == null ? "" : topComponent.getName();
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (WindowManagerImpl.getInstance().getEditorAreaState() == 0) {
            bl = WindowManagerImpl.getInstance().getMaximizedMode() == null;
        } else if (modeImpl != null) {
            bl = modeImpl.getKind() == 1 ? WindowManagerImpl.getInstance().getEditorAreaFrameState() == 0 : modeImpl.getFrameState() == 0;
        } else {
            return;
        }
        String string2 = bl ? NbBundle.getMessage((Class)MaximizeWindowAction.class, (String)"CTL_MaximizeWindowAction", (Object)string) : NbBundle.getMessage((Class)MaximizeWindowAction.class, (String)"CTL_UnmaximizeWindowAction", (Object)string);
        this.putValue("Name", this.isPopup ? Actions.cutAmpersand((String)string2) : string2);
        if (modeImpl != null && modeImpl.getKind() == 2) {
            bl = false;
        }
        this.setEnabled(modeImpl != null && modeImpl.getKind() != 2);
    }

    private static ModeImpl getModeToMaximize(TopComponent topComponent) {
        ModeImpl modeImpl;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl2 = (ModeImpl)windowManagerImpl.findMode(topComponent);
        if (modeImpl2 == (modeImpl = windowManagerImpl.getMaximizedMode())) {
            return null;
        }
        return modeImpl2;
    }

    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MaximizeWindow", object);
        } else {
            super.putValue(string, object);
        }
    }

    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MaximizeWindow");
        }
        return super.getValue(string);
    }
}

