/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloneDocumentAction
extends AbstractAction
implements PropertyChangeListener {
    public CloneDocumentAction() {
        this.putValue("Name", NbBundle.getMessage((Class)CloneDocumentAction.class, (String)"CTL_CloneDocumentAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null || !(topComponent instanceof TopComponent.Cloneable)) {
            return;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        if (modeImpl == null) {
            return;
        }
        if (modeImpl.getKind() == 1) {
            ActionUtils.cloneWindow(topComponent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
        this.setEnabled(topComponent instanceof TopComponent.Cloneable && modeImpl != null && modeImpl.getKind() == 1);
    }
}

