/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class RecentViewList
implements PropertyChangeListener {
    private static RecentViewList instance;
    private List tcWeakList = new ArrayList(20);

    public RecentViewList(WindowManager windowManager) {
        windowManager.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public TopComponent[] getTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(this.tcWeakList.size());
        this.clean();
        for (int i = 0; i < this.tcWeakList.size(); ++i) {
            WeakReference weakReference = (WeakReference)this.tcWeakList.get(i);
            TopComponent topComponent = (TopComponent)weakReference.get();
            if (topComponent == null || !topComponent.isOpened()) continue;
            arrayList.add(topComponent);
        }
        return arrayList.toArray(new TopComponent[arrayList.size()]);
    }

    public void setTopComponents(TopComponent[] topComponentArray) {
        this.tcWeakList.clear();
        for (int i = 0; i < topComponentArray.length; ++i) {
            WeakReference<TopComponent> weakReference = new WeakReference<TopComponent>(topComponentArray[i]);
            this.tcWeakList.add(weakReference);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        if ("activated".equals(propertyChangeEvent.getPropertyName()) && (topComponent = (TopComponent)propertyChangeEvent.getNewValue()) != null) {
            this.clean();
            WeakReference weakReference = this.find(topComponent);
            if (weakReference != null) {
                this.tcWeakList.remove(weakReference);
                this.tcWeakList.add(0, weakReference);
            } else {
                WeakReference<TopComponent> weakReference2 = new WeakReference<TopComponent>(topComponent);
                this.tcWeakList.add(0, weakReference2);
            }
            this.fillList(TopComponent.getRegistry().getOpened());
        }
    }

    private void clean() {
        int n = 0;
        while (n < this.tcWeakList.size()) {
            WeakReference weakReference = (WeakReference)this.tcWeakList.get(n);
            TopComponent topComponent = (TopComponent)weakReference.get();
            if (topComponent == null) {
                this.tcWeakList.remove(weakReference);
                continue;
            }
            ++n;
        }
    }

    private WeakReference find(TopComponent topComponent) {
        for (int i = 0; i < this.tcWeakList.size(); ++i) {
            WeakReference weakReference = (WeakReference)this.tcWeakList.get(i);
            TopComponent topComponent2 = (TopComponent)weakReference.get();
            if (topComponent != topComponent2) continue;
            return weakReference;
        }
        return null;
    }

    private void fillList(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            WeakReference<TopComponent> weakReference;
            TopComponent topComponent = (TopComponent)iterator.next();
            if (this.find(topComponent) != null) continue;
            if (this.tcWeakList.size() > 1) {
                weakReference = new WeakReference<TopComponent>(topComponent);
                this.tcWeakList.add(1, weakReference);
                continue;
            }
            weakReference = new WeakReference<TopComponent>(topComponent);
            this.tcWeakList.add(weakReference);
        }
    }
}

