/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class WizardDescriptor
extends DialogDescriptor {
    public static final Object NEXT_OPTION;
    public static final Object FINISH_OPTION;
    public static final Object PREVIOUS_OPTION;
    private static final ActionListener CLOSE_PREVENTER;
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_BACK_COLOR = "WizardPanel_contentBackColor";
    private static final String PROP_CONTENT_FOREGROUND_COLOR = "WizardPanel_contentForegroundColor";
    private static final String PROP_IMAGE = "WizardPanel_image";
    private static final String PROP_IMAGE_ALIGNMENT = "WizardPanel_imageAlignment";
    private static final String PROP_LEFT_DIMENSION = "WizardPanel_leftDimension";
    private static final String PROP_HELP_URL = "WizardPanel_helpURL";
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static WeakReference defaultImage;
    private static ErrorManager err;
    private final JButton nextButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton previousButton = new JButton();
    private FinishAction finishOption;
    private Set newObjects = Collections.EMPTY_SET;
    private transient Component waitingComponent;
    private boolean autoWizardStyle = false;
    private boolean init = false;
    private WizardPanel wizardPanel;
    private Image image;
    private String[] contentData = new String[0];
    private int contentSelectedIndex = -1;
    private Color contentBackColor;
    private Color contentForegroundColor;
    private URL helpURL;
    private PropL propListener;
    private String imageAlignment = "North";
    private Iterator panels;
    private ChangeListener weakChangeListener;
    private PropertyChangeListener weakPropertyChangeListener;
    private ActionListener weakNextButtonListener;
    private ActionListener weakPreviousButtonListener;
    private ActionListener weakFinishButtonListener;
    private ActionListener weakCancelButtonListener;
    private Listener baseListener;
    private Panel current;
    private Object settings;
    private MessageFormat titleFormat;
    private Map properties;
    ResourceBundle bundle = NbBundle.getBundle((Class)WizardDescriptor.class);
    static final RequestProcessor ASYNCHRONOUS_JOBS_RP;
    private RequestProcessor.Task backgroundValidationTask;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WizardDescriptor(Panel[] panelArray, Object object) {
        this(new ArrayIterator(panelArray), object);
    }

    public WizardDescriptor(Panel[] panelArray) {
        this(panelArray, (Object)CLOSE_PREVENTER);
    }

    public WizardDescriptor(Iterator iterator, Object object) {
        super((Object)"", "", true, -1, null, CLOSE_PREVENTER);
        ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.openide.Bundle");
        this.nextButton.setText(resourceBundle.getString("CTL_NEXT"));
        this.previousButton.setText(resourceBundle.getString("CTL_PREVIOUS"));
        this.finishButton.setText(resourceBundle.getString("CTL_FINISH"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_FINISH"));
        this.cancelButton.setText(resourceBundle.getString("CTL_CANCEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CANCEL"));
        this.previousButton.setMnemonic(resourceBundle.getString("CTL_PREVIOUS_Mnemonic").charAt(0));
        this.finishButton.setMnemonic(resourceBundle.getString("CTL_FINISH_Mnemonic").charAt(0));
        this.finishButton.setDefaultCapable(true);
        this.nextButton.setDefaultCapable(true);
        this.previousButton.setDefaultCapable(false);
        this.cancelButton.setDefaultCapable(false);
        this.settings = object == CLOSE_PREVENTER ? this : object;
        this.baseListener = new Listener();
        try {
            this.weakNextButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.nextButton);
            this.weakPreviousButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.previousButton);
            this.weakFinishButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.finishButton);
            this.weakCancelButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.cancelButton);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.nextButton.addActionListener(this.weakNextButtonListener);
        this.previousButton.addActionListener(this.weakPreviousButtonListener);
        this.finishButton.addActionListener(this.weakFinishButtonListener);
        this.cancelButton.addActionListener(this.weakCancelButtonListener);
        this.finishOption = new FinishAction();
        super.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        super.setClosingOptions(new Object[]{this.finishOption, this.cancelButton});
        this.panels = iterator;
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, (Object)iterator);
        iterator.addChangeListener(this.weakChangeListener);
        this.callInitialize();
    }

    public WizardDescriptor(Iterator iterator) {
        this(iterator, (Object)CLOSE_PREVENTER);
    }

    protected void initialize() {
        super.initialize();
        this.updateState();
    }

    public final synchronized void setPanels(Iterator iterator) {
        if (iterator != null) {
            iterator.removeChangeListener(this.weakChangeListener);
        }
        this.panels = iterator;
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, (Object)iterator);
        iterator.addChangeListener(this.weakChangeListener);
        this.init = false;
        this.updateState();
    }

    public void setOptions(Object[] objectArray) {
        super.setOptions(this.convertOptions(objectArray));
    }

    public void setAdditionalOptions(Object[] objectArray) {
        super.setAdditionalOptions(this.convertOptions(objectArray));
    }

    public void setClosingOptions(Object[] objectArray) {
        super.setClosingOptions(this.convertOptions(objectArray));
    }

    private Object[] convertOptions(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        for (int i = objectArray2.length - 1; i >= 0; --i) {
            if (objectArray2[i] == NEXT_OPTION) {
                objectArray2[i] = this.nextButton;
            }
            if (objectArray2[i] == PREVIOUS_OPTION) {
                objectArray2[i] = this.previousButton;
            }
            if (objectArray2[i] == FINISH_OPTION) {
                objectArray2[i] = this.finishButton;
            }
            if (objectArray2[i] != CANCEL_OPTION) continue;
            objectArray2[i] = this.cancelButton;
        }
        return objectArray2;
    }

    public Object getValue() {
        return this.backConvertOption(super.getValue());
    }

    private Object backConvertOption(Object object) {
        if (object == this.nextButton) {
            return NEXT_OPTION;
        }
        if (object == this.previousButton) {
            return PREVIOUS_OPTION;
        }
        if (object == this.finishButton) {
            return FINISH_OPTION;
        }
        if (object == this.cancelButton) {
            return CANCEL_OPTION;
        }
        return object;
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormat = messageFormat;
        if (this.init) {
            this.updateState();
        }
    }

    public synchronized MessageFormat getTitleFormat() {
        if (this.titleFormat == null) {
            this.titleFormat = new MessageFormat(NbBundle.getMessage((Class)WizardDescriptor.class, (String)"CTL_WizardName"));
        }
        return this.titleFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(final String string, final Object object) {
        Object var3_3 = null;
        WizardDescriptor wizardDescriptor = this;
        synchronized (wizardDescriptor) {
            if (this.properties == null) {
                this.properties = new HashMap(7);
            }
            var3_3 = this.properties.get(string);
            this.properties.put(string, object);
        }
        this.firePropertyChange(string, var3_3, object);
        if (this.propListener != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    WizardDescriptor.this.propListener.propertyChange(new PropertyChangeEvent(this, string, null, null));
                }
            });
        }
        if (PROP_ERROR_MESSAGE.equals(string) && this.wizardPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardDescriptor.this.wizardPanel.setErrorMessage((String)(object == null ? " " : object), WizardDescriptor.this.nextButton.isEnabled() || WizardDescriptor.this.finishButton.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }

    public synchronized Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public void setHelpCtx(HelpCtx helpCtx) {
        if (this.wizardPanel != null && helpCtx != null) {
            HelpCtx.setHelpIDString((JComponent)this.wizardPanel, (String)helpCtx.getHelpID());
        }
        super.setHelpCtx(helpCtx);
    }

    public Set getInstantiatedObjects() {
        if (!FINISH_OPTION.equals(this.getValue())) {
            throw new IllegalStateException();
        }
        return this.newObjects;
    }

    protected synchronized void updateState() {
        Object object;
        Panel panel = this.panels.current();
        if (this.current != panel) {
            if (this.current != null) {
                this.current.removeChangeListener(this.weakChangeListener);
                this.current.storeSettings(this.settings);
            }
            panel = this.panels.current();
            this.panels.removeChangeListener(this.weakChangeListener);
            this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, (Object)panel);
            this.panels.addChangeListener(this.weakChangeListener);
            panel.addChangeListener(this.weakChangeListener);
            this.current = panel;
            this.current.readSettings(this.settings);
        }
        boolean bl = this.panels.hasNext();
        boolean bl2 = this.panels.hasPrevious();
        boolean bl3 = panel.isValid();
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateStateInAWT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardDescriptor.this.updateStateInAWT();
                }
            });
        }
        this.setHelpCtx(panel.getHelp());
        Component component = panel.getComponent();
        if (component == null || component instanceof Window) {
            throw new IllegalStateException("Wizard panel " + panel + " gave a strange component " + component);
        }
        if (!this.init) {
            if (component instanceof JComponent) {
                this.autoWizardStyle = this.getBooleanProperty((JComponent)component, PROP_AUTO_WIZARD_STYLE);
                if (this.autoWizardStyle) {
                    this.wizardPanel = new WizardPanel(this.getBooleanProperty((JComponent)component, PROP_CONTENT_DISPLAYED), this.getBooleanProperty((JComponent)component, PROP_HELP_DISPLAYED), this.getBooleanProperty((JComponent)component, PROP_CONTENT_NUMBERED), this.getLeftDimension((JComponent)component));
                    this.initBundleProperties();
                }
            }
            if (this.propListener == null) {
                this.propListener = new PropL();
            }
            this.init = true;
        }
        if (this.wizardPanel != null) {
            object = this.wizardPanel.getRightComponent();
            if (object != null) {
                ((Component)object).removePropertyChangeListener(this.weakPropertyChangeListener);
            }
            if (component instanceof JComponent) {
                this.setPanelProperties((JComponent)component);
                this.wizardPanel.setContent(this.contentData);
                this.wizardPanel.setSelectedIndex(this.contentSelectedIndex);
                this.wizardPanel.setContentBackColor(this.contentBackColor);
                this.wizardPanel.setContentForegroundColor(this.contentForegroundColor);
                this.wizardPanel.setImage(this.image);
                this.wizardPanel.setImageAlignment(this.imageAlignment);
                this.wizardPanel.setHelpURL(this.helpURL);
                this.updateButtonAccessibleDescription();
                this.weakPropertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)component);
                component.addPropertyChangeListener(this.weakPropertyChangeListener);
            }
            if (this.wizardPanel.getRightComponent() != component) {
                this.wizardPanel.setRightComponent(component);
                if (this.wizardPanel != this.getMessage()) {
                    this.setMessage(this.wizardPanel);
                } else {
                    this.firePropertyChange("message", null, this.wizardPanel);
                }
            }
        } else if (component != this.getMessage()) {
            this.setMessage(component);
        }
        object = component.getName();
        if (object == null) {
            object = "";
        }
        Object[] objectArray = new Object[]{object, this.panels.name()};
        MessageFormat messageFormat = this.getTitleFormat();
        if (this.autoWizardStyle) {
            this.wizardPanel.setPanelName(messageFormat.format(objectArray));
        } else {
            this.setTitle(messageFormat.format(objectArray));
        }
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != null && !component2.isEnabled() && this.wizardPanel != null) {
            this.wizardPanel.requestFocus();
        }
    }

    private void updateStateInAWT() {
        Panel panel = this.panels.current();
        boolean bl = this.panels.hasNext();
        boolean bl2 = this.panels.hasPrevious();
        boolean bl3 = panel.isValid();
        this.nextButton.setEnabled(bl && bl3);
        this.previousButton.setEnabled(bl2);
        if (this.current instanceof FinishablePanel) {
            if (((FinishablePanel)this.current).isFinishPanel()) {
                this.finishButton.setEnabled(bl3);
            } else {
                this.finishButton.setEnabled(bl3 && !bl);
            }
        } else {
            this.finishButton.setEnabled(bl3 && (!bl || this.current instanceof FinishPanel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateWithFeedback() {
        try {
            this.showWaitCursor();
            this.updateState();
        }
        finally {
            this.showNormalCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToNextStep(Dimension dimension) {
        try {
            Window window;
            this.showWaitCursor();
            boolean bl = false;
            Font font = (Font)UIManager.getDefaults().get("controlFont");
            Integer n = (Integer)UIManager.get("nbDefaultFontSize");
            if (n == null) {
                n = new Integer(11);
            }
            if (font != null && font.getSize() > n && (window = SwingUtilities.getWindowAncestor((Component)this.getMessage())) != null) {
                this.updateState();
                bl = true;
                this.resizeWizard(window, dimension);
            }
            if (!bl) {
                this.updateState();
            }
            if (this.wizardPanel != null) {
                this.wizardPanel.requestFocus();
            }
        }
        finally {
            this.showNormalCursor();
        }
    }

    private void resizeWizard(Window window, Dimension dimension) {
        Dimension dimension2 = this.panels.current().getComponent().getPreferredSize();
        if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
            Rectangle rectangle;
            Rectangle rectangle2 = window.getBounds();
            int n = Math.max(rectangle2.width + (dimension2.width - dimension.width), rectangle2.width);
            int n2 = Math.max(rectangle2.height + (dimension2.height - dimension.height), rectangle2.height);
            Rectangle rectangle3 = Utilities.getUsableScreenBounds();
            if (rectangle2.x + n > rectangle3.width || rectangle2.y + n2 > rectangle3.height) {
                n = Math.min(rectangle3.width, n);
                n2 = Math.min(rectangle3.height, n2);
                rectangle = Utilities.findCenterBounds((Dimension)new Dimension(n, n2));
            } else {
                rectangle = new Rectangle(rectangle2.x, rectangle2.y, n, n2);
            }
            window.setBounds(rectangle);
            window.invalidate();
            window.validate();
            window.repaint();
        }
    }

    private void showWaitCursor() {
        if (this.wizardPanel == null || this.wizardPanel.getRootPane() == null) {
            return;
        }
        this.waitingComponent = this.wizardPanel.getRootPane().getContentPane();
        this.waitingComponent.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void showNormalCursor() {
        if (this.waitingComponent == null) {
            return;
        }
        this.waitingComponent.setCursor(null);
        this.waitingComponent = null;
    }

    private boolean getBooleanProperty(JComponent jComponent, String string) {
        Object object = this.getProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        object = jComponent.getClientProperty(string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private Dimension getLeftDimension(JComponent jComponent) {
        Object object = jComponent.getClientProperty(PROP_LEFT_DIMENSION);
        Dimension dimension = object instanceof Dimension ? (Dimension)object : new Dimension(198, 233);
        return dimension;
    }

    private void setPanelProperties(JComponent jComponent) {
        Object object = this.getProperty(PROP_CONTENT_SELECTED_INDEX);
        if (object instanceof Integer) {
            this.contentSelectedIndex = (Integer)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
            if (object instanceof Integer) {
                this.contentSelectedIndex = (Integer)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_DATA);
        if (object instanceof String[]) {
            this.contentData = (String[])object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_DATA);
            if (object instanceof String[]) {
                this.contentData = (String[])object;
            }
        }
        object = this.getProperty(PROP_IMAGE);
        if (object instanceof Image) {
            this.image = (Image)object;
        } else if ((this.properties == null || !this.properties.containsKey(PROP_IMAGE)) && (object = jComponent.getClientProperty(PROP_IMAGE)) instanceof Image) {
            this.image = (Image)object;
        }
        object = this.getProperty(PROP_IMAGE_ALIGNMENT);
        if (object instanceof String) {
            this.imageAlignment = (String)object;
        } else {
            object = jComponent.getClientProperty(PROP_IMAGE_ALIGNMENT);
            if (object instanceof String) {
                this.imageAlignment = (String)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_BACK_COLOR);
        if (object instanceof Color) {
            this.contentBackColor = (Color)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_BACK_COLOR);
            if (object instanceof Color) {
                this.contentBackColor = (Color)object;
            }
        }
        object = this.getProperty(PROP_CONTENT_FOREGROUND_COLOR);
        if (object instanceof Color) {
            this.contentForegroundColor = (Color)object;
        } else {
            object = jComponent.getClientProperty(PROP_CONTENT_FOREGROUND_COLOR);
            if (object instanceof Color) {
                this.contentForegroundColor = (Color)object;
            }
        }
        object = jComponent.getClientProperty(PROP_HELP_URL);
        if (object instanceof URL) {
            this.helpURL = (URL)object;
        } else if (object == null) {
            this.helpURL = null;
        }
    }

    private void initBundleProperties() {
        this.contentBackColor = new Color(this.getIntFromBundle("INT_WizardBackRed"), this.getIntFromBundle("INT_WizardBackGreen"), this.getIntFromBundle("INT_WizardBackBlue"));
        this.contentForegroundColor = new Color(this.getIntFromBundle("INT_WizardForegroundRed"), this.getIntFromBundle("INT_WizardForegroundGreen"), this.getIntFromBundle("INT_WizardForegroundBlue"));
        this.imageAlignment = this.bundle.getString("STRING_WizardImageAlignment");
    }

    public void setValue(Object object) {
        Object object2 = this.backConvertOption(object);
        Object object3 = this.getValue();
        this.setValueWithoutPCH(object2);
        if (CLOSED_OPTION.equals(object2)) {
            this.resetWizard();
        } else if ((FINISH_OPTION.equals(object2) || NEXT_OPTION.equals(object2)) && this.current != null) {
            this.current.storeSettings(this.settings);
        }
        this.firePropertyChange("value", object3, object2);
    }

    private void resetWizard() {
        if (this.current != null) {
            this.current.storeSettings(this.settings);
            this.current.removeChangeListener(this.weakChangeListener);
            this.current = null;
            if (this.wizardPanel != null) {
                this.wizardPanel.resetPreferredSize();
            }
        }
        this.callUninitialize();
        this.panels.removeChangeListener(this.weakChangeListener);
    }

    private int getIntFromBundle(String string) {
        return Integer.parseInt(this.bundle.getString(string));
    }

    private static Image getDefaultImage() {
        Image image = null;
        if (defaultImage != null) {
            image = (Image)defaultImage.get();
        }
        if (image == null) {
            URL uRL = NbBundle.getLocalizedFile((String)"org.openide.resources.defaultWizard", (String)"gif");
            Image image2 = image = uRL == null ? null : Toolkit.getDefaultToolkit().getImage(uRL);
            if (image != null) {
                defaultImage = new WeakReference<Image>(image);
            }
        }
        return image;
    }

    private void updateButtonAccessibleDescription() {
        String string = this.contentData != null && this.contentSelectedIndex > 0 && this.contentSelectedIndex - 1 < this.contentData.length ? this.contentData[this.contentSelectedIndex - 1] : "";
        this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WizardDescriptor.class, (String)"ACSD_PREVIOUS", (Object)new Integer(this.contentSelectedIndex), (Object)string));
        string = this.contentData != null && this.contentSelectedIndex < this.contentData.length - 1 && this.contentSelectedIndex + 1 >= 0 ? this.contentData[this.contentSelectedIndex + 1] : "";
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WizardDescriptor.class, (String)"ACSD_NEXT", (Object)new Integer(this.contentSelectedIndex + 2), (Object)string));
    }

    private void lazyValidate(final Panel panel, final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            public void run() {
                block5: {
                    err.log(1, "validationPeformer entry.");
                    ValidatingPanel validatingPanel = (ValidatingPanel)panel;
                    try {
                        validatingPanel.validate();
                        if (SwingUtilities.isEventDispatchThread()) {
                            WizardDescriptor.this.setValid(true);
                            err.log(1, "Runs onValidPerformer directly in EDT.");
                            runnable.run();
                        } else {
                            err.log(1, "invokeLater onValidPerformer.");
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    WizardDescriptor.this.setValid(true);
                                    err.log(1, "Runs onValidPerformer from invokeLater.");
                                    runnable.run();
                                }
                            });
                        }
                    }
                    catch (WizardValidationException wizardValidationException) {
                        JComponent jComponent;
                        if (WizardDescriptor.this.wizardPanel != null) {
                            WizardDescriptor.this.wizardPanel.setErrorMessage(wizardValidationException.getLocalizedMessage(), Boolean.FALSE);
                        }
                        if (wizardValidationException.getSource() == null || !(jComponent = wizardValidationException.getSource()).isFocusable()) break block5;
                        jComponent.requestFocus();
                    }
                }
            }
        };
        if (panel instanceof AsynchronousValidatingPanel) {
            AsynchronousValidatingPanel asynchronousValidatingPanel = (AsynchronousValidatingPanel)panel;
            this.setValid(false);
            asynchronousValidatingPanel.prepareValidation();
            err.log(1, "Do ASYNCHRONOUS_JOBS_RP.post(validationPeformer).");
            this.backgroundValidationTask = ASYNCHRONOUS_JOBS_RP.post(runnable2);
        } else if (panel instanceof ValidatingPanel) {
            err.log(1, "Runs validationPeformer.");
            runnable2.run();
        } else {
            err.log(1, "Runs onValidPerformer.");
            runnable.run();
        }
    }

    private void callInitialize() {
        if (!$assertionsDisabled && this.panels == null) {
            throw new AssertionError();
        }
        if (this.panels instanceof InstantiatingIterator) {
            ((InstantiatingIterator)this.panels).initialize(this);
        }
        this.newObjects = Collections.EMPTY_SET;
    }

    private void callUninitialize() {
        if (!$assertionsDisabled && this.panels == null) {
            throw new AssertionError();
        }
        if (this.panels instanceof InstantiatingIterator) {
            ((InstantiatingIterator)this.panels).uninitialize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callInstantiate() throws IOException {
        if (!$assertionsDisabled && this.panels == null) {
            throw new AssertionError();
        }
        this.panels.current().storeSettings(this.settings);
        if (this.panels instanceof InstantiatingIterator) {
            this.showWaitCursor();
            try {
                if (!$assertionsDisabled && this.panels instanceof AsynchronousInstantiatingIterator && SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError((Object)"Cannot invoked within EDT if AsynchronousInstantiatingIterator!");
                }
                err.log(1, "Calls instantiate() on iterator: " + this.panels.getClass().getName());
                this.newObjects = ((InstantiatingIterator)this.panels).instantiate();
            }
            finally {
                this.showNormalCursor();
            }
        }
    }

    private static Font doDeriveFont(Font font, int n) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new Font(font.getName(), n, font.getSize());
        }
        return font.deriveFont(n);
    }

    final void doNextClick() {
        if (this.nextButton.isEnabled()) {
            this.nextButton.doClick();
        }
    }

    final void doPreviousClick() {
        if (this.previousButton.isEnabled()) {
            this.previousButton.doClick();
        }
    }

    final void doFinishClick() {
        if (this.finishButton.isEnabled()) {
            this.finishButton.doClick();
        }
    }

    final void doCancelClick() {
        if (this.cancelButton.isEnabled()) {
            this.cancelButton.doClick();
        }
    }

    final boolean isNextEnabled() {
        return this.nextButton.isEnabled();
    }

    final boolean isFinishEnabled() {
        return this.finishButton.isEnabled();
    }

    static {
        $assertionsDisabled = !WizardDescriptor.class.desiredAssertionStatus();
        NEXT_OPTION = new String("NEXT_OPTION");
        FINISH_OPTION = OK_OPTION;
        PREVIOUS_OPTION = new String("PREVIOUS_OPTION");
        CLOSE_PREVENTER = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public String toString() {
                return "CLOSE_PREVENTER";
            }
        };
        err = ErrorManager.getDefault().getInstance(WizardDescriptor.class.getName());
        ASYNCHRONOUS_JOBS_RP = new RequestProcessor("wizard-descriptor-asynchronous-jobs", 1, true);
    }

    public static class ArrayIterator
    implements Iterator {
        private Panel[] panels;
        private int index;

        public ArrayIterator() {
            this.panels = this.initializePanels();
            this.index = 0;
        }

        public ArrayIterator(Panel[] panelArray) {
            this.panels = panelArray;
            this.index = 0;
        }

        protected Panel[] initializePanels() {
            return new Panel[0];
        }

        public Panel current() {
            return this.panels[this.index];
        }

        public String name() {
            return NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_ArrayIteratorName", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
        }

        public boolean hasNext() {
            return this.index < this.panels.length - 1;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public synchronized void nextPanel() {
            if (this.index + 1 == this.panels.length) {
                throw new NoSuchElementException();
            }
            ++this.index;
        }

        public synchronized void previousPanel() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        protected void reset() {
            this.index = 0;
        }
    }

    public static interface AsynchronousInstantiatingIterator
    extends InstantiatingIterator {
        public Set instantiate() throws IOException;
    }

    public static interface AsynchronousValidatingPanel
    extends ValidatingPanel {
        public void prepareValidation();

        public void validate() throws WizardValidationException;
    }

    private static class BoundedHtmlBrowser
    extends HtmlBrowser {
        Dimension dim;

        public BoundedHtmlBrowser(Dimension dimension) {
            super(false, false);
            this.dim = dimension;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }
    }

    static class FinishAction {
        ActionListener listner;

        FinishAction() {
        }

        public void addActionListener(ActionListener actionListener) {
            this.listner = actionListener;
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listner = null;
        }

        public void fireActionPerformed() {
            if (this.listner != null) {
                this.listner.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    public static interface FinishPanel
    extends Panel {
    }

    public static interface FinishablePanel
    extends Panel {
        public boolean isFinishPanel();
    }

    private static final class FixedHeightLabel
    extends JLabel {
        private static final int ESTIMATED_HEIGHT = 16;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (!$assertionsDisabled && 16 != Utilities.loadImage((String)"org/openide/resources/warning.gif").getHeight(null)) {
                throw new AssertionError((Object)"Use only 16px icon.");
            }
            dimension.height = Math.max(16, dimension.height);
            return dimension;
        }

        static {
            $assertionsDisabled = !(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor).desiredAssertionStatus();
        }
    }

    private static class ImagedPanel
    extends JComponent
    implements Accessible,
    Runnable {
        Image image;
        Image tempImage;
        Image image2Load;
        boolean isDefault = false;
        boolean loadPending = false;
        boolean north = true;
        private final Object IMAGE_LOCK = new Object();

        public ImagedPanel(Image image) {
            this.setImage(image);
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                graphics.drawImage(this.image, 0, this.north ? 0 : this.getHeight() - this.image.getHeight(null), this);
            } else if (this.image2Load != null) {
                this.loadImageInBackground(this.image2Load);
                this.image2Load = null;
            }
        }

        public void setImageAlignment(String string) {
            this.north = "North".equals(string);
        }

        public void setImage(Image image) {
            if (image != null) {
                this.loadImage(image);
                this.isDefault = false;
                return;
            }
            if (!this.isDefault) {
                this.loadImage(WizardDescriptor.getDefaultImage());
                this.isDefault = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadImage(Image image) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            if (mediaTracker.checkID(0)) {
                this.image = image;
                if (this.isShowing()) {
                    this.repaint();
                }
                return;
            }
            if (this.isShowing()) {
                this.loadImageInBackground(image);
            } else {
                Object object = this.IMAGE_LOCK;
                synchronized (object) {
                    this.image = null;
                }
                this.image2Load = image;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadImageInBackground(Image image) {
            Object object = this.IMAGE_LOCK;
            synchronized (object) {
                this.tempImage = image;
                if (this.loadPending) {
                    return;
                }
                this.loadPending = true;
            }
            RequestProcessor.getDefault().post((Runnable)this, 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Image image = null;
            Object object = this.IMAGE_LOCK;
            synchronized (object) {
                image = this.tempImage;
                this.tempImage = null;
                this.loadPending = false;
            }
            object = new ImageIcon(image);
            boolean bl = false;
            Object object2 = this.IMAGE_LOCK;
            synchronized (object2) {
                if (!this.loadPending) {
                    this.image = ((ImageIcon)object).getImage();
                    bl = true;
                }
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    public static interface InstantiatingIterator
    extends Iterator {
        public Set instantiate() throws IOException;

        public void initialize(WizardDescriptor var1);

        public void uninitialize(WizardDescriptor var1);
    }

    public static interface Iterator {
        public Panel current();

        public String name();

        public boolean hasNext();

        public boolean hasPrevious();

        public void nextPanel();

        public void previousPanel();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private final class Listener
    implements ChangeListener,
    ActionListener {
        Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            WizardDescriptor.this.updateState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (WizardDescriptor.this.wizardPanel != null) {
                WizardDescriptor.this.wizardPanel.setErrorMessage(" ", null);
            }
            err.log(1, "actionPerformed entry. Source: " + actionEvent.getSource());
            if (actionEvent.getSource() == WizardDescriptor.this.nextButton) {
                object = WizardDescriptor.this.panels.current().getComponent().getSize();
                Runnable runnable = new Runnable((Dimension)object){
                    private final /* synthetic */ Dimension val$previousSize;
                    {
                        this.val$previousSize = dimension;
                    }

                    public void run() {
                        err.log(1, "onValidPerformer on next button entry.");
                        WizardDescriptor.this.panels.nextPanel();
                        try {
                            WizardDescriptor.this.goToNextStep(this.val$previousSize);
                        }
                        catch (IllegalStateException illegalStateException) {
                            WizardDescriptor.this.panels.previousPanel();
                            if (illegalStateException.getMessage() != null) {
                                DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(illegalStateException.getMessage()));
                            } else {
                                err.notify((Throwable)illegalStateException);
                            }
                            WizardDescriptor.this.updateState();
                        }
                        err.log(1, "onValidPerformer on next button exit.");
                    }
                };
                WizardDescriptor.this.lazyValidate(WizardDescriptor.this.panels.current(), runnable);
            }
            if (actionEvent.getSource() == WizardDescriptor.this.previousButton) {
                WizardDescriptor.this.panels.previousPanel();
                WizardDescriptor.this.updateStateWithFeedback();
            }
            if (actionEvent.getSource() == WizardDescriptor.this.finishButton) {
                object = new Runnable(){

                    public void run() {
                        err.log(1, "onValidPerformer on finish button entry.");
                        WizardDescriptor.this.cancelButton.setEnabled(false);
                        WizardDescriptor.this.previousButton.setEnabled(false);
                        WizardDescriptor.this.nextButton.setEnabled(false);
                        WizardDescriptor.this.finishButton.setEnabled(false);
                        if (WizardDescriptor.this.wizardPanel != null) {
                            WizardDescriptor.this.wizardPanel.setErrorMessage(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"MSG_WizardDescriptor_FinishInProgress"), Boolean.TRUE);
                        }
                        Runnable runnable = new Runnable(){

                            public void run() {
                                err.log(1, "performFinish entry.");
                                try {
                                    WizardDescriptor.this.callInstantiate();
                                }
                                catch (IOException iOException) {
                                    err.notify(1, (Throwable)iOException);
                                    WizardDescriptor.this.setValueWithoutPCH(NEXT_OPTION);
                                    WizardDescriptor.this.updateStateWithFeedback();
                                    WizardDescriptor.this.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, iOException.getLocalizedMessage());
                                    return;
                                }
                                Object object = WizardDescriptor.this.getValue();
                                WizardDescriptor.this.setValueWithoutPCH(NotifyDescriptor.OK_OPTION);
                                WizardDescriptor.this.resetWizard();
                                WizardDescriptor.this.firePropertyChange("value", object, NotifyDescriptor.OK_OPTION);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        err.log(1, "WD.finishOption.fireActionPerformed()");
                                        WizardDescriptor.this.finishOption.fireActionPerformed();
                                        err.log(1, "Set value to OK_OPTION.");
                                        WizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
                                    }
                                });
                                err.log(1, "performFinish exit.");
                            }
                        };
                        if (WizardDescriptor.this.panels instanceof AsynchronousInstantiatingIterator) {
                            err.log(1, "Do ASYNCHRONOUS_JOBS_RP.post(performFinish).");
                            ASYNCHRONOUS_JOBS_RP.post(runnable);
                        } else {
                            err.log(1, "Run performFinish.");
                            runnable.run();
                        }
                        err.log(1, "onValidPerformer on finish button exit.");
                    }
                };
                WizardDescriptor.this.lazyValidate(WizardDescriptor.this.panels.current(), (Runnable)object);
            }
            if (actionEvent.getSource() == WizardDescriptor.this.cancelButton) {
                if (WizardDescriptor.this.backgroundValidationTask != null) {
                    WizardDescriptor.this.backgroundValidationTask.cancel();
                }
                object = WizardDescriptor.this.getValue();
                WizardDescriptor.this.setValueWithoutPCH(NotifyDescriptor.CANCEL_OPTION);
                if (Arrays.asList(WizardDescriptor.this.getClosingOptions()).contains(WizardDescriptor.this.cancelButton)) {
                    WizardDescriptor.this.resetWizard();
                }
                WizardDescriptor.this.firePropertyChange("value", object, NotifyDescriptor.CANCEL_OPTION);
            }
        }
    }

    public static interface Panel {
        public Component getComponent();

        public HelpCtx getHelp();

        public void readSettings(Object var1);

        public void storeSettings(Object var1);

        public boolean isValid();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (WizardDescriptor.this.wizardPanel == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            WizardDescriptor.this.setPanelProperties((JComponent)WizardDescriptor.this.wizardPanel.getRightComponent());
            if (string.equals(WizardDescriptor.PROP_CONTENT_DATA)) {
                WizardDescriptor.this.wizardPanel.setContent(WizardDescriptor.this.contentData);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (string.equals(WizardDescriptor.PROP_CONTENT_SELECTED_INDEX)) {
                WizardDescriptor.this.wizardPanel.setSelectedIndex(WizardDescriptor.this.contentSelectedIndex);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (string.equals(WizardDescriptor.PROP_CONTENT_BACK_COLOR)) {
                WizardDescriptor.this.wizardPanel.setContentBackColor(WizardDescriptor.this.contentBackColor);
            } else if (string.equals(WizardDescriptor.PROP_CONTENT_FOREGROUND_COLOR)) {
                WizardDescriptor.this.wizardPanel.setContentForegroundColor(WizardDescriptor.this.contentForegroundColor);
            } else if (string.equals(WizardDescriptor.PROP_IMAGE)) {
                WizardDescriptor.this.wizardPanel.setImage(WizardDescriptor.this.image);
            } else if (string.equals(WizardDescriptor.PROP_IMAGE_ALIGNMENT)) {
                WizardDescriptor.this.wizardPanel.setImageAlignment(WizardDescriptor.this.imageAlignment);
            } else if (string.equals(WizardDescriptor.PROP_HELP_URL)) {
                WizardDescriptor.this.wizardPanel.setHelpURL(WizardDescriptor.this.helpURL);
            }
        }
    }

    public static interface ValidatingPanel
    extends Panel {
        public void validate() throws WizardValidationException;
    }

    private static class WizardPanel
    extends JPanel {
        private JPanel rightPanel = new JPanel(new BorderLayout());
        private JLabel panelName = new JLabel("Step");
        private JList contentList;
        private Component rightComponent;
        private ImagedPanel contentPanel;
        private JPanel contentLabelPanel;
        private WrappedCellRenderer cellRenderer;
        private JTabbedPane tabbedPane;
        private HtmlBrowser htmlBrowser;
        private Dimension cachedDimension;
        private JLabel label;
        private int selectedIndex;
        private JLabel m_lblMessage;
        private Color nbErrorForeground;
        private Color nbWarningForeground;

        public WizardPanel(boolean bl, boolean bl2, boolean bl3, Dimension dimension) {
            super(new BorderLayout());
            this.initComponents(bl, bl2, bl3, dimension);
            this.setOpaque(false);
            this.resetPreferredSize();
        }

        private void initComponents(boolean bl, boolean bl2, boolean bl3, Dimension dimension) {
            if (bl) {
                this.createContentPanel(bl3, dimension);
                if (!bl2) {
                    this.add((Component)this.contentPanel, "West");
                }
            }
            if (bl2) {
                this.htmlBrowser = new BoundedHtmlBrowser(dimension);
                this.htmlBrowser.setPreferredSize(dimension);
                if (!bl) {
                    this.add((Component)this.htmlBrowser, "West");
                }
            }
            if (bl2 && bl) {
                this.tabbedPane = new JTabbedPane(3);
                this.tabbedPane.addTab(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_ContentName"), this.contentPanel);
                this.tabbedPane.addTab(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_HelpName"), (Component)this.htmlBrowser);
                this.tabbedPane.setEnabledAt(1, false);
                this.tabbedPane.setOpaque(false);
                this.add((Component)this.tabbedPane, "West");
            }
            this.panelName.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.panelName.getForeground()));
            this.panelName.setFont(WizardDescriptor.doDeriveFont(this.panelName.getFont(), 1));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.panelName, "North");
            jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 11));
            this.rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 11, 11));
            this.panelName.setLabelFor(jPanel);
            this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
            if (this.nbErrorForeground == null) {
                this.nbErrorForeground = new Color(255, 0, 0);
            }
            this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbWarningForeground == null) {
                this.nbWarningForeground = new Color(51, 51, 51);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 11));
            this.m_lblMessage = new FixedHeightLabel();
            this.m_lblMessage.setForeground(this.nbErrorForeground);
            jPanel2.add((Component)this.m_lblMessage, "Center");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            jPanel3.add((Component)this.rightPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
            JSeparator jSeparator = new JSeparator();
            jSeparator.setForeground(Color.darkGray);
            this.add((Component)jPanel3, "Center");
            this.add((Component)jSeparator, "South");
        }

        public void setErrorMessage(String string, Boolean bl) {
            this.m_lblMessage.setForeground(this.nbErrorForeground);
            if (string != null && string.trim().length() > 0 && bl != null) {
                if (bl.booleanValue()) {
                    this.m_lblMessage.setIcon(new ImageIcon(Utilities.loadImage((String)"org/openide/resources/warning.gif")));
                    this.m_lblMessage.setForeground(this.nbWarningForeground);
                } else {
                    this.m_lblMessage.setIcon(new ImageIcon(Utilities.loadImage((String)"org/openide/resources/error.gif")));
                }
                this.m_lblMessage.setToolTipText(string);
            } else {
                this.m_lblMessage.setIcon(null);
                this.m_lblMessage.setToolTipText(null);
            }
            this.m_lblMessage.setText(string);
        }

        private void createContentPanel(boolean bl, Dimension dimension) {
            this.contentList = new JList();
            this.cellRenderer = new WrappedCellRenderer(bl, dimension.width);
            this.cellRenderer.setOpaque(false);
            this.contentList.setCellRenderer(this.cellRenderer);
            this.contentList.setOpaque(false);
            this.contentList.setEnabled(false);
            this.contentList.getAccessibleContext().setAccessibleDescription("");
            JScrollPane jScrollPane = new JScrollPane(this.contentList);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getViewport().setOpaque(false);
            jScrollPane.setBorder(null);
            jScrollPane.setOpaque(false);
            this.label = new JLabel(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_ContentName"));
            this.label.setForeground(Color.white);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
            this.label.setFont(WizardDescriptor.doDeriveFont(this.label.getFont(), 1));
            this.contentLabelPanel = new JPanel(new BorderLayout());
            this.contentLabelPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
            this.contentLabelPanel.setOpaque(false);
            this.contentLabelPanel.add((Component)this.label, "North");
            this.contentPanel = new ImagedPanel(null);
            this.contentPanel.add((Component)this.contentLabelPanel, "North");
            this.contentPanel.add((Component)jScrollPane, "Center");
            this.contentPanel.setPreferredSize(dimension);
            this.label.setLabelFor(this.contentList);
        }

        public void setContent(final String[] stringArray) {
            final JList jList = this.contentList;
            if (jList == null) {
                return;
            }
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    jList.setListData(stringArray);
                    jList.revalidate();
                    jList.repaint();
                    WizardPanel.this.contentLabelPanel.setVisible(stringArray.length > 0);
                }
            });
        }

        public void setSelectedIndex(final int n) {
            this.selectedIndex = n;
            if (this.cellRenderer != null) {
                this.cellRenderer.setSelectedIndex(n);
                final JList jList = this.contentList;
                if (jList == null) {
                    return;
                }
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        jList.ensureIndexIsVisible(n);
                        jList.setFixedCellWidth(0);
                        jList.setFixedCellWidth(-1);
                    }
                });
            }
        }

        public void setContentBackColor(Color color) {
            if (this.contentPanel != null) {
                this.contentPanel.setBackground(color);
            }
        }

        public void setContentForegroundColor(Color color) {
            if (this.cellRenderer == null) {
                return;
            }
            this.cellRenderer.setForegroundColor(color);
            this.label.setForeground(color);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
        }

        public void setImage(Image image) {
            if (this.contentPanel != null) {
                this.contentPanel.setImage(image);
            }
        }

        public void setImageAlignment(String string) {
            if (this.contentPanel != null) {
                this.contentPanel.setImageAlignment(string);
            }
        }

        public void setRightComponent(Component component) {
            if (this.rightComponent != null) {
                this.rightPanel.remove(this.rightComponent);
            }
            this.rightComponent = component;
            this.rightPanel.add(this.rightComponent, "Center");
        }

        public Component getRightComponent() {
            return this.rightComponent;
        }

        public void setPanelName(String string) {
            this.panelName.setText(string);
        }

        public void setHelpURL(URL uRL) {
            if (this.htmlBrowser == null) {
                return;
            }
            if (uRL != null) {
                if (!uRL.equals(this.htmlBrowser.getDocumentURL())) {
                    this.htmlBrowser.setURL(uRL);
                }
                if (this.tabbedPane != null) {
                    this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent((Component)this.htmlBrowser), true);
                }
            } else if (this.tabbedPane != null) {
                this.tabbedPane.setSelectedComponent(this.contentPanel);
                this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent((Component)this.htmlBrowser), false);
            }
        }

        public void resetPreferredSize() {
            this.cachedDimension = new Dimension(600, 365);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.height > this.cachedDimension.height) {
                this.cachedDimension.height = dimension.height;
            }
            if (dimension.width > this.cachedDimension.width) {
                this.cachedDimension.width = dimension.width;
            }
            return this.cachedDimension;
        }

        public void requestFocus() {
            if (this.rightComponent != null && this.rightComponent.isDisplayable()) {
                JComponent jComponent = (JComponent)this.rightComponent;
                Container container = jComponent.getFocusCycleRootAncestor();
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(jComponent.getFocusCycleRootAncestor(), jComponent);
                if (component != null) {
                    component.requestFocus();
                } else {
                    jComponent.requestFocus();
                }
            } else {
                super.requestFocus();
            }
        }

        public boolean requestDefaultFocus() {
            if (this.rightComponent instanceof JComponent) {
                return ((JComponent)this.rightComponent).requestDefaultFocus();
            }
            return super.requestDefaultFocus();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWizardPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleWizardPanel
        extends JPanel.AccessibleJPanel {
            AccessibleWizardPanel() {
                super(WizardPanel.this);
            }

            public String getAccessibleDescription() {
                if (this.accessibleDescription != null) {
                    return this.accessibleDescription;
                }
                if (WizardPanel.this.rightComponent instanceof Accessible) {
                    if (WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription() == null) {
                        return null;
                    }
                    return NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"ACSD_WizardPanel", (Object)new Integer(WizardPanel.this.selectedIndex + 1), (Object)WizardPanel.this.panelName.getText(), (Object)WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription());
                }
                return super.getAccessibleDescription();
            }
        }
    }

    private static class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextArea ta = new JTextArea();
        JLabel numberLabel;
        int selected = -1;
        boolean contentNumbered;
        int taWidth;

        private WrappedCellRenderer(boolean bl, int n) {
            super(new BorderLayout());
            this.contentNumbered = bl;
            this.ta.setOpaque(false);
            this.ta.setEditable(false);
            this.ta.setLineWrap(true);
            this.ta.setWrapStyleWord(true);
            this.ta.setFont(UIManager.getFont("Label.font"));
            this.ta.getAccessibleContext().setAccessibleDescription("");
            this.taWidth = n - 12 - 12;
            this.numberLabel = new JLabel(){

                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (!WrappedCellRenderer.this.contentNumbered) {
                        Rectangle rectangle = graphics.getClipBounds();
                        graphics.fillOval(rectangle.x, rectangle.y, 7, 7);
                    }
                }
            };
            this.numberLabel.setLabelFor(this.ta);
            this.numberLabel.setHorizontalAlignment(2);
            this.numberLabel.setVerticalAlignment(1);
            this.numberLabel.setFont(this.ta.getFont());
            this.numberLabel.setOpaque(false);
            this.numberLabel.setPreferredSize(new Dimension(25, 0));
            this.add((Component)this.numberLabel, "West");
            this.taWidth -= 25;
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.add((Component)this.ta, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == this.selected) {
                this.numberLabel.setFont(WizardDescriptor.doDeriveFont(this.numberLabel.getFont(), 1));
                this.ta.setFont(WizardDescriptor.doDeriveFont(this.ta.getFont(), 1));
            } else {
                this.numberLabel.setFont(WizardDescriptor.doDeriveFont(this.numberLabel.getFont(), 0));
                this.ta.setFont(WizardDescriptor.doDeriveFont(this.ta.getFont(), 0));
            }
            if (this.contentNumbered) {
                this.numberLabel.setText(Integer.toString(n + 1) + ".");
            }
            Insets insets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, insets.top + insets.bottom + 1);
            this.ta.setText((String)object);
            return this;
        }

        private void setSelectedIndex(int n) {
            this.selected = n;
        }

        private void setForegroundColor(Color color) {
            if (this.numberLabel != null) {
                this.numberLabel.setForeground(color);
                this.numberLabel.setBackground(color);
            }
            this.ta.setForeground(color);
        }
    }
}

