/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.datafile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.prefs.datafile.DataOptionsPanelController;
import tr.prefs.datafile.DataPrefs;
import tr.prefs.datafile.Resources;

final class DataPrefsPanel
extends JPanel {
    private final DataOptionsPanelController controller;
    private JButton folderButton;
    private JLabel folderLabel;
    private JTextField folderTextField;

    DataPrefsPanel(DataOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.folderButton = new JButton();
        this.folderTextField = new JTextField();
        this.folderTextField.getDocument().addDocumentListener(new FolderDocumentListener());
        this.folderLabel = new JLabel();
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.folderButton.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)Resources.getText("CTL_Browse"));
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPrefsPanel.this.folderButtonbrowse(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)Resources.getText("CTL_Folder"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.folderLabel, -2, 135, -2).add(1, 1, 1).add((Component)this.folderTextField, -1, 241, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.folderButton)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.folderButton).add((Component)this.folderLabel).add((Component)this.folderTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void folderButtonbrowse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderTextField.getText()));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.folderTextField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderTextField.setText("");
            }
        }
    }

    void load() {
        this.folderTextField.setText(DataPrefs.getRecoveryPath());
    }

    void store() {
        if (this.valid()) {
            DataPrefs.setRecoveryPath(this.tidyPath(this.folderTextField.getText()));
        }
    }

    boolean valid() {
        String path = this.tidyPath(this.folderTextField.getText());
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String tidyPath(String path) {
        path = path.trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            DataPrefsPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            DataPrefsPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            DataPrefsPanel.this.controller.changed();
        }
    }
}

