/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeViewCellEditor
extends DefaultTreeCellEditor
implements CellEditorListener,
FocusListener,
MouseMotionListener {
    static final long serialVersionUID = -2171725285964032312L;
    boolean dndActive = false;
    private boolean cancelled = false;
    private boolean stopped = false;

    public TreeViewCellEditor(JTree jTree) {
        super(jTree, new DefaultTreeCellRenderer());
        if (jTree.getSelectionCount() == 1) {
            this.lastPath = jTree.getSelectionPath();
        }
        this.addCellEditorListener(this);
    }

    public void editingStopped(ChangeEvent changeEvent) {
        Node node;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        TreePath treePath = this.lastPath;
        if (treePath != null && (node = Visualizer.findNode(treePath.getLastPathComponent())) != null && node.canRename()) {
            String string = (String)this.getCellEditorValue();
            try {
                if (!node.getName().equals(string)) {
                    node.setName(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                boolean bl = true;
                ErrorManager errorManager = ErrorManager.getDefault();
                ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations((Throwable)illegalArgumentException);
                if (annotationArray != null && annotationArray.length > 0) {
                    for (int i = 0; i < annotationArray.length; ++i) {
                        String string2 = annotationArray[i].getLocalizedMessage();
                        if (string2 == null || string2.equals("")) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    String string3 = NbBundle.getMessage((Class)TreeViewCellEditor.class, (String)"RenameFailed", (Object)node.getName(), (Object)string);
                    errorManager.annotate((Throwable)illegalArgumentException, string3);
                }
                errorManager.notify(256, (Throwable)illegalArgumentException);
            }
        }
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.cancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            this.cancelled = true;
            this.cancelCellEditing();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.stopped || this.cancelled) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    protected TreeCellEditor createTreeCellEditor() {
        JTextField jTextField = new JTextField(){

            public void addNotify() {
                TreeViewCellEditor.this.stopped = (TreeViewCellEditor.this.cancelled = false);
                super.addNotify();
                this.requestFocus();
            }
        };
        jTextField.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 0);
        jTextField.addFocusListener(this);
        Ed ed = new Ed(jTextField);
        ed.setClickCountToStart(1);
        ed.getComponent().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TreeViewCellEditor.class, (String)"ACSD_TreeViewCellEditor"));
        ed.getComponent().getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)TreeViewCellEditor.class, (String)"ACSN_TreeViewCellEditor"));
        return ed;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject != null && eventObject instanceof MouseEvent && (!SwingUtilities.isLeftMouseButton((MouseEvent)eventObject) || ((MouseEvent)eventObject).isPopupTrigger())) {
            return false;
        }
        if (this.lastPath != null) {
            Node node = Visualizer.findNode(this.lastPath.getLastPathComponent());
            if (node == null || !node.canRename()) {
                return false;
            }
        } else {
            return false;
        }
        if (this.dndActive) {
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.renderer != null) {
            this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
            this.editingIcon = this.renderer.getIcon();
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : 0;
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    void setDnDActive(boolean bl) {
        if (!bl) {
            this.tree.removeMouseMotionListener(this);
        }
        this.dndActive = bl;
    }

    protected void setTree(JTree jTree) {
        if (jTree != this.tree && this.timer != null && this.timer.isRunning()) {
            this.tree.removeMouseMotionListener(this);
        }
        super.setTree(jTree);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = this.checkContinueTimer(point);
        if (!bl) {
            this.abortTimer();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = this.checkContinueTimer(point);
        if (!bl) {
            this.abortTimer();
        }
    }

    private void abortTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.tree.removeMouseMotionListener(this);
        }
    }

    protected void startEditingTimer() {
        this.tree.addMouseMotionListener(this);
        super.startEditingTimer();
    }

    protected void prepareForEditing() {
        this.abortTimer();
        this.tree.removeMouseMotionListener(this);
        super.prepareForEditing();
    }

    private boolean checkContinueTimer(Point point) {
        Rectangle rectangle = this.tree.getPathBounds(this.tree.getSelectionPath());
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(point);
    }

    class Ed
    extends DefaultCellEditor {
        static final long serialVersionUID = -6373058702842751408L;

        public Ed(JTextField jTextField) {
            super(jTextField);
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Node node = Visualizer.findNode(object);
            if (node != null && node.canRename()) {
                this.delegate.setValue(node.getName());
            } else {
                this.delegate.setValue("");
            }
            TreeViewCellEditor.this.editingIcon = ((VisualizerNode)object).getIcon(bl2, false);
            ((JTextField)this.editorComponent).selectAll();
            return this.editorComponent;
        }
    }
}

