/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;

class StringInplaceEditor
extends JTextField
implements InplaceEditor {
    protected PropertyEditor editor;
    protected PropertyEnv env;
    private boolean added;
    private String valFromEditor;
    private String valFromTextField;
    private PropertyModel pm;
    private KeyStroke[] strokes = new KeyStroke[]{KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), KeyStroke.getKeyStroke(38, 0, false), KeyStroke.getKeyStroke(40, 0, false)};

    StringInplaceEditor() {
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public void clear() {
        this.editor = null;
        this.setEditable(true);
        this.setEnabled(true);
        this.setText("");
        this.pm = null;
        this.env = null;
        this.valFromEditor = null;
        this.valFromTextField = null;
    }

    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.setActionCommand("success");
        this.env = propertyEnv;
        if (this.editor == propertyEditor) {
            return;
        }
        this.editor = propertyEditor;
        boolean bl = PropUtils.checkEnabled(this, propertyEditor, propertyEnv);
        this.setEnabled(bl);
        if (propertyEditor.getTags() == null && propertyEditor.getAsText() == null && propertyEditor.isPaintable()) {
            bl = false;
        }
        this.setEditable(bl);
        this.reset();
        this.added = false;
    }

    public void addNotify() {
        super.addNotify();
        this.added = true;
    }

    public JComponent getComponent() {
        return this;
    }

    public Object getValue() {
        if (this.valFromTextField != null && this.valFromTextField.equals(this.getText())) {
            return this.valFromEditor;
        }
        return this.getText();
    }

    public void reset() {
        String string;
        String string2 = this.editor.getAsText();
        if (this.editor instanceof PropUtils.DifferentValuesEditor) {
            string2 = "";
        }
        this.valFromEditor = string2;
        if (this.getClass() == StringInplaceEditor.class && this.env != null && this.env.getFeatureDescriptor() != null && (string = (String)this.env.getFeatureDescriptor().getValue("initialEditValue")) != null) {
            this.valFromEditor = string2 = string;
        }
        if (string2 == null) {
            string2 = "";
        }
        this.setText(string2);
        this.valFromTextField = this.getText();
        this.setSelectionStart(0);
        this.setSelectionEnd(string2.length());
    }

    public KeyStroke[] getKeyStrokes() {
        return this.strokes;
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    private void handleInitialInputEvent(InputEvent inputEvent) {
        String string = this.getText();
        if (string.length() > 0) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
    }

    public void setValue(Object object) {
        if (null != object && null != this.editor && this.editor.supportsCustomEditor()) {
            this.editor.setValue(object);
            this.setText(this.editor.getAsText());
        } else {
            this.setText(object != null ? object.toString() : "");
        }
    }

    public boolean supportsTextEntry() {
        return true;
    }

    public PropertyModel getPropertyModel() {
        return this.pm;
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.pm = propertyModel;
    }

    public boolean isKnownComponent(Component component) {
        return false;
    }

    public Dimension getPreferredSize() {
        Graphics graphics = PropUtils.getScratchGraphics(this);
        String string = this.getText();
        if (string.length() > 1000) {
            return new Dimension(4196, graphics.getFontMetrics(this.getFont()).getHeight());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        Dimension dimension = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        dimension.width = Math.max(dimension.width, PropUtils.getMinimumPropPanelWidth());
        dimension.height = Math.max(dimension.height, PropUtils.getMinimumPropPanelHeight());
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            dimension.width += insets.right + insets.left;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (this.added) {
            this.handleInitialInputEvent(mouseEvent);
        }
        this.added = false;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (this.editor != null && !this.hasFocus() && this.editor.isPaintable()) {
            Insets insets = this.getInsets();
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            finally {
                graphics.setColor(color);
            }
            insets.left += PropUtils.getTextMargin();
            this.editor.paintValue(graphics, new Rectangle(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - (insets.top + insets.bottom)));
        } else {
            super.paintComponent(graphics);
        }
    }
}

