/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PSheet;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PropertySheet
extends JPanel {
    static final long serialVersionUID = -7698351033045864945L;
    public static final String PROPERTY_SORTING_MODE = "sortingMode";
    public static final String PROPERTY_VALUE_COLOR = "valueColor";
    public static final String PROPERTY_DISABLED_PROPERTY_COLOR = "disabledPropertyColor";
    public static final String PROPERTY_CURRENT_PAGE = "currentPage";
    public static final String PROPERTY_PLASTIC = "plastic";
    public static final String PROPERTY_PROPERTY_PAINTING_STYLE = "propertyPaintingStyle";
    public static final String PROPERTY_DISPLAY_WRITABLE_ONLY = "displayWritableOnly";
    public static final int ALWAYS_AS_STRING = 1;
    public static final int STRING_PREFERRED = 2;
    public static final int PAINTING_PREFERRED = 3;
    public static final int UNSORTED = 0;
    public static final int SORTED_BY_NAMES = 1;
    public static final int SORTED_BY_TYPES = 2;
    protected static Icon iNoSort;
    protected static Icon iAlphaSort;
    protected static Icon iTypeSort;
    protected static Icon iDisplayWritableOnly;
    protected static Icon iCustomize;
    private static final String ACTION_INVOKE_POPUP = "invokePopup";
    private static final String ACTION_INVOKE_HELP = "invokeHelp";
    private static final int INIT_DELAY = 70;
    private static final int MAX_DELAY = 150;
    private static final boolean neverTabs;
    static final boolean forceTabs;
    private int sortingMode = 0;
    private boolean showDesc;
    private Reference storedNode;
    SheetTable table = new SheetTable();
    PSheet psheet = new PSheet();
    HelpAction helpAction = new HelpAction();
    private transient Node[] helperNodes;
    private transient RequestProcessor.Task scheduleTask;
    private transient RequestProcessor.Task initTask;
    SheetPCListener pclistener = new SheetPCListener();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$HelpCtx;

    public PropertySheet() {
        this.init();
        this.initActions();
    }

    private void initActions() {
        MutableAction mutableAction = new MutableAction(2, this);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(121, 1), ACTION_INVOKE_POPUP);
        this.table.getActionMap().put(ACTION_INVOKE_POPUP, mutableAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(121, 1), ACTION_INVOKE_POPUP);
        this.getActionMap().put(ACTION_INVOKE_POPUP, mutableAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), ACTION_INVOKE_HELP);
        this.getActionMap().put(ACTION_INVOKE_HELP, this.helpAction);
    }

    public void addNotify() {
        super.addNotify();
        Node node = null;
        if (this.storedNode != null) {
            node = (Node)this.storedNode.get();
        }
        if (node != null) {
            this.setCurrentNode(node);
        }
    }

    public void updateUI() {
        UIManager.get("nb.propertysheet");
        super.updateUI();
    }

    public void removeNotify() {
        Node node = null;
        if (this.pclistener != null) {
            node = this.pclistener.detach();
        }
        this.doSetNodes(null);
        if (node != null) {
            this.storedNode = new WeakReference<Node>(node);
        }
        super.removeNotify();
        this.table.getReusablePropertyEnv().setBeans(null);
        this.table.getReusablePropertyEnv().setNode(null);
        this.table.getReusablePropertyModel().setProperty(null);
    }

    private void init() {
        Font font = UIManager.getFont("controlFont");
        if (font == null) {
            font = UIManager.getFont("Tree.font");
        }
        if (font != null) {
            this.table.setFont(font);
        }
        this.showDesc = PropUtils.shouldShowDescription();
        this.setLayout(new BorderLayout());
        this.psheet.setBackground(this.table.getBackground());
        this.setBackground(this.table.getBackground());
        this.psheet.setMarginColor(PropUtils.getSetRendererColor());
        this.psheet.add(this.table);
        this.add((Component)this.psheet, "Center");
        this.table.setBorder(BorderFactory.createEmptyBorder());
        this.setDescriptionVisible(this.showDesc);
        this.setMinimumSize(new Dimension(100, 50));
        this.psheet.setEmptyString(NbBundle.getMessage((Class)PropertySheet.class, (String)"CTL_NoProperties"));
        TabSelectionListener tabSelectionListener = new TabSelectionListener();
        this.psheet.addSelectionChangeListener(tabSelectionListener);
        this.table.addChangeListener(tabSelectionListener);
        try {
            this.setSortingMode(PropUtils.getSavedSortOrder());
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    void setDescriptionVisible(boolean bl) {
        if (this.isDescriptionVisible() != bl) {
            int n = this.psheet.getState();
            if (!bl) {
                int n2 = (n & 2) != 0 ? 2 : 0;
                this.psheet.setState(n2);
            } else {
                int n3 = (n & 2) != 0 ? 3 : 1;
                this.psheet.setState(n3);
            }
            PropUtils.saveShowDescription(bl);
        }
    }

    boolean isDescriptionVisible() {
        return (this.psheet.getState() & 1) != 0;
    }

    public void requestFocus() {
        if (this.table.getParent() != null) {
            this.table.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.table.getParent() != null) {
            return this.table.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private void doSetNodes(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            this.table.getPropertySetModel().setPropertySets(null);
            this.table.getReusablePropertyEnv().clear();
            return;
        }
        ProxyNode proxyNode = nodeArray.length == 1 ? nodeArray[0] : new ProxyNode(nodeArray);
        this.setCurrentNode((Node)proxyNode);
    }

    public synchronized void setNodes(Node[] nodeArray) {
        Node[] nodeArray2;
        final boolean bl = PropUtils.isLoggable(PropertySheet.class);
        if (bl) {
            PropUtils.log(PropertySheet.class, "SetNodes " + Arrays.asList(nodeArray));
        }
        if (nodeArray != null && nodeArray.length > 0 && this.pclistener != null) {
            if (nodeArray.length == 1 && nodeArray[0] == this.pclistener.getNode()) {
                if (bl) {
                    PropUtils.log(PropertySheet.class, "  Same node selected as before; no redisplay needed");
                }
                return;
            }
            if (this.pclistener.getNode() instanceof ProxyNode) {
                if (bl) {
                    PropUtils.log(PropertySheet.class, "  Selected node is a proxy node - comparing contents.");
                }
                nodeArray2 = ((ProxyNode)this.pclistener.getNode()).getOriginalNodes();
                if (((Object)Arrays.asList(nodeArray)).equals(Arrays.asList(nodeArray2))) {
                    if (bl) {
                        PropUtils.log(PropertySheet.class, "  Proxy node represents the same nodes already showing.  Showing: " + Arrays.asList(nodeArray2) + " requested " + Arrays.asList(nodeArray));
                        HashSet<Node> hashSet = new HashSet<Node>(Arrays.asList(nodeArray2));
                        HashSet<Node> hashSet2 = new HashSet<Node>(Arrays.asList(nodeArray));
                        if (hashSet.size() != nodeArray2.length) {
                            PropUtils.log(PropertySheet.class, " A hashSet of the current nodes does NOT have the same number  of elements as the array of current nodes!  Check your hashCode()/equals() contract.  One or more nodes in the array are claiming to be the same node.");
                        }
                        if (hashSet2.size() != nodeArray.length) {
                            PropUtils.log(PropertySheet.class, " A hashSet of the requested selected nodes does NOT have the same number  of elements as the array of current nodes!  Check your hashCode()/equals() contract One or more nodes in the array are claiming to be the same node.");
                        }
                    }
                    return;
                }
            }
        } else if (nodeArray == null || nodeArray.length == 0) {
            if (this.pclistener != null) {
                this.pclistener.detach();
            }
            if (SwingUtilities.isEventDispatchThread()) {
                if (bl) {
                    PropUtils.log(PropertySheet.class, "  Nodes cleared on event queue.  Emptying model.");
                }
                this.table.getPropertySetModel().setPropertySets(null);
                this.table.getReusablePropertyEnv().clear();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (bl) {
                            PropUtils.log(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet, "  Nodes cleared off event queue.  Empty model later on EQ.");
                        }
                        PropertySheet.this.table.getPropertySetModel().setPropertySets(null);
                        PropertySheet.this.table.getReusablePropertyEnv().clear();
                    }
                });
            }
            return;
        }
        nodeArray2 = this.getScheduleTask();
        this.helperNodes = nodeArray;
        this.storedNode = null;
        if (nodeArray2.equals(this.initTask)) {
            this.scheduleTask.schedule(0);
            nodeArray2.schedule(70);
        } else {
            int n = nodeArray2.getDelay() * 2;
            if (n > 150) {
                n = 150;
            }
            if (n < 70) {
                n = 70;
            }
            if (bl) {
                PropUtils.log(PropertySheet.class, " Scheduling delayed update of selected nodes.");
            }
            nodeArray2.schedule(n);
        }
    }

    private synchronized RequestProcessor.Task getScheduleTask() {
        if (this.scheduleTask == null) {
            this.scheduleTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final Node[] nodeArray = PropertySheet.this.helperNodes;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean bl = PropUtils.isLoggable(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet);
                            if (bl) {
                                PropUtils.log(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet, "Delayed updater setting nodes to " + Arrays.asList(nodeArray));
                            }
                            PropertySheet.this.doSetNodes(nodeArray);
                        }
                    });
                }
            });
            this.initTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                }
            });
        }
        if (this.initTask.isFinished() && this.scheduleTask.isFinished()) {
            return this.initTask;
        }
        return this.scheduleTask;
    }

    void setCurrentNode(Node node) {
        Object object;
        boolean bl;
        boolean bl2;
        Node node2 = this.pclistener.getNode();
        if (node2 != node) {
            this.psheet.storeScrollAndTabInfo();
        }
        if (bl2 = PropUtils.isLoggable(PropertySheet.class)) {
            PropUtils.log(PropertySheet.class, "SetCurrentNode:" + node);
        }
        PropertySetModel propertySetModel = this.table.getPropertySetModel();
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        if (propertySetArray == null) {
            ErrorManager.getDefault().log(16, "Node " + node + ": getPropertySets() returns null!");
            propertySetArray = new Node.PropertySet[]{};
        }
        this.table.getReusablePropertyEnv().setNode(node);
        if (!$assertionsDisabled && !this.noNullPropertyLists(propertySetArray)) {
            throw new AssertionError((Object)("Node " + node + " returns null from getProperties() for one or " + "more of its property sets"));
        }
        if (this.table.isEditing()) {
            this.table.removeEditor();
        }
        if (bl = PropertySheet.needTabs(node)) {
            this.psheet.setState(this.psheet.getState() | 2);
            object = PropertySheet.getTabItems(node);
            this.psheet.setTabbedContainerItems(((TabInfo)object).sets, ((TabInfo)object).titles);
            this.psheet.manager().setCurrentNodeName(node.getName());
            propertySetModel.setPropertySets(((TabInfo)object).getSets(0));
        } else {
            propertySetModel.setPropertySets(propertySetArray);
            this.psheet.setState((this.psheet.getState() & 1) != 0 ? 1 : 0);
            this.psheet.setTabbedContainerItems(new Object[0], new String[0]);
        }
        this.psheet.adjustForName(node.getName());
        this.table.setBeanName(node.getDisplayName());
        object = (String)node.getValue("nodeDescription");
        this.psheet.setDescription(node.getDisplayName(), (String)(object == null ? node.getShortDescription() : object));
        this.pclistener.attach(node);
        if (this.isDescriptionVisible()) {
            this.helpAction.checkContext();
        }
    }

    private boolean noNullPropertyLists(Node.PropertySet[] propertySetArray) {
        boolean bl = true;
        for (int i = 0; i < propertySetArray.length && (bl &= propertySetArray[i].getProperties() != null); ++i) {
        }
        return bl;
    }

    public void setPropertyPaintingStyle(int n) {
    }

    public int getPropertyPaintingStyle() {
        return 0;
    }

    public void setSortingMode(int n) throws PropertyVetoException {
        try {
            this.table.getPropertySetModel().setComparator(PropUtils.getComparator(n));
            this.sortingMode = n;
            this.psheet.setMarginPainted(false);
            PropUtils.putSortOrder(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PropertyVetoException(NbBundle.getMessage((Class)PropertySheet.class, (String)"EXC_Unknown_sorting_mode"), new PropertyChangeEvent(this, PROPERTY_SORTING_MODE, new Integer(0), new Integer(n)));
        }
    }

    public int getSortingMode() {
        return this.sortingMode;
    }

    public void setCurrentPage(int n) {
    }

    public boolean setCurrentPage(String string) {
        return false;
    }

    public int getCurrentPage() {
        return 0;
    }

    public void setPlastic(boolean bl) {
    }

    public boolean getPlastic() {
        return false;
    }

    public void setValueColor(Color color) {
    }

    public Color getValueColor() {
        return Color.BLACK;
    }

    public void setDisabledPropertyColor(Color color) {
    }

    public Color getDisabledPropertyColor() {
        return Color.GRAY;
    }

    public void setDisplayWritableOnly(boolean bl) {
    }

    public boolean getDisplayWritableOnly() {
        return false;
    }

    final void showPopup(Point point) {
        JMenuItem jMenuItem = new JMenuItem();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jRadioButtonMenuItem2.setSelected(this.getSortingMode() == 0);
        jRadioButtonMenuItem.setSelected(this.getSortingMode() == 1);
        this.helpAction.checkContext();
        jMenuItem.setAction(this.helpAction);
        jRadioButtonMenuItem.setAction(new MutableAction(0, this));
        jRadioButtonMenuItem2.setAction(new MutableAction(1, this));
        jCheckBoxMenuItem.setAction(new MutableAction(3, this));
        jCheckBoxMenuItem.setSelected(this.isDescriptionVisible());
        jMenuItem2.setAction(new MutableAction(5, this));
        FeatureDescriptor featureDescriptor = this.table.getSelection();
        jMenuItem2.setEnabled(PropUtils.shallBeRDVEnabled(featureDescriptor));
        jPopupMenu.add(jRadioButtonMenuItem2);
        jPopupMenu.add(jRadioButtonMenuItem);
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(this.psheet, point.x, point.y);
    }

    Node[] getCurrentNodes() {
        Node node = this.pclistener.getNode();
        if (node != null) {
            if (node instanceof ProxyNode) {
                return ((ProxyNode)node).getOriginalNodes();
            }
            return new Node[]{node};
        }
        return new Node[0];
    }

    private static final boolean needTabs(Node node) {
        boolean bl;
        block5: {
            block6: {
                bl = true;
                if (forceTabs) {
                    return true;
                }
                if (!(node instanceof ProxyNode)) break block6;
                Node[] nodeArray = ((ProxyNode)node).getOriginalNodes();
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (!$assertionsDisabled && nodeArray[i] == node) {
                        throw new AssertionError((Object)"Proxy node recursively references itself");
                    }
                    if (bl &= PropertySheet.needTabs(nodeArray[i])) {
                        continue;
                    }
                    break block5;
                }
                break block5;
            }
            Node.PropertySet[] propertySetArray = node.getPropertySets();
            boolean bl2 = forceTabs ? propertySetArray.length > 1 : (bl = neverTabs ? false : false);
            if (neverTabs) break block5;
            for (int i = 0; i < propertySetArray.length && !bl; bl |= propertySetArray[i].getValue("tabName") != null, ++i) {
            }
        }
        return bl;
    }

    private static final TabInfo getTabItems(Node node) {
        Object[] objectArray;
        HashMap<Object[], ArrayList<Node.PropertySet>> hashMap = new HashMap<Object[], ArrayList<Node.PropertySet>>();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            ArrayList<Node.PropertySet> arrayList2;
            objectArray = (Object[])propertySetArray[i].getValue("tabName");
            if (objectArray == null) {
                objectArray = PropUtils.basicPropsTabName();
            }
            if ((arrayList2 = (ArrayList<Node.PropertySet>)hashMap.get(objectArray)) == null) {
                arrayList2 = new ArrayList<Node.PropertySet>();
                arrayList2.add(propertySetArray[i]);
                hashMap.put(objectArray, arrayList2);
            } else {
                arrayList2.add(propertySetArray[i]);
            }
            if (arrayList.contains(objectArray)) continue;
            arrayList.add(objectArray);
        }
        String[] stringArray = new String[arrayList.size()];
        objectArray = new Object[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            List list = (List)hashMap.get(stringArray[n]);
            objectArray[n] = new Node.PropertySet[list.size()];
            objectArray[n] = list.toArray((Node.PropertySet[])objectArray[n]);
            ++n;
        }
        return new TabInfo(stringArray, objectArray);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        super.firePropertyChange(string, bl, bl2);
        if ("MACOSX".equals(string)) {
            this.table.focusLostCancel();
        }
    }

    static {
        $assertionsDisabled = !PropertySheet.class.desiredAssertionStatus();
        neverTabs = Boolean.getBoolean("netbeans.ps.nevertabs");
        forceTabs = Boolean.getBoolean("nb.ps.forcetabs");
    }

    final class HelpAction
    extends AbstractAction {
        HelpCtx.Provider provider;
        private boolean wasEnabled;

        public HelpAction() {
            super(NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet), (String)"CTL_Help"));
            this.provider = null;
            this.wasEnabled = false;
            this.checkContext();
        }

        public void checkContext() {
            boolean bl;
            HelpCtx helpCtx = this.getContext();
            boolean bl2 = bl = helpCtx != null;
            if (bl != this.wasEnabled) {
                this.firePropertyChange("enabled", bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
            }
            this.wasEnabled = bl;
            PropertySheet.this.psheet.setHelpEnabled(bl);
        }

        public boolean isEnabled() {
            return this.getContext() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpCtx helpCtx = this.getContext();
            if (helpCtx == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PropertySheet.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass("org.netbeans.api.javahelp.Help");
                Object object = Lookup.getDefault().lookup(clazz);
                if (object != null) {
                    Method method = clazz.getMethod("showHelp", class$org$openide$util$HelpCtx == null ? (class$org$openide$util$HelpCtx = PropertySheet.class$("org.openide.util.HelpCtx")) : class$org$openide$util$HelpCtx);
                    if (method != null) {
                        method.invoke(object, helpCtx);
                    }
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            Toolkit.getDefaultToolkit().beep();
        }

        public HelpCtx getContext() {
            String string;
            block8: {
                Node[] nodeArray;
                block10: {
                    FeatureDescriptor featureDescriptor;
                    block9: {
                        featureDescriptor = PropertySheet.this.table.getSelection();
                        string = null;
                        if (featureDescriptor != null && featureDescriptor instanceof Node.Property) {
                            string = (String)featureDescriptor.getValue("helpID");
                        }
                        if (string != null) break block8;
                        if ((PropertySheet.this.psheet.getState() & 2) == 0) break block9;
                        nodeArray = (Node[])PropertySheet.this.psheet.getTabbedContainerSelection();
                        if (nodeArray == null || nodeArray.length <= 0) break block10;
                        string = (String)nodeArray[0].getValue("helpID");
                        break block10;
                    }
                    if (string == null && PropertySheet.this.pclistener != null) {
                        nodeArray = PropertySheet.this.pclistener.getNode();
                        if (nodeArray == null) {
                            return null;
                        }
                        Node.PropertySet[] propertySetArray = nodeArray.getPropertySets();
                        if (featureDescriptor != null && propertySetArray != null && propertySetArray.length > 0) {
                            for (int i = 0; i < propertySetArray.length; ++i) {
                                if (propertySetArray[i] != featureDescriptor && !Arrays.asList(propertySetArray[i].getProperties()).contains(featureDescriptor)) continue;
                                string = (String)propertySetArray[i].getValue("helpID");
                                break;
                            }
                        }
                    }
                }
                if (string == null && PropertySheet.this.pclistener != null && (nodeArray = PropertySheet.this.getCurrentNodes()) != null && nodeArray.length > 0) {
                    for (int i = 0; i < nodeArray.length && (string = (String)nodeArray[i].getValue("propertiesHelpID")) == null; ++i) {
                        HelpCtx helpCtx = nodeArray[i].getHelpCtx();
                        if (helpCtx == null || helpCtx == HelpCtx.DEFAULT_HELP) continue;
                        return helpCtx;
                    }
                }
            }
            if (string != null && !HelpCtx.DEFAULT_HELP.getHelpID().equals(string)) {
                return new HelpCtx(string);
            }
            return null;
        }
    }

    private static class MutableAction
    extends AbstractAction {
        private static final int SORT_NAMES = 0;
        private static final int UNSORT = 1;
        private static final int INVOKE_POPUP = 2;
        private static final int SHOW_DESCRIPTION = 3;
        private static final int SHOW_HELP = 4;
        private static final int RESTORE_DEFAULT = 5;
        private final int id;
        private final PropertySheet sheet;

        public MutableAction(int n, PropertySheet propertySheet) {
            this.id = n;
            this.sheet = propertySheet;
            String string = null;
            switch (n) {
                case 0: {
                    string = "CTL_AlphaSort";
                    break;
                }
                case 1: {
                    string = "CTL_NoSort";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    string = "CTL_ShowDescription";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    string = "CTL_RestoreDefaultValue";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(n));
                }
            }
            if (string != null) {
                this.putValue("Name", NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet), (String)string));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.id) {
                case 0: {
                    try {
                        this.sheet.setSortingMode(1);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 1: {
                    try {
                        this.sheet.setSortingMode(0);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 2: {
                    this.sheet.showPopup(new Point(0, 0));
                    break;
                }
                case 3: {
                    this.sheet.setDescriptionVisible(!this.sheet.isDescriptionVisible());
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    try {
                        ((Node.Property)this.sheet.table.getSelection()).restoreDefaultValue();
                        break;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalStateException illegalStateException = new IllegalStateException("Error restoring default value");
                        ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)illegalAccessException);
                        throw illegalStateException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        IllegalStateException illegalStateException = new IllegalStateException("Error restoring defaul value");
                        ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)invocationTargetException);
                        throw illegalStateException;
                    }
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(this.id));
                }
            }
        }

        public boolean isEnabled() {
            if (this.id == 2 && Boolean.TRUE.equals(this.sheet.getClientProperty("disablePopup"))) {
                return false;
            }
            return super.isEnabled();
        }
    }

    private final class SheetPCListener
    extends NodeAdapter {
        private PropertyChangeListener inner = new PCL();
        private Node currNode;

        public void attach(Node node) {
            if (this.currNode != node) {
                if (this.currNode != null) {
                    this.detach();
                }
                if (node != null) {
                    node.addPropertyChangeListener(this.inner);
                    node.addNodeListener((NodeListener)this);
                    if (PropUtils.isLoggable(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet)) {
                        PropUtils.log(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet, "Now listening for changes on " + node);
                    }
                }
                this.currNode = node;
            }
        }

        public Node getNode() {
            return this.currNode;
        }

        public Node detach() {
            Node node = this.currNode;
            if (this.currNode != null) {
                if (PropUtils.isLoggable(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet)) {
                    PropUtils.log(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropertySheet.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet, "Detaching listeners from " + node);
                }
                this.currNode.removePropertyChangeListener(this.inner);
                this.currNode.removeNodeListener((NodeListener)this);
                this.currNode = null;
            }
            return node;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("propertySets".equals(string)) {
                final Node node = (Node)propertyChangeEvent.getSource();
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        SheetPCListener.this.attach(node);
                        PropertySheet.this.setCurrentNode(node);
                    }
                });
            } else {
                if ("cookie".equals(string) || "icon".equals(string) || "parentNode".equals(string) || "openedIcon".equals(string) || "leaf".equals(string)) {
                    return;
                }
                if (PropertySheet.this.isDescriptionVisible() && ("displayName".equals(string) || "shortDescription".equals(string))) {
                    Node node = (Node)propertyChangeEvent.getSource();
                }
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            this.detach();
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    PropertySheet.this.doSetNodes(null);
                }
            });
        }

        private final class PCL
        implements PropertyChangeListener {
            private PCL() {
            }

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String string = propertyChangeEvent.getPropertyName();
                        if (string == null) {
                            if (SheetPCListener.this.currNode != null) {
                                PropertySheet.this.setCurrentNode(SheetPCListener.this.currNode);
                            }
                        } else {
                            ((SheetPCListener)((PCL)PCL.this).SheetPCListener.this).PropertySheet.this.table.repaintProperty(string);
                        }
                    }
                });
            }
        }
    }

    private static final class TabInfo {
        public String[] titles;
        public Object[] sets;

        public TabInfo(String[] stringArray, Object[] objectArray) {
            this.titles = stringArray;
            this.sets = objectArray;
        }

        public Node.PropertySet[] getSets(int n) {
            return (Node.PropertySet[])this.sets[n];
        }
    }

    private class TabSelectionListener
    implements ChangeListener,
    FocusListener {
        private TabSelectionListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PropertySheet.this.helpAction.checkContext();
            if (changeEvent.getSource() instanceof SheetTable) {
                SheetTable sheetTable = (SheetTable)changeEvent.getSource();
                FeatureDescriptor featureDescriptor = sheetTable.getSelection();
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                if (component != sheetTable && !sheetTable.isKnownComponent(component) && !PropertySheet.this.isAncestorOf(component)) {
                    featureDescriptor = null;
                }
                if (featureDescriptor != null) {
                    String string = featureDescriptor.getDisplayName();
                    String string2 = featureDescriptor.getShortDescription();
                    PropertySheet.this.psheet.setDescription(string, string2);
                } else {
                    Node node = PropertySheet.this.pclistener.getNode();
                    if (node != null) {
                        String string = node.getDisplayName();
                        String string3 = (String)node.getValue("nodeDescription");
                        if (string3 == null) {
                            string3 = node.getShortDescription();
                        }
                        PropertySheet.this.psheet.setDescription(string, string3);
                    } else {
                        PropertySheet.this.psheet.setDescription(null, null);
                    }
                }
            } else {
                Node.PropertySet[] propertySetArray;
                if (!PropertySheet.this.psheet.isAdjusting()) {
                    PropertySheet.this.psheet.storeScrollAndTabInfo();
                }
                if ((propertySetArray = (Node.PropertySet[])PropertySheet.this.psheet.getTabbedContainerSelection()) != null) {
                    PropertySheet.this.table.getPropertySetModel().setPropertySets(propertySetArray);
                    if (propertySetArray.length > 0 && !PropertySheet.this.psheet.isAdjusting()) {
                        String string = (String)propertySetArray[0].getValue("tabName");
                        string = string == null ? PropUtils.basicPropsTabName() : string;
                        PropertySheet.this.psheet.manager().storeLastSelectedGroup(string);
                        PropertySheet.this.psheet.adjustForName(string);
                    }
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            ChangeEvent changeEvent = new ChangeEvent(PropertySheet.this.table);
            this.stateChanged(changeEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }
    }
}

