/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ViewportUI;
import org.netbeans.modules.openide.explorer.TabbedContainerBridge;
import org.openide.explorer.propertysheet.DescriptionComponent;
import org.openide.explorer.propertysheet.MarginViewportUI;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.SelectionAndScrollPositionManager;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.nodes.Node;

class PSheet
extends JPanel
implements MouseListener {
    public static final int STATE_HAS_DESCRIPTION = 1;
    public static final int STATE_HAS_TABS = 2;
    private int addCount = 0;
    private String description = "";
    private String title = "";
    private SelectionAndScrollPositionManager manager = new SelectionAndScrollPositionManager();
    private boolean adjusting = false;
    private boolean helpEnabled = true;
    private boolean marginPainted = false;
    private Color marginColor = UIManager.getColor("controlShadow");
    private String emptyString = "THIS IS A BUG";
    private Boolean firstSplit = null;
    private Object[] tabbedContainerObjects = new String[]{"Hello", "World", "This", "Is", "Me"};
    private String[] tabbedContainerTitles = new String[]{"Tab 1", "Tab 2", "Tab 3", "Tab 4", "Tab 5"};
    private ChangeListener selectionListener = null;

    public PSheet() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "popup");
        this.getActionMap().put("popup", new PopupAction());
        this.getActionMap().put("PreviousViewAction", new SwitchTabAction(-1));
        this.getActionMap().put("NextViewAction", new SwitchTabAction(1));
    }

    SelectionAndScrollPositionManager manager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustForName(String string) {
        this.adjusting = true;
        try {
            JScrollPane jScrollPane;
            Object object;
            JComponent jComponent = this.findTabbedContainer();
            String string2 = null;
            if (jComponent != null) {
                boolean bl;
                string2 = this.manager().getGroupNameForNodeName(string);
                if (string2 == null || string2.length() <= 0) {
                    string2 = PropUtils.basicPropsTabName();
                }
                if (!(bl = TabbedContainerBridge.getDefault().setSelectionByName(jComponent, string2))) {
                    TabbedContainerBridge.getDefault().setSelectionByName(jComponent, PropUtils.basicPropsTabName());
                } else if (this.selectionListener != null) {
                    object = new ChangeEvent(this);
                    this.selectionListener.stateChanged((ChangeEvent)object);
                }
            }
            if ((jScrollPane = this.findScrollPane()) != null) {
                int n;
                Object object2 = object = string2 == null ? this.manager().getCurrentNodeName() : string2;
                if (object != null && (n = this.manager().getScrollPositionForNodeName((String)object)) >= 0 && n < jScrollPane.getVerticalScrollBar().getModel().getMaximum()) {
                    jScrollPane.getVerticalScrollBar().getModel().setValue(n);
                }
            }
        }
        finally {
            this.adjusting = false;
        }
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void storeScrollAndTabInfo() {
        JComponent jComponent = this.findTabbedContainer();
        String string = null;
        String string2 = this.manager().getCurrentNodeName();
        String string3 = this.manager().getLastSelectedGroupName();
        if (string2 != null) {
            JScrollPane jScrollPane;
            if (jComponent != null && (string = TabbedContainerBridge.getDefault().getCurrentSelectedTabName(jComponent)) != null) {
                this.manager().storeLastSelectedGroup(string);
            }
            if ((jScrollPane = this.findScrollPane()) != null) {
                int n = jScrollPane.getVerticalScrollBar().getModel().getValue();
                String string4 = string3 != null ? string3 : (string != null ? string : string2);
                this.manager().storeScrollPosition(n, string4);
            }
        }
    }

    public void setDescription(String string, String string2) {
        this.description = string2;
        this.title = string;
        DescriptionComponent descriptionComponent = this.findDescriptionComponent();
        if (descriptionComponent != null) {
            descriptionComponent.setDescription(string, string2);
        }
    }

    public void setHelpEnabled(boolean bl) {
        if (this.helpEnabled != bl) {
            this.helpEnabled = bl;
            DescriptionComponent descriptionComponent = this.findDescriptionComponent();
            if (descriptionComponent != null) {
                descriptionComponent.setHelpEnabled(bl);
            }
        }
    }

    public void setMarginPainted(boolean bl) {
        if (this.marginPainted != bl) {
            this.marginPainted = bl;
            MarginViewportUI marginViewportUI = this.findMVUI();
            if (marginViewportUI != null) {
                marginViewportUI.setMarginPainted(bl);
            }
        }
    }

    public void setMarginColor(Color color) {
        if (!color.equals(this.marginColor)) {
            this.marginColor = color;
            MarginViewportUI marginViewportUI = this.findMVUI();
            if (marginViewportUI != null) {
                marginViewportUI.setMarginColor(color);
            }
        }
    }

    public void setEmptyString(String string) {
        if (!string.equals(this.emptyString)) {
            this.emptyString = string;
            MarginViewportUI marginViewportUI = this.findMVUI();
            if (marginViewportUI != null) {
                marginViewportUI.setEmptyString(string);
            }
        }
    }

    private MarginViewportUI findMVUI() {
        MarginViewportUI marginViewportUI = null;
        JScrollPane jScrollPane = this.findScrollPane();
        if (jScrollPane != null) {
            ViewportUI viewportUI = jScrollPane.getViewport().getUI();
            if (viewportUI instanceof MarginViewportUI) {
                marginViewportUI = (MarginViewportUI)viewportUI;
            } else {
                marginViewportUI = (MarginViewportUI)MarginViewportUI.createUI(jScrollPane.getViewport());
                jScrollPane.getViewport().setUI(marginViewportUI);
            }
        }
        return marginViewportUI;
    }

    public void doLayout() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length > 0) {
            Insets insets = this.getInsets();
            componentArray[0].setBounds(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - insets.top + insets.bottom);
            if (componentArray[0] instanceof JSplitPane && Boolean.TRUE.equals(this.firstSplit)) {
                JSplitPane jSplitPane = (JSplitPane)componentArray[0];
                jSplitPane.setDividerLocation(0.8f);
                jSplitPane.resetToPreferredSizes();
                DescriptionComponent descriptionComponent = this.findDescriptionComponent();
                if (descriptionComponent != null) {
                    if (descriptionComponent.getHeight() > 0) {
                        this.firstSplit = Boolean.FALSE;
                    }
                } else {
                    this.firstSplit = Boolean.FALSE;
                }
            }
            if (componentArray.length > 1) {
                throw new IllegalStateException("Hmm, something is wrong: " + Arrays.asList(componentArray));
            }
        }
    }

    public void requestFocus() {
        JScrollPane jScrollPane = this.findScrollPane();
        if (jScrollPane != null && jScrollPane.getViewport().getView() != null) {
            jScrollPane.getViewport().getView().requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        JScrollPane jScrollPane = this.findScrollPane();
        if (jScrollPane != null && jScrollPane.getViewport().getView() != null) {
            return jScrollPane.getViewport().getView().requestFocusInWindow();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int n) {
        if (n != this.getState()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                switch (n) {
                    case 0: {
                        JSplitPane jSplitPane;
                        JComponent jComponent = this.findTabbedContainer();
                        if (jComponent != null) {
                            this.remove(jComponent);
                        }
                        if ((jSplitPane = this.findSplitPane()) == null) break;
                        this.remove(jSplitPane);
                        break;
                    }
                    case 1: {
                        JSplitPane jSplitPane = this.findSplitPane();
                        this.remove(this.findTabbedContainer());
                        if (jSplitPane != null) {
                            this.addImpl(jSplitPane, null, 0);
                            break;
                        }
                        this.addImpl(this.createDescriptionComponent(), null, 0);
                        break;
                    }
                    case 2: {
                        JSplitPane jSplitPane;
                        JScrollPane jScrollPane = this.findScrollPane();
                        JComponent jComponent = this.findTabbedContainer();
                        if (jComponent == null) {
                            this.addImpl(this.createTabbedContainer(), null, 0);
                        }
                        if ((jSplitPane = this.findSplitPane()) != null) {
                            this.remove(jSplitPane);
                        }
                        if (jScrollPane != null) {
                            this.setTabbedContainerInnerComponent(this.findTabbedContainer(), jScrollPane);
                        }
                        this.adjustForName(this.manager.getCurrentNodeName());
                        break;
                    }
                    case 3: {
                        JComponent jComponent = this.findTabbedContainer();
                        JSplitPane jSplitPane = this.findSplitPane();
                        JScrollPane jScrollPane = this.findScrollPane();
                        if (jComponent == null) {
                            jComponent = this.createTabbedContainer();
                            this.addImpl(jComponent, null, 0);
                        }
                        if (jSplitPane == null) {
                            this.addImpl(this.createDescriptionComponent(), null, 0);
                            jSplitPane = this.findSplitPane();
                        }
                        this.setTabbedContainerInnerComponent(jComponent, jSplitPane);
                        if (jScrollPane != null) {
                            jSplitPane.setLeftComponent(jScrollPane);
                        }
                        this.adjustForName(this.manager.getCurrentNodeName());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(Integer.toString(n));
                    }
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    public int getState() {
        int n = 0;
        if (this.findTabbedContainer() != null) {
            n |= 2;
        }
        if (this.findSplitPane() != null) {
            n |= 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof JSplitPane || component instanceof JScrollPane || component instanceof DescriptionComponent || component instanceof JTable || component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("tc")))) {
            throw new IllegalArgumentException("Unexpected component " + component);
        }
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            ++this.addCount;
            try {
                if (!Arrays.asList(component.getMouseListeners()).contains(this)) {
                    component.addMouseListener(this);
                }
                if (component instanceof JTable) {
                    JScrollPane jScrollPane = this.findScrollPane();
                    if (jScrollPane == null) {
                        jScrollPane = this.createScrollPane(component);
                    } else {
                        jScrollPane.setViewportView(component);
                    }
                    JSplitPane jSplitPane = this.findSplitPane();
                    if (jSplitPane != null) {
                        jSplitPane.setLeftComponent(jScrollPane);
                        jSplitPane.revalidate();
                    } else {
                        JComponent jComponent = this.findTabbedContainer();
                        if (jComponent != null) {
                            this.setTabbedContainerInnerComponent(jComponent, jSplitPane);
                        } else {
                            this.addImpl(jScrollPane, object, n);
                        }
                    }
                } else if (component instanceof DescriptionComponent) {
                    JScrollPane jScrollPane;
                    boolean bl;
                    JSplitPane jSplitPane = this.findSplitPane();
                    boolean bl2 = bl = jSplitPane != null;
                    if (jSplitPane == null) {
                        jSplitPane = this.createSplitPane(component);
                    }
                    if ((jScrollPane = this.findScrollPane()) != null) {
                        jSplitPane.setLeftComponent(jScrollPane);
                    }
                    if (!bl) {
                        this.addImpl(jSplitPane, object, n);
                    }
                    ((DescriptionComponent)component).setDescription(this.title, this.description);
                    ((DescriptionComponent)component).setHelpEnabled(this.helpEnabled);
                } else if (PSheet.isTabbedContainer(component)) {
                    JSplitPane jSplitPane = this.findSplitPane();
                    if (jSplitPane != null) {
                        super.remove(jSplitPane);
                        this.setTabbedContainerInnerComponent((JComponent)component, jSplitPane);
                    } else {
                        JScrollPane jScrollPane = this.findScrollPane();
                        if (jScrollPane != null) {
                            this.setTabbedContainerInnerComponent((JComponent)component, jScrollPane);
                            this.remove(jScrollPane);
                        }
                    }
                    super.addImpl(component, object, n);
                } else if (component instanceof JScrollPane) {
                    JSplitPane jSplitPane = this.findSplitPane();
                    if (jSplitPane != null) {
                        jSplitPane.setLeftComponent(component);
                        jSplitPane.revalidate();
                    } else {
                        JComponent jComponent = this.findTabbedContainer();
                        if (jComponent != null) {
                            this.setTabbedContainerInnerComponent(jComponent, (JComponent)component);
                        } else {
                            super.addImpl(component, object, n);
                        }
                    }
                } else if (component instanceof JSplitPane) {
                    JComponent jComponent;
                    JScrollPane jScrollPane = this.findScrollPane();
                    if (jScrollPane != null) {
                        ((JSplitPane)component).setLeftComponent(jScrollPane);
                    }
                    if ((jComponent = this.findTabbedContainer()) != null) {
                        this.setTabbedContainerInnerComponent(jComponent, (JComponent)component);
                    } else {
                        super.addImpl(component, object, n);
                    }
                } else {
                    super.addImpl(component, object, n);
                }
            }
            finally {
                --this.addCount;
                this.revalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        if (component == null) {
            return;
        }
        component.removeMouseListener(this);
        Object object = this.getTreeLock();
        synchronized (object) {
            JSplitPane jSplitPane;
            if (component.getParent() == this) {
                super.remove(component);
                if (this.adding()) {
                    return;
                }
            }
            if (PSheet.isTabbedContainer(component)) {
                JComponent jComponent = PSheet.getTabbedContainerInnerComponent((JComponent)component);
                if (jComponent != null) {
                    this.addImpl(jComponent, null, 0);
                }
            } else if (component instanceof JSplitPane) {
                Component component2;
                if (component.getParent() != null) {
                    component.getParent().remove(component);
                }
                if ((component2 = ((JSplitPane)component).getLeftComponent()) != null) {
                    this.addImpl(component2, null, 0);
                }
            } else if (component instanceof DescriptionComponent && (jSplitPane = this.findSplitPane()) != null) {
                jSplitPane.remove(component);
                this.remove(jSplitPane);
            }
        }
        this.revalidate();
    }

    private boolean adding() {
        return this.addCount > 0;
    }

    private DescriptionComponent createDescriptionComponent() {
        return new DescriptionComponent();
    }

    private JSplitPane createSplitPane(Component component) {
        JSplitPane jSplitPane = new JSplitPane();
        this.firstSplit = this.firstSplit == null ? Boolean.TRUE : Boolean.FALSE;
        jSplitPane.setRightComponent(component);
        jSplitPane.setOrientation(0);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setDividerLocation(0.8f);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        jSplitPane.setUI(PropUtils.createSplitPaneUI());
        jSplitPane.getActionMap().getParent().remove("toggleFocus");
        return jSplitPane;
    }

    private JScrollPane createScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addMouseListener(this);
        MarginViewportUI marginViewportUI = (MarginViewportUI)MarginViewportUI.createUI(jViewport);
        jViewport.setUI(marginViewportUI);
        marginViewportUI.setMarginPainted(this.marginPainted);
        marginViewportUI.setMarginColor(this.marginColor);
        marginViewportUI.setEmptyString(this.emptyString);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(jScrollPane.getBorder());
        return jScrollPane;
    }

    private JComponent createTabbedContainer() {
        JComponent jComponent = TabbedContainerBridge.getDefault().createTabbedContainer();
        jComponent.putClientProperty("tc", Boolean.TRUE);
        this.configureTabbedContainer(this.tabbedContainerObjects, this.tabbedContainerTitles, jComponent);
        if (this.selectionListener != null) {
            TabbedContainerBridge.getDefault().attachSelectionListener(jComponent, this.selectionListener);
        }
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabbedContainerItems(Object[] objectArray, String[] stringArray) {
        this.adjusting = true;
        try {
            this.tabbedContainerObjects = objectArray;
            this.tabbedContainerTitles = stringArray;
            if (objectArray.length == 0) {
                int n = (this.getState() & 1) != 0 ? 1 : 0;
                this.setState(n);
            } else {
                this.configureTabbedContainer(objectArray, stringArray, null);
            }
        }
        finally {
            this.adjusting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabbedContainerSelection(Object object) {
        JComponent jComponent = this.findTabbedContainer();
        if (jComponent != null) {
            this.adjusting = true;
            try {
                TabbedContainerBridge.getDefault().setSelectedItem(jComponent, object);
            }
            finally {
                this.adjusting = false;
            }
        }
    }

    public Object getTabbedContainerSelection() {
        Object object;
        JComponent jComponent = this.findTabbedContainer();
        if (jComponent != null && (object = TabbedContainerBridge.getDefault().getSelectedItem(jComponent)) instanceof Node.PropertySet[]) {
            return object;
        }
        return null;
    }

    private void configureTabbedContainer(Object[] objectArray, String[] stringArray, JComponent jComponent) {
        if (jComponent == null) {
            jComponent = this.findTabbedContainer();
        }
        if (jComponent != null) {
            TabbedContainerBridge.getDefault().setItems(jComponent, objectArray, stringArray);
        }
    }

    private void setTabbedContainerInnerComponent(JComponent jComponent, JComponent jComponent2) {
        if (jComponent == null) {
            jComponent = this.findTabbedContainer();
        }
        TabbedContainerBridge.getDefault().setInnerComponent(jComponent, jComponent2);
    }

    private static JComponent getTabbedContainerInnerComponent(JComponent jComponent) {
        JComponent jComponent2 = TabbedContainerBridge.getDefault().getInnerComponent(jComponent);
        return jComponent2;
    }

    public void addSelectionChangeListener(ChangeListener changeListener) {
        if (this.selectionListener != changeListener) {
            JComponent jComponent = this.findTabbedContainer();
            this.selectionListener = changeListener;
            if (jComponent != null) {
                TabbedContainerBridge.getDefault().attachSelectionListener(jComponent, changeListener);
            }
        }
    }

    private static boolean isTabbedContainer(Component component) {
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("tc"));
    }

    private DescriptionComponent findDescriptionComponent() {
        return (DescriptionComponent)PSheet.findChildOfClass(this.findSplitPane(), DescriptionComponent.class);
    }

    private JScrollPane findScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)PSheet.findChildOfClass(this, JScrollPane.class);
        if (jScrollPane == null && (jScrollPane = (JScrollPane)PSheet.findChildOfClass(this.findTabbedContainer(), JScrollPane.class)) == null) {
            jScrollPane = (JScrollPane)PSheet.findChildOfClass(this.findSplitPane(), JScrollPane.class);
        }
        return jScrollPane;
    }

    private JSplitPane findSplitPane() {
        JSplitPane jSplitPane = (JSplitPane)PSheet.findChildOfClass(this, JSplitPane.class);
        if (jSplitPane == null) {
            jSplitPane = (JSplitPane)PSheet.findChildOfClass(this.findTabbedContainer(), JSplitPane.class);
        }
        return jSplitPane;
    }

    private JComponent findTabbedContainer() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent) || !Boolean.TRUE.equals(((JComponent)componentArray[i]).getClientProperty("tc"))) continue;
            return (JComponent)componentArray[i];
        }
        return null;
    }

    private static Component findChildOfClass(Container container, Class clazz) {
        if (container == null) {
            return null;
        }
        if (PSheet.isTabbedContainer((JComponent)container)) {
            JComponent jComponent = PSheet.getTabbedContainerInnerComponent((JComponent)container);
            if (jComponent != null && jComponent.getClass() == clazz) {
                return jComponent;
            }
        } else {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (clazz != componentArray[i].getClass()) continue;
                return componentArray[i];
            }
        }
        return null;
    }

    protected void popupRequested(Point point) {
        PropertySheet propertySheet = (PropertySheet)SwingUtilities.getAncestorOfClass(PropertySheet.class, this);
        if (propertySheet != null) {
            propertySheet.showPopup(point);
        }
    }

    protected void helpRequested() {
        PropertySheet propertySheet = (PropertySheet)SwingUtilities.getAncestorOfClass(PropertySheet.class, this);
        if (propertySheet != null) {
            propertySheet.helpAction.actionPerformed(new ActionEvent(this, 1001, "invokeHelp"));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.updateSheetTableSelection(mouseEvent);
            this.popupRequested(point);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this);
            this.updateSheetTableSelection(mouseEvent);
            this.popupRequested(point);
        }
    }

    private void updateSheetTableSelection(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof SheetTable) {
            SheetTable sheetTable = (SheetTable)component;
            sheetTable.changeSelection(sheetTable.rowAtPoint(mouseEvent.getPoint()), 0, false, false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class PopupAction
    extends AbstractAction {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PSheet.this.popupRequested(new Point(0, 0));
        }
    }

    private class SwitchTabAction
    extends AbstractAction {
        private int increment;

        public SwitchTabAction(int n) {
            this.increment = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JComponent jComponent = PSheet.this.findTabbedContainer();
            if (null == jComponent) {
                return;
            }
            Object object = TabbedContainerBridge.getDefault().getSelectedItem(jComponent);
            if (null == object) {
                return;
            }
            Object[] objectArray = TabbedContainerBridge.getDefault().getItems(jComponent);
            int n2 = -1;
            for (n = 0; null != objectArray && n < objectArray.length; ++n) {
                if (!objectArray[n].equals(object)) continue;
                n2 = n;
                break;
            }
            if (n2 < 0) {
                return;
            }
            n = n2 + this.increment;
            if (n < 0) {
                n = objectArray.length - 1;
            }
            if (n >= objectArray.length) {
                n = 0;
            }
            TabbedContainerBridge.getDefault().setSelectedItem(jComponent, objectArray[n]);
        }
    }
}

