/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

class ModelProperty
extends Node.Property {
    PropertyModel mdl;
    private boolean valueSet = false;
    static /* synthetic */ Class class$java$lang$Object;

    private ModelProperty(PropertyModel propertyModel) {
        super(propertyModel.getPropertyType());
        FeatureDescriptor featureDescriptor;
        Boolean bl;
        this.mdl = propertyModel;
        if (this.mdl instanceof ExPropertyModel && (bl = (Boolean)(featureDescriptor = ((ExPropertyModel)this.mdl).getFeatureDescriptor()).getValue("canEditAsText")) != null) {
            this.setValue("canEditAsText", bl);
        }
    }

    Object[] getBeans() {
        if (this.mdl instanceof ExPropertyModel) {
            return ((ExPropertyModel)this.mdl).getBeans();
        }
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.mdl.getPropertyEditorClass() != null) {
            try {
                Constructor constructor = this.mdl.getPropertyEditorClass().getConstructor(null);
                constructor.setAccessible(true);
                return (PropertyEditor)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return new PropUtils.NoPropertyEditorEditor();
            }
        }
        return super.getPropertyEditor();
    }

    static Node.Property toProperty(PropertyModel propertyModel) {
        if (propertyModel instanceof NodePropertyModel) {
            return ((NodePropertyModel)propertyModel).getProperty();
        }
        if (propertyModel instanceof DefaultPropertyModel) {
            return new DPMWrapper((DefaultPropertyModel)propertyModel);
        }
        if (propertyModel instanceof ExPropertyModel && ((ExPropertyModel)propertyModel).getFeatureDescriptor() instanceof PropertyDescriptor) {
            Object[] objectArray = ((ExPropertyModel)propertyModel).getBeans();
            if (objectArray.length == 1) {
                return new DPMWrapper((PropertyDescriptor)((ExPropertyModel)propertyModel).getFeatureDescriptor(), ((ExPropertyModel)propertyModel).getBeans());
            }
            return new ModelProperty(propertyModel);
        }
        if (propertyModel instanceof ExPropertyModel && ((ExPropertyModel)propertyModel).getFeatureDescriptor() instanceof Node.Property) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("PropertyPanel now supports direct use of Node.Property objects.  Please do not use ExPropertyModel if you only need to wrap a Node.Property object.  PropertyModel will be deprecated soon.");
            ErrorManager.getDefault().notify(1, (Throwable)unsupportedOperationException);
            return (Node.Property)((ExPropertyModel)propertyModel).getFeatureDescriptor();
        }
        if (propertyModel != null) {
            return new ModelProperty(propertyModel);
        }
        return new EmptyProperty();
    }

    static Node.Property toProperty(Node[] nodeArray, String string) throws ClassCastException, NullPointerException {
        Node.Property property;
        Class clazz = null;
        if (nodeArray.length == 0) {
            throw new NullPointerException("Cannot find a property in an array of 0 properties.  Looking for " + string);
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            property = ModelProperty.findProperty(nodeArray[i], string);
            if (property == null) {
                throw new NullPointerException("Node " + nodeArray[i].getDisplayName() + " does not contain a property " + string);
            }
            if (clazz == null) {
                clazz = property.getValueType();
                continue;
            }
            if (property.getValueType() == clazz) continue;
            throw new ClassCastException("Found a property named " + nodeArray + " but it is of class " + property.getValueType().getName() + " not " + clazz.getName());
        }
        ProxyNode proxyNode = new ProxyNode(nodeArray);
        property = ModelProperty.findProperty((Node)proxyNode, string);
        if (property != null) {
            return property;
        }
        throw new NullPointerException("Found properties named " + string + " but ProxyNode did not contain one with this name.  This should " + "be impossible; probably someone has modified ProxyNode");
    }

    static Node.Property findProperty(Node node, String string) throws NullPointerException {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.Property property = ModelProperty.findProperty(propertySetArray[i], string);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    private static Node.Property findProperty(Node.PropertySet propertySet, String string) {
        Node.Property[] propertyArray = propertySet.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!propertyArray[i].getName().equals(string)) continue;
            return propertyArray[i];
        }
        return null;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.mdl.getValue();
    }

    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.mdl.setValue(object);
        this.valueSet = true;
    }

    FeatureDescriptor getFeatureDescriptor() {
        if (this.mdl instanceof ExPropertyModel) {
            return ((ExPropertyModel)this.mdl).getFeatureDescriptor();
        }
        return this;
    }

    private static String findDisplayNameFor(Object object) {
        try {
            BeanDescriptor beanDescriptor;
            if (object == null) {
                return null;
            }
            if (object instanceof Node.Property) {
                return ((Node.Property)object).getDisplayName();
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            if (beanInfo != null && (beanDescriptor = beanInfo.getBeanDescriptor()) != null) {
                return beanDescriptor.getDisplayName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static class DPMWrapper
    extends PropertySupport.Reflection {
        PropertyDescriptor descriptor;
        PropertyModel mdl;
        private String beanName = null;

        public DPMWrapper(DefaultPropertyModel defaultPropertyModel) {
            super(defaultPropertyModel.bean, defaultPropertyModel.getPropertyType(), ((PropertyDescriptor)defaultPropertyModel.getFeatureDescriptor()).getReadMethod(), ((PropertyDescriptor)defaultPropertyModel.getFeatureDescriptor()).getWriteMethod());
            this.descriptor = (PropertyDescriptor)defaultPropertyModel.getFeatureDescriptor();
            this.mdl = defaultPropertyModel;
            this.beanName = ModelProperty.findDisplayNameFor(defaultPropertyModel.bean);
        }

        public DPMWrapper(PropertyDescriptor propertyDescriptor, Object[] objectArray) {
            super(objectArray[0], propertyDescriptor.getPropertyType(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
            this.descriptor = propertyDescriptor;
            if (objectArray != null && objectArray.length == 1) {
                this.beanName = ModelProperty.findDisplayNameFor(objectArray[0]);
            }
        }

        public String getBeanName() {
            return this.beanName;
        }

        Object[] getBeans() {
            if (this.mdl instanceof DefaultPropertyModel) {
                return ((DefaultPropertyModel)this.mdl).getBeans();
            }
            return null;
        }

        FeatureDescriptor getFeatureDescriptor() {
            return this.descriptor;
        }

        public String getDisplayName() {
            return this.descriptor.getDisplayName();
        }

        public String getShortDescription() {
            return this.descriptor.getShortDescription();
        }

        public Object getValue(String string) {
            Object object = this.descriptor.getValue(string);
            if (object == null) {
                object = super.getValue(string);
            }
            return object;
        }

        public void setValue(String string, Object object) {
            this.descriptor.setValue(string, object);
        }

        public PropertyEditor getPropertyEditor() {
            Class<?> clazz = this.mdl != null ? this.mdl.getPropertyEditorClass() : this.descriptor.getPropertyEditorClass();
            if (clazz != null) {
                try {
                    return (PropertyEditor)clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.getPropertyEditor();
        }
    }

    private static class EmptyProperty
    extends Node.Property {
        public EmptyProperty() {
            super(class$java$lang$Object == null ? (class$java$lang$Object = ModelProperty.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return "";
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        }

        public PropertyEditor getPropertyEditor() {
            return new PropUtils.NoPropertyEditorEditor();
        }
    }
}

