/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CustomEditorAction;
import org.openide.explorer.propertysheet.EditorPropertyDisplayer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.ModelProperty;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyDisplayer_Editable;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class EditablePropertyDisplayer
extends EditorPropertyDisplayer
implements PropertyDisplayer_Editable {
    private static final Object NO_VALUE = new Object();
    private int updatePolicy = 0;
    private String actionCommand = "enterPressed";
    private EnvListener envListener = null;
    private EventListenerList listenerList = null;
    private int actionListenerCount = 0;
    private InplaceEditorListener ieListener = null;
    private Object cachedInitialValue = NO_VALUE;
    private Action customEditorAction = null;
    boolean customEditorIsOpening = false;
    private boolean committing = false;
    private PropertyEditor editor = null;
    private PropertyEnv attachedEnv = null;
    private Object lastKnownState = null;
    private PropertyChangeListener remoteEnvListener = null;
    private VetoableChangeListener remotevEnvListener = null;

    public EditablePropertyDisplayer(Node.Property property) {
        super(property, null);
    }

    EditablePropertyDisplayer(Node.Property property, PropertyModel propertyModel) {
        super(property, propertyModel);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.customEditorAction != null) {
            this.customEditorAction.setEnabled(bl);
        }
    }

    public boolean commit() throws IllegalArgumentException {
        boolean bl;
        try {
            bl = this._commit();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            if (this.getUpdatePolicy() != 2) {
                PropertyDialogManager.notify(illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _commit() throws IllegalArgumentException {
        this.committing = true;
        InplaceEditor inplaceEditor = this.getInplaceEditor();
        PropertyEditor propertyEditor = inplaceEditor == null ? PropUtils.getPropertyEditor(this.getProperty()) : inplaceEditor.getPropertyEditor();
        PropertyEnv propertyEnv = this.getPropertyEnv();
        PropertyEnv propertyEnv2 = null;
        if (propertyEnv != null) {
            propertyEnv2 = new PropertyEnv();
            this.detachFromEnv(propertyEnv);
            propertyEnv2.setFeatureDescriptor(EditablePropertyDisplayer.findFeatureDescriptor(this));
            if (propertyEditor instanceof ExPropertyEditor) {
                ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv2);
            }
        }
        boolean bl = false;
        try {
            Object object;
            Object object2 = PropUtils.updatePropertyEditor(this.getPropertyEditor(), this.getEnteredValue());
            if (object2 == null && propertyEditor instanceof ExPropertyEditor && PropertyEnv.STATE_NEEDS_VALIDATION.equals(propertyEnv2.getState())) {
                object = propertyEnv2.silentlySetState(PropertyEnv.STATE_VALID, this.getEnteredValue());
                if (object != null && !PropertyEnv.STATE_VALID.equals(propertyEnv.getState())) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                    ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, (String)object, null, null, null);
                    this.committing = false;
                    throw illegalArgumentException;
                }
            }
            if (object2 == null) {
                object2 = PropUtils.noDlgUpdateProp(inplaceEditor.getPropertyModel(), propertyEditor);
            }
            if (object2 instanceof Exception) {
                object = object2;
                if (!(object instanceof IllegalArgumentException)) {
                    String string = PropUtils.findLocalizedMessage((Throwable)object, this.getEnteredValue(), this.getProperty().getDisplayName());
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                    ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, "Cannot set value to " + this.getEnteredValue(), string, (Throwable)object, null);
                    throw illegalArgumentException;
                }
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)object;
                try {
                    propertyEditor.setValue(this.getProperty().getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.committing = false;
                throw illegalArgumentException;
            }
            bl = Boolean.TRUE.equals(object2);
            if (bl) {
                this.fireStateChanged();
            } else {
                object = this.getInplaceEditor();
                if (object != null) {
                    this.getInplaceEditor().reset();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.committing = false;
            if (propertyEnv != null && propertyEditor != null) {
                this.attachToEnv(propertyEnv);
                if (propertyEditor instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
                }
            }
        }
    }

    public Object getEnteredValue() {
        Object object;
        if (this.getInplaceEditor() != null) {
            object = this.getInplaceEditor().getValue();
        } else if (this.cachedInitialValue != NO_VALUE) {
            object = this.cachedInitialValue;
        } else {
            PropertyEditor propertyEditor = PropUtils.getPropertyEditor(this.getProperty());
            try {
                object = propertyEditor.getAsText();
            }
            catch (ProxyNode.DifferentValuesException differentValuesException) {
                object = null;
            }
        }
        return object;
    }

    PropertyEditor getPropertyEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        PropertyEditor propertyEditor = this.getInplaceEditor() != null ? this.getInplaceEditor().getPropertyEditor() : PropUtils.getPropertyEditor(this.getProperty());
        this.editor = propertyEditor;
        return propertyEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String isModifiedValueLegal() {
        String string;
        PropertyEditor propertyEditor = this.getPropertyEditor();
        PropertyEnv propertyEnv = null;
        Object object = this.getEnteredValue();
        PropertyEnv propertyEnv2 = this.getPropertyEnv();
        Exception exception = null;
        Object object2 = null;
        if (propertyEnv2 != null && PropertyEnv.STATE_NEEDS_VALIDATION.equals(propertyEnv2.getState())) {
            string = propertyEnv2.silentlySetState(PropertyEnv.STATE_VALID, object);
            if (string != null && !PropertyEnv.STATE_VALID.equals(propertyEnv2.getState())) {
                return string;
            }
        }
        try {
            if (propertyEditor instanceof ExPropertyEditor) {
                if (propertyEnv2 != null) {
                    this.detachFromEnv(propertyEnv2);
                }
                propertyEnv = new PropertyEnv();
                propertyEnv.setFeatureDescriptor(EditablePropertyDisplayer.findFeatureDescriptor(this));
                ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
            }
            exception = PropUtils.updatePropertyEditor(propertyEditor, object);
            object2 = propertyEnv == null ? null : propertyEnv.getState();
        }
        finally {
            if (propertyEditor instanceof ExPropertyEditor && propertyEnv2 != null) {
                try {
                    propertyEditor.setValue(this.getProperty().getValue());
                }
                catch (Exception exception2) {
                    ErrorManager.getDefault().notify(16, (Throwable)exception2);
                }
                ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv2);
                this.attachToEnv(propertyEnv2);
            }
        }
        string = null;
        if (exception != null) {
            string = PropUtils.findLocalizedMessage(exception, this.getEnteredValue(), this.getProperty().getDisplayName());
        } else if (PropertyEnv.STATE_INVALID.equals(object2)) {
            string = MessageFormat.format(NbBundle.getMessage((Class)EditablePropertyDisplayer.class, (String)"FMT_CannotUpdateProperty"), object, this.getProperty().getDisplayName());
        }
        return string;
    }

    public boolean isValueModified() {
        boolean bl = false;
        PropertyEditor propertyEditor = this.getPropertyEditor();
        Object object = this.getEnteredValue();
        Object object2 = null;
        Object object3 = null;
        try {
            object3 = propertyEditor.getValue();
        }
        catch (ProxyNode.DifferentValuesException differentValuesException) {
            return false;
        }
        if (object == null != (object3 == null)) {
            return true;
        }
        if (object2 == null) {
            object2 = object3;
        }
        bl = object2 == null != (object == null) ? true : (object2 == object ? false : (object2 != null ? !object2.equals(object) : false));
        return bl;
    }

    public void reset() {
        if (this.getInplaceEditor() != null) {
            this.getInplaceEditor().reset();
        }
    }

    public void setEnteredValue(Object object) {
        if (this.getInplaceEditor() != null) {
            this.getInplaceEditor().setValue(object);
        } else {
            this.storeCachedInitialValue(object);
        }
    }

    protected void setPropertyEnv(PropertyEnv propertyEnv) {
        if (this.getPropertyEnv() != null) {
            this.detachFromEnv(this.getPropertyEnv());
        }
        super.setPropertyEnv(propertyEnv);
        if (propertyEnv != null) {
            propertyEnv.setChangeImmediate(this.getUpdatePolicy() != 2);
            this.attachToEnv(this.getPropertyEnv());
        }
    }

    protected void setInplaceEditor(InplaceEditor inplaceEditor) {
        if (this.getInplaceEditor() != null) {
            this.detachFromInplaceEditor(this.getInplaceEditor());
        }
        super.setInplaceEditor(inplaceEditor);
        if (inplaceEditor == null && this.getPropertyEnv() != null) {
            this.detachFromEnv(this.getPropertyEnv());
        }
        if (this.getInplaceEditor() != null) {
            this.attachToInplaceEditor(this.getInplaceEditor());
        }
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(int n) {
        if (n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("Bad update policy: " + n);
        }
        this.updatePolicy = n;
        PropertyEnv propertyEnv = this.getPropertyEnv();
        if (propertyEnv != null) {
            propertyEnv.setChangeImmediate(n != 2);
        }
    }

    private void trySendEscToDialog() {
        if (this.isTableUI()) {
            return;
        }
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
            Action action;
            if (aWTEvent.getSource() instanceof JComboBox && ((JComboBox)aWTEvent.getSource()).isPopupVisible()) {
                return;
            }
            if (aWTEvent.getSource() instanceof JTextComponent && ((JTextComponent)aWTEvent.getSource()).getParent() instanceof JComboBox && ((JComboBox)((JTextComponent)aWTEvent.getSource()).getParent()).isPopupVisible()) {
                return;
            }
            InputMap inputMap = this.getRootPane().getInputMap(1);
            ActionMap actionMap = this.getRootPane().getActionMap();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
            Object object = inputMap.get(keyStroke);
            if (object != null && (action = actionMap.get(object)) != null) {
                String string;
                if (Boolean.getBoolean("netbeans.proppanel.logDialogActions")) {
                    System.err.println("Action bound to escape key is " + action);
                }
                if ((string = (String)action.getValue("ActionCommandKey")) == null) {
                    string = "cancel";
                }
                action.actionPerformed(new ActionEvent(this, 1001, string));
            }
        }
    }

    private void trySendEnterToDialog() {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 10) {
            JButton jButton;
            if (aWTEvent.getSource() instanceof JComboBox && ((JComboBox)aWTEvent.getSource()).isPopupVisible()) {
                return;
            }
            if (aWTEvent.getSource() instanceof JTextComponent && ((JTextComponent)aWTEvent.getSource()).getParent() instanceof JComboBox && ((JComboBox)((JTextComponent)aWTEvent.getSource()).getParent()).isPopupVisible()) {
                return;
            }
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != null && jButton.isEnabled()) {
                jButton.doClick();
            }
        }
    }

    private void attachToEnv(PropertyEnv propertyEnv) {
        if (this.attachedEnv == propertyEnv) {
            return;
        }
        propertyEnv.addVetoableChangeListener(this.getEnvListener());
        propertyEnv.addPropertyChangeListener(this.getEnvListener());
        propertyEnv.setBeans(EditablePropertyDisplayer.findBeans(this));
    }

    private void detachFromEnv(PropertyEnv propertyEnv) {
        propertyEnv.removeVetoableChangeListener(this.getEnvListener());
        propertyEnv.addPropertyChangeListener(this.getEnvListener());
        propertyEnv.setBeans(null);
        this.attachedEnv = null;
    }

    private void attachToInplaceEditor(InplaceEditor inplaceEditor) {
        Object object = this.fetchCachedInitialValue();
        if (object != NO_VALUE) {
            inplaceEditor.setValue(object);
        }
        inplaceEditor.addActionListener(this.getInplaceEditorListener());
        inplaceEditor.getComponent().addFocusListener(this.getInplaceEditorListener());
    }

    private void detachFromInplaceEditor(InplaceEditor inplaceEditor) {
        inplaceEditor.removeActionListener(this.getInplaceEditorListener());
        inplaceEditor.getComponent().removeFocusListener(this.getInplaceEditorListener());
    }

    private void storeCachedInitialValue(Object object) {
        this.cachedInitialValue = object;
    }

    private Object fetchCachedInitialValue() {
        Object object = this.cachedInitialValue;
        this.cachedInitialValue = NO_VALUE;
        return object;
    }

    private InplaceEditorListener getInplaceEditorListener() {
        if (this.ieListener == null) {
            this.ieListener = new InplaceEditorListener();
        }
        return this.ieListener;
    }

    private EnvListener getEnvListener() {
        if (this.envListener == null) {
            this.envListener = new EnvListener();
        }
        return this.envListener;
    }

    private boolean hasActionListeners() {
        return this.actionListenerCount > 0;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, actionListener);
        ++this.actionListenerCount;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
        this.actionListenerCount = Math.max(0, this.actionListenerCount--);
    }

    private void fireActionPerformed() {
        if (this.listenerList == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ActionListener == null ? EditablePropertyDisplayer.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? EditablePropertyDisplayer.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    private boolean shouldIgnoreFocusEvents() {
        return this.customEditorIsOpening || this.inReplaceInner;
    }

    protected void configureButtonPanel(ButtonPanel buttonPanel) {
        buttonPanel.setButtonAction(this.getCustomEditorAction());
    }

    Action getCustomEditorAction() {
        if (this.customEditorAction == null) {
            PropertyModel propertyModel = null;
            if (this.modelRef != null) {
                propertyModel = (PropertyModel)this.modelRef.get();
            }
            this.customEditorAction = new CustomEditorAction(new Invoker(), propertyModel);
            this.getInputMap(1).put(KeyStroke.getKeyStroke(32, 128, false), "invokeCustomEditor");
            this.getActionMap().put("invokeCustomEditor", this.customEditorAction);
        }
        return this.customEditorAction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Inline editor for property ");
        stringBuffer.append(this.getProperty().getDisplayName());
        stringBuffer.append(" = ");
        stringBuffer.append(this.getProperty());
        stringBuffer.append(" inplace editor=");
        stringBuffer.append(this.getInplaceEditor());
        return stringBuffer.toString();
    }

    void setRemoteEnvListener(PropertyChangeListener propertyChangeListener) {
        this.remoteEnvListener = propertyChangeListener;
    }

    void setRemoteEnvVetoListener(VetoableChangeListener vetoableChangeListener) {
        this.remotevEnvListener = vetoableChangeListener;
    }

    public synchronized void dispose() {
        this.setPropertyEnv(null);
        this.setInplaceEditor(null);
        this.remotevEnvListener = null;
        this.remoteEnvListener = null;
        this.cachedInitialValue = null;
        this.editor = null;
    }

    public ReusablePropertyEnv getReusablePropertyEnv() {
        return null;
    }

    private class EnvListener
    implements VetoableChangeListener,
    PropertyChangeListener {
        private boolean wantNextChange = false;

        private EnvListener() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("state".equals(propertyChangeEvent.getPropertyName())) {
                boolean bl = this.wantNextChange = propertyChangeEvent.getNewValue() != EditablePropertyDisplayer.this.getPropertyEnv().getState() && EditablePropertyDisplayer.this.getPropertyEnv().getState() != null && (propertyChangeEvent.getNewValue() != PropertyEnv.STATE_NEEDS_VALIDATION || propertyChangeEvent.getNewValue() == PropertyEnv.STATE_NEEDS_VALIDATION && propertyChangeEvent.getOldValue() == PropertyEnv.STATE_VALID);
            }
            if (!EditablePropertyDisplayer.this.inReplaceInner && EditablePropertyDisplayer.this.remotevEnvListener != null) {
                EditablePropertyDisplayer.this.remotevEnvListener.vetoableChange(propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (EditablePropertyDisplayer.this.inReplaceInner) {
                return;
            }
            if (this.wantNextChange || propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID && propertyChangeEvent.getNewValue() != EditablePropertyDisplayer.this.lastKnownState) {
                this.wantNextChange = false;
                EditablePropertyDisplayer.this.replaceInner();
                EditablePropertyDisplayer.this.lastKnownState = ((PropertyEnv)propertyChangeEvent.getSource()).getState();
            }
            if (EditablePropertyDisplayer.this.remoteEnvListener != null) {
                EditablePropertyDisplayer.this.remoteEnvListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private class InplaceEditorListener
    implements ActionListener,
    FocusListener {
        private InplaceEditorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = bl = "success".equals(actionEvent.getActionCommand()) || "comboBoxEdited".equals(actionEvent.getActionCommand());
            if (bl) {
                if (EditablePropertyDisplayer.this.getUpdatePolicy() == 0 || EditablePropertyDisplayer.this.getUpdatePolicy() == 1) {
                    EditablePropertyDisplayer.this.commit();
                }
                if (EditablePropertyDisplayer.this.hasActionListeners()) {
                    EditablePropertyDisplayer.this.fireActionPerformed();
                } else {
                    EditablePropertyDisplayer.this.trySendEnterToDialog();
                }
            } else if (!EditablePropertyDisplayer.this.hasActionListeners()) {
                EditablePropertyDisplayer.this.trySendEscToDialog();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (EditablePropertyDisplayer.this.shouldIgnoreFocusEvents()) {
                return;
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (EditablePropertyDisplayer.this.shouldIgnoreFocusEvents()) {
                return;
            }
            if (!focusEvent.isTemporary() && EditablePropertyDisplayer.this.getUpdatePolicy() == 1 && !EditablePropertyDisplayer.this.getInplaceEditor().isKnownComponent(focusEvent.getOppositeComponent()) && EditablePropertyDisplayer.this.isValueModified()) {
                EditablePropertyDisplayer.this.commit();
            }
        }
    }

    private class Invoker
    implements CustomEditorAction.Invoker {
        boolean failed = false;

        private Invoker() {
        }

        public boolean allowInvoke() {
            return true;
        }

        public void editorClosed() {
            if (this.failed) {
                EditablePropertyDisplayer.this.requestFocus();
            }
            EditablePropertyDisplayer.this.customEditorIsOpening = false;
        }

        public void editorOpened() {
            EditablePropertyDisplayer.this.customEditorIsOpening = false;
            EditablePropertyDisplayer.this.repaint();
        }

        public void editorOpening() {
            EditablePropertyDisplayer.this.customEditorIsOpening = true;
        }

        public void failed() {
            this.failed = true;
            if (EditablePropertyDisplayer.this.getInplaceEditor() != null) {
                EditablePropertyDisplayer.this.getInplaceEditor().reset();
            }
        }

        public String getBeanName() {
            PropertyModel propertyModel;
            if (EditablePropertyDisplayer.this.modelRef != null && (propertyModel = (PropertyModel)EditablePropertyDisplayer.this.modelRef.get()) instanceof NodePropertyModel) {
                return ((NodePropertyModel)propertyModel).getBeanName();
            }
            if (EditablePropertyDisplayer.this.getProperty() instanceof ModelProperty.DPMWrapper) {
                return ((ModelProperty.DPMWrapper)EditablePropertyDisplayer.this.getProperty()).getBeanName();
            }
            return EditorPropertyDisplayer.findFeatureDescriptor(EditablePropertyDisplayer.this).getDisplayName();
        }

        public Component getCursorChangeComponent() {
            return EditablePropertyDisplayer.this;
        }

        public Object getPartialValue() {
            return EditablePropertyDisplayer.this.getEnteredValue();
        }

        public FeatureDescriptor getSelection() {
            return EditablePropertyDisplayer.this.getProperty();
        }

        public void valueChanged(PropertyEditor propertyEditor) {
            this.failed = false;
            try {
                if (EditablePropertyDisplayer.this.getInplaceEditor() != null) {
                    EditablePropertyDisplayer.this.setEnteredValue(EditablePropertyDisplayer.this.getProperty().getValue());
                } else {
                    PropertyModel propertyModel;
                    PropertyModel propertyModel2 = propertyModel = EditablePropertyDisplayer.this.modelRef != null ? (PropertyModel)EditablePropertyDisplayer.this.modelRef.get() : null;
                    if (propertyModel != null) {
                        FeatureDescriptor featureDescriptor = null;
                        if (propertyModel instanceof ExPropertyModel) {
                            featureDescriptor = ((ExPropertyModel)propertyModel).getFeatureDescriptor();
                        }
                        String string = null;
                        if (featureDescriptor != null) {
                            string = featureDescriptor.getDisplayName();
                        }
                        this.failed = PropUtils.updateProp(propertyModel, propertyEditor, string);
                    }
                }
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException("Problem setting entered value from custom editor");
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)exception);
                throw illegalStateException;
            }
        }

        public boolean wantAllChanges() {
            return true;
        }

        public ReusablePropertyEnv getReusablePropertyEnv() {
            return EditablePropertyDisplayer.this.getReusablePropertyEnv();
        }
    }
}

