/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.SheetTable;
import org.openide.explorer.propertysheet.SheetTableModel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class CustomEditorAction
extends AbstractAction {
    private Invoker invoker;
    private WeakReference modelRef = null;

    public CustomEditorAction(Invoker invoker) {
        this.invoker = invoker;
        this.putValue("SmallIcon", PropUtils.getCustomButtonIcon());
    }

    public CustomEditorAction(Invoker invoker, PropertyModel propertyModel) {
        this(invoker);
        if (propertyModel != null) {
            this.modelRef = new WeakReference<PropertyModel>(propertyModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Node.Property property;
        if (PropUtils.isLoggable(CustomEditorAction.class)) {
            PropUtils.log(CustomEditorAction.class, "CustomEditorAction invoked " + actionEvent);
        }
        if (!this.invoker.allowInvoke()) {
            if (PropUtils.isLoggable(CustomEditorAction.class)) {
                PropUtils.log(CustomEditorAction.class, "Invoker (" + this.invoker.getClass() + " allowInvoke() returned false.  Aborting.");
            }
            return;
        }
        PropertyModel propertyModel = this.modelRef != null ? (PropertyModel)this.modelRef.get() : null;
        FeatureDescriptor featureDescriptor = this.invoker.getSelection();
        Node.Property property2 = property = featureDescriptor instanceof Node.Property ? (Node.Property)featureDescriptor : null;
        if (property == null) {
            if (PropUtils.isLoggable(CustomEditorAction.class)) {
                PropUtils.log(CustomEditorAction.class, "Cant invoke custom editor on " + featureDescriptor + " it is null or not a Property." + "Aborting.");
            }
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final PropertyEditor propertyEditor = PropUtils.getPropertyEditor(property);
        PropertyEnv propertyEnv = null;
        if (propertyEditor instanceof ExPropertyEditor) {
            if (PropUtils.isLoggable(CustomEditorAction.class)) {
                PropUtils.log(CustomEditorAction.class, "Editor is an ExPropertyEditor, attaching a PropertyEnv");
            }
            propertyEnv = new PropertyEnv();
            propertyEnv.setFeatureDescriptor(featureDescriptor);
            if (this.invoker instanceof SheetTable) {
                if (PropUtils.isLoggable(CustomEditorAction.class)) {
                    PropUtils.log(CustomEditorAction.class, "env.setBeans to " + this.invoker.getReusablePropertyEnv().getBeans());
                }
                propertyEnv.setBeans(this.invoker.getReusablePropertyEnv().getBeans());
            }
            ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
        }
        if (!propertyEditor.supportsCustomEditor()) {
            if (PropUtils.isLoggable(CustomEditorAction.class)) {
                PropUtils.log(CustomEditorAction.class, "Cant invoke custom editor for editor " + propertyEditor + " - it returns false " + "from supportsCustomEditor().");
            }
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final Component component = this.invoker.getCursorChangeComponent();
        Cursor cursor = Cursor.getPredefinedCursor(3);
        component.setCursor(cursor);
        try {
            PropertyChangeListener propertyChangeListener;
            Object object = this.invoker.getPartialValue();
            if (object != null) {
                try {
                    if (!(propertyEditor.getValue() != null && object.toString().equals(propertyEditor.getAsText()) || propertyEditor instanceof PropUtils.DifferentValuesEditor)) {
                        propertyEditor.setAsText(object.toString());
                    }
                }
                catch (ProxyNode.DifferentValuesException differentValuesException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            final PropertyModel propertyModel2 = propertyModel == null ? new NodePropertyModel(property, null) : propertyModel;
            String string = propertyModel2 instanceof ExPropertyModel && ((ExPropertyModel)propertyModel2).getFeatureDescriptor() != null ? ((ExPropertyModel)propertyModel2).getFeatureDescriptor().getDisplayName() : null;
            String string2 = (String)property.getValue("title");
            final String string3 = string2 == null ? (featureDescriptor.getDisplayName() == null ? MessageFormat.format(NbBundle.getMessage((Class)SheetTable.class, (String)"FMT_CUSTOM_DLG_NOPROPNAME_TITLE"), string == null ? this.invoker.getBeanName() : string) : MessageFormat.format(NbBundle.getMessage((Class)SheetTable.class, (String)"FMT_CUSTOM_DLG_TITLE"), this.invoker.getBeanName(), featureDescriptor.getDisplayName())) : string2;
            final PropertyDialogManager propertyDialogManager = new PropertyDialogManager(NbBundle.getMessage((Class)SheetTableModel.class, (String)"PS_EditorTitle", (Object)(string3 == null ? "" : string3), (Object)property.getValueType()), true, propertyEditor, propertyModel2, propertyEnv);
            boolean bl = !(propertyDialogManager.getComponent() instanceof EnhancedCustomPropertyEditor) && property.canWrite() && (this.invoker.wantAllChanges() || propertyEnv == null || propertyEnv.isChangeImmediate());
            PropertyChangeListener propertyChangeListener2 = propertyChangeListener = !bl ? null : new PropertyChangeListener(){
                private boolean updating = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.updating) {
                        return;
                    }
                    this.updating = true;
                    try {
                        boolean bl = PropUtils.updateProp(propertyModel2, propertyEditor, string3);
                        if (bl) {
                            CustomEditorAction.this.invoker.valueChanged(propertyEditor);
                        } else {
                            CustomEditorAction.this.invoker.failed();
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            };
            if (propertyChangeListener != null) {
                propertyEditor.addPropertyChangeListener(propertyChangeListener);
            }
            final Window window = propertyDialogManager.getDialog();
            WindowAdapter windowAdapter = new WindowAdapter(){
                boolean closedOption = false;

                public void windowClosed(WindowEvent windowEvent) {
                    if (!(!(propertyDialogManager.getComponent() instanceof EnhancedCustomPropertyEditor) || propertyDialogManager.wasCancelled() || this.closedOption || propertyDialogManager.wasOK() || propertyDialogManager.wasReset())) {
                        try {
                            propertyDialogManager.getEditor().setValue(((EnhancedCustomPropertyEditor)((Object)propertyDialogManager.getComponent())).getPropertyValue());
                            CustomEditorAction.this.invoker.valueChanged(propertyDialogManager.getEditor());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    CustomEditorAction.this.invoker.editorClosed();
                    window.removeWindowListener(this);
                    if (propertyChangeListener != null) {
                        propertyEditor.removePropertyChangeListener(propertyChangeListener);
                    }
                }

                public void windowOpened(WindowEvent windowEvent) {
                    CustomEditorAction.this.invoker.editorOpened();
                    component.setCursor(Cursor.getPredefinedCursor(0));
                }

                public void windowClosing(WindowEvent windowEvent) {
                    if (PropUtils.isLoggable(class$org$openide$explorer$propertysheet$CustomEditorAction == null ? (class$org$openide$explorer$propertysheet$CustomEditorAction = CustomEditorAction.class$("org.openide.explorer.propertysheet.CustomEditorAction")) : class$org$openide$explorer$propertysheet$CustomEditorAction)) {
                        PropUtils.log(class$org$openide$explorer$propertysheet$CustomEditorAction == null ? (class$org$openide$explorer$propertysheet$CustomEditorAction = CustomEditorAction.class$("org.openide.explorer.propertysheet.CustomEditorAction")) : class$org$openide$explorer$propertysheet$CustomEditorAction, "CustomerEditorAction windowClosing event");
                    }
                    this.closedOption = true;
                }
            };
            if (window instanceof JDialog) {
                JDialog jDialog = (JDialog)window;
                jDialog.getAccessibleContext().setAccessibleName(string3);
                if (featureDescriptor.getShortDescription() != null) {
                    jDialog.getAccessibleContext().setAccessibleDescription(featureDescriptor.getShortDescription());
                }
                window.addWindowListener(windowAdapter);
            } else if (window instanceof Frame) {
                ((Frame)window).addWindowListener(windowAdapter);
            }
            this.invoker.editorOpening();
            try {
                PropUtils.addExternallyEdited(property);
                window.show();
                PropUtils.removeExternallyEdited(property);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        finally {
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    static interface Invoker {
        public FeatureDescriptor getSelection();

        public Object getPartialValue();

        public Component getCursorChangeComponent();

        public String getBeanName();

        public void editorOpening();

        public void editorOpened();

        public void editorClosed();

        public void valueChanged(PropertyEditor var1);

        public boolean allowInvoke();

        public void failed();

        public boolean wantAllChanges();

        public ReusablePropertyEnv getReusablePropertyEnv();
    }
}

