/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.NbBundle;

class CheckboxInplaceEditor
extends JCheckBox
implements InplaceEditor {
    protected PropertyEditor editor = null;
    protected PropertyEnv env = null;
    private boolean useTitle = false;
    private String text = null;
    private PropertyModel pm = null;

    public CheckboxInplaceEditor() {
        this.setActionCommand("success");
    }

    public void setUseTitle(boolean bl) {
        if (this.useTitle != bl) {
            this.useTitle = bl;
            this.text = null;
            if (this.env != null) {
                this.setText(this.env.getFeatureDescriptor().getDisplayName());
            }
        }
    }

    public void setSelected(boolean bl) {
        boolean bl2 = bl == this.isSelected();
        String string = this.getText();
        super.setSelected(bl);
        if (bl2) {
            this.firePropertyChange("text", string, this.getText());
        }
    }

    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.text = null;
        if (this.editor instanceof PropUtils.NoPropertyEditorEditor) {
            this.setSelected(false);
            return;
        }
        if (this.editor == propertyEditor) {
            return;
        }
        this.editor = propertyEditor;
        this.setSelected(Boolean.TRUE.equals(propertyEditor.getValue()));
        this.reset();
        this.env = propertyEnv;
        if (propertyEnv != null && this.useTitle) {
            this.setText(propertyEnv.getFeatureDescriptor().getDisplayName());
        }
    }

    public void clear() {
        this.editor = null;
        this.pm = null;
        this.env = null;
        this.text = null;
        this.getModel().setRollover(false);
    }

    public JComponent getComponent() {
        return this;
    }

    public Object getValue() {
        return this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    public void reset() {
        if (this.editor instanceof PropUtils.NoPropertyEditorEditor) {
            return;
        }
        if (this.editor != null) {
            Boolean bl = (Boolean)this.editor.getValue();
            if (bl == null) {
                this.getModel().setArmed(true);
            } else {
                this.setSelected(bl);
            }
        }
    }

    public String getText() {
        if (this.text == null) {
            if (this.useTitle || this.editor == null || this.editor.getTags() == null) {
                this.text = super.getText();
            } else if (PropUtils.noCheckboxCaption) {
                this.text = "";
            } else {
                String[] stringArray;
                Boolean bl;
                String string = NbBundle.getMessage((Class)CheckboxInplaceEditor.class, (String)"BOOLEAN_PREPEND");
                String string2 = NbBundle.getMessage((Class)CheckboxInplaceEditor.class, (String)"BOOLEAN_APPEND");
                MessageFormat messageFormat = new MessageFormat(NbBundle.getMessage((Class)CheckboxInplaceEditor.class, (String)"FMT_BOOLEAN"));
                Boolean bl2 = bl = this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                String string3 = bl.equals(this.editor.getValue()) ? this.editor.getAsText() : ((stringArray = this.editor.getTags())[0].equals(this.editor.getAsText()) ? stringArray[1] : stringArray[0]);
                this.text = messageFormat.format(new String[]{string, string3, string2});
            }
        }
        return this.text;
    }

    public KeyStroke[] getKeyStrokes() {
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public void handleInitialInputEvent(InputEvent inputEvent) {
        boolean bl = false;
        if (inputEvent instanceof MouseEvent) {
            bl = true;
        } else if (inputEvent instanceof KeyEvent && ((KeyEvent)inputEvent).getKeyCode() == 32) {
            bl = true;
        }
        if (bl) {
            this.setSelected(!this.isSelected());
            this.fireActionPerformed(new ActionEvent(this, 1001, "success"));
            this.getModel().setPressed(false);
        }
    }

    public void setValue(Object object) {
        if (object == null) {
            this.setSelected(false);
        }
        if (Boolean.TRUE.equals(object)) {
            this.setSelected(true);
        } else if (Boolean.FALSE.equals(object)) {
            this.setSelected(false);
        }
    }

    public boolean supportsTextEntry() {
        return false;
    }

    public PropertyModel getPropertyModel() {
        return this.pm;
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.pm = propertyModel;
    }

    public boolean isKnownComponent(Component component) {
        return false;
    }

    public Dimension getPreferredSize() {
        Insets insets;
        if (this.isShowing()) {
            return super.getPreferredSize();
        }
        Dimension dimension = PropUtils.getMinimumPanelSize();
        Graphics graphics = PropUtils.getScratchGraphics(this);
        graphics.setFont(this.getFont());
        String string = this.getText();
        Icon icon = this.getIcon();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        if (icon != null) {
            n += icon.getIconWidth() + this.getIconTextGap();
            n2 = Math.max(n2, dimension.height);
        }
        if ((insets = this.getInsets()) != null) {
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        dimension.width = Math.max(dimension.width, n += 22);
        dimension.height = Math.max(dimension.height, n2);
        return dimension;
    }
}

